/*
 * Decompiled with CFR 0.152.
 */
package buildcraft;

import buildcraft.BuildCraftBuilders;
import buildcraft.BuildCraftEnergy;
import buildcraft.BuildCraftFactory;
import buildcraft.BuildCraftMod;
import buildcraft.BuildCraftSilicon;
import buildcraft.api.blueprints.BuilderAPI;
import buildcraft.api.core.BCLog;
import buildcraft.api.core.BuildCraftAPI;
import buildcraft.api.core.EnumColor;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.core.IWorldProperty;
import buildcraft.api.core.JavaTools;
import buildcraft.api.fuels.BuildcraftFuelRegistry;
import buildcraft.api.recipes.BuildcraftRecipeRegistry;
import buildcraft.api.robots.RobotManager;
import buildcraft.api.statements.IActionExternal;
import buildcraft.api.statements.IActionInternal;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.ITriggerExternal;
import buildcraft.api.statements.ITriggerInternal;
import buildcraft.api.statements.StatementManager;
import buildcraft.api.statements.StatementParameterItemStack;
import buildcraft.api.tiles.IControllable;
import buildcraft.core.BlockSpring;
import buildcraft.core.BuildCraftConfiguration;
import buildcraft.core.CommandBuildCraft;
import buildcraft.core.CoreIconProvider;
import buildcraft.core.GuiHandler;
import buildcraft.core.InterModComms;
import buildcraft.core.ItemGear;
import buildcraft.core.ItemList;
import buildcraft.core.ItemMapLocation;
import buildcraft.core.ItemSpring;
import buildcraft.core.ItemWrench;
import buildcraft.core.SpringPopulate;
import buildcraft.core.TickHandlerCore;
import buildcraft.core.Version;
import buildcraft.core.blueprints.SchematicRegistry;
import buildcraft.core.network.BuildCraftChannelHandler;
import buildcraft.core.network.PacketHandler;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.recipes.AssemblyRecipeManager;
import buildcraft.core.recipes.IntegrationRecipeManager;
import buildcraft.core.recipes.ProgrammingRecipeManager;
import buildcraft.core.recipes.RefineryRecipeManager;
import buildcraft.core.render.BlockHighlightHandler;
import buildcraft.core.statements.ActionMachineControl;
import buildcraft.core.statements.ActionRedstoneOutput;
import buildcraft.core.statements.DefaultActionProvider;
import buildcraft.core.statements.DefaultTriggerProvider;
import buildcraft.core.statements.StatementParameterDirection;
import buildcraft.core.statements.StatementParameterRedstoneGateSideOnly;
import buildcraft.core.statements.TriggerEnergy;
import buildcraft.core.statements.TriggerFluidContainer;
import buildcraft.core.statements.TriggerFluidContainerLevel;
import buildcraft.core.statements.TriggerInventory;
import buildcraft.core.statements.TriggerInventoryLevel;
import buildcraft.core.statements.TriggerMachine;
import buildcraft.core.statements.TriggerRedstoneInput;
import buildcraft.core.utils.ColorUtils;
import buildcraft.core.utils.CraftingHandler;
import buildcraft.core.utils.WorldPropertyIsDirt;
import buildcraft.core.utils.WorldPropertyIsFarmland;
import buildcraft.core.utils.WorldPropertyIsFluidSource;
import buildcraft.core.utils.WorldPropertyIsHarvestable;
import buildcraft.core.utils.WorldPropertyIsLeaf;
import buildcraft.core.utils.WorldPropertyIsOre;
import buildcraft.core.utils.WorldPropertyIsShoveled;
import buildcraft.core.utils.WorldPropertyIsSoft;
import buildcraft.core.utils.WorldPropertyIsWood;
import buildcraft.energy.fuels.CoolantManager;
import buildcraft.energy.fuels.FuelManager;
import buildcraft.robots.EntityRobot;
import buildcraft.robots.ResourceIdAssemblyTable;
import buildcraft.robots.ResourceIdBlock;
import buildcraft.robots.ResourceIdRequest;
import buildcraft.robots.ai.AIRobotAttack;
import buildcraft.robots.ai.AIRobotBreak;
import buildcraft.robots.ai.AIRobotCraftAssemblyTable;
import buildcraft.robots.ai.AIRobotCraftFurnace;
import buildcraft.robots.ai.AIRobotCraftWorkbench;
import buildcraft.robots.ai.AIRobotDeliverRequested;
import buildcraft.robots.ai.AIRobotDisposeItems;
import buildcraft.robots.ai.AIRobotFetchAndEquipItemStack;
import buildcraft.robots.ai.AIRobotFetchItem;
import buildcraft.robots.ai.AIRobotGoAndLinkToDock;
import buildcraft.robots.ai.AIRobotGoto;
import buildcraft.robots.ai.AIRobotGotoBlock;
import buildcraft.robots.ai.AIRobotGotoSleep;
import buildcraft.robots.ai.AIRobotGotoStation;
import buildcraft.robots.ai.AIRobotGotoStationAndLoad;
import buildcraft.robots.ai.AIRobotGotoStationAndLoadFluids;
import buildcraft.robots.ai.AIRobotGotoStationAndUnload;
import buildcraft.robots.ai.AIRobotGotoStationToLoad;
import buildcraft.robots.ai.AIRobotGotoStationToLoadFluids;
import buildcraft.robots.ai.AIRobotGotoStationToUnload;
import buildcraft.robots.ai.AIRobotGotoStationToUnloadFluids;
import buildcraft.robots.ai.AIRobotLoad;
import buildcraft.robots.ai.AIRobotLoadFluids;
import buildcraft.robots.ai.AIRobotMain;
import buildcraft.robots.ai.AIRobotPumpBlock;
import buildcraft.robots.ai.AIRobotRecharge;
import buildcraft.robots.ai.AIRobotSearchAndGotoStation;
import buildcraft.robots.ai.AIRobotSearchBlock;
import buildcraft.robots.ai.AIRobotSearchEntity;
import buildcraft.robots.ai.AIRobotSearchRandomBlock;
import buildcraft.robots.ai.AIRobotSearchRandomGroundBlock;
import buildcraft.robots.ai.AIRobotSearchStackRequest;
import buildcraft.robots.ai.AIRobotSearchStation;
import buildcraft.robots.ai.AIRobotSleep;
import buildcraft.robots.ai.AIRobotStraightMoveTo;
import buildcraft.robots.ai.AIRobotUnload;
import buildcraft.robots.ai.AIRobotUnloadFluids;
import buildcraft.robots.ai.AIRobotUseToolOnBlock;
import buildcraft.robots.boards.BoardRobotBomber;
import buildcraft.robots.boards.BoardRobotBuilder;
import buildcraft.robots.boards.BoardRobotButcher;
import buildcraft.robots.boards.BoardRobotCarrier;
import buildcraft.robots.boards.BoardRobotCrafter;
import buildcraft.robots.boards.BoardRobotDelivery;
import buildcraft.robots.boards.BoardRobotFarmer;
import buildcraft.robots.boards.BoardRobotFluidCarrier;
import buildcraft.robots.boards.BoardRobotHarvester;
import buildcraft.robots.boards.BoardRobotKnight;
import buildcraft.robots.boards.BoardRobotLeaveCutter;
import buildcraft.robots.boards.BoardRobotLumberjack;
import buildcraft.robots.boards.BoardRobotMiner;
import buildcraft.robots.boards.BoardRobotPicker;
import buildcraft.robots.boards.BoardRobotPlanter;
import buildcraft.robots.boards.BoardRobotPump;
import buildcraft.robots.boards.BoardRobotShovelman;
import buildcraft.robots.boards.BoardRobotStripes;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.channel.ChannelHandler;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.command.ICommand;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.AchievementPage;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.oredict.OreDictionary;

@Mod(name="BuildCraft", version="6.4.10", useMetadata=false, modid="BuildCraft|Core", acceptedMinecraftVersions="[1.7.10,1.8)", dependencies="required-after:Forge@[10.13.2.1236,)")
public class BuildCraftCore
extends BuildCraftMod {
    @Mod.Instance(value="BuildCraft|Core")
    public static BuildCraftCore instance;
    public static final boolean NONRELEASED_BLOCKS = true;
    public static RenderMode render;
    public static boolean debugWorldgen;
    public static boolean modifyWorld;
    public static boolean colorBlindMode;
    public static boolean hidePowerNumbers;
    public static boolean hideFluidNumbers;
    public static int itemLifespan;
    public static int updateFactor;
    public static long longUpdateFactor;
    public static BuildCraftConfiguration mainConfiguration;
    public static Block springBlock;
    public static Item woodenGearItem;
    public static Item stoneGearItem;
    public static Item ironGearItem;
    public static Item goldGearItem;
    public static Item diamondGearItem;
    public static Item wrenchItem;
    public static Item mapLocationItem;
    public static ItemList listItem;
    @SideOnly(value=Side.CLIENT)
    public static IIcon redLaserTexture;
    @SideOnly(value=Side.CLIENT)
    public static IIcon blueLaserTexture;
    @SideOnly(value=Side.CLIENT)
    public static IIcon stripesLaserTexture;
    @SideOnly(value=Side.CLIENT)
    public static IIcon transparentTexture;
    @SideOnly(value=Side.CLIENT)
    public static IIconProvider iconProvider;
    public static int blockByEntityModel;
    public static int legacyPipeModel;
    public static int markerModel;
    public static ITriggerExternal triggerMachineActive;
    public static ITriggerExternal triggerMachineInactive;
    public static IStatement triggerEnergyHigh;
    public static IStatement triggerEnergyLow;
    public static ITriggerExternal triggerEmptyInventory;
    public static ITriggerExternal triggerContainsInventory;
    public static ITriggerExternal triggerSpaceInventory;
    public static ITriggerExternal triggerFullInventory;
    public static ITriggerExternal triggerEmptyFluid;
    public static ITriggerExternal triggerContainsFluid;
    public static ITriggerExternal triggerSpaceFluid;
    public static ITriggerExternal triggerFullFluid;
    public static ITriggerInternal triggerRedstoneActive;
    public static ITriggerInternal triggerRedstoneInactive;
    public static ITriggerExternal triggerInventoryBelow25;
    public static ITriggerExternal triggerInventoryBelow50;
    public static ITriggerExternal triggerInventoryBelow75;
    public static ITriggerExternal triggerFluidContainerBelow25;
    public static ITriggerExternal triggerFluidContainerBelow50;
    public static ITriggerExternal triggerFluidContainerBelow75;
    public static IActionInternal actionRedstone;
    public static IActionExternal[] actionControl;
    public static boolean loadDefaultRecipes;
    public static boolean consumeWaterSources;
    public static Achievement woodenGearAchievement;
    public static Achievement stoneGearAchievement;
    public static Achievement ironGearAchievement;
    public static Achievement goldGearAchievement;
    public static Achievement diamondGearAchievement;
    public static Achievement wrenchAchievement;
    public static Achievement engineAchievement1;
    public static Achievement engineAchievement2;
    public static Achievement engineAchievement3;
    public static Achievement aLotOfCraftingAchievement;
    public static Achievement straightDownAchievement;
    public static Achievement chunkDestroyerAchievement;
    public static Achievement fasterFillingAchievement;
    public static Achievement timeForSomeLogicAchievement;
    public static Achievement refineAndRedefineAchievement;
    public static Achievement tinglyLaserAchievement;
    public static Achievement architectAchievement;
    public static Achievement builderAchievement;
    public static Achievement blueprintAchievement;
    public static Achievement templateAchievement;
    public static Achievement libraryAchievement;
    public static AchievementPage BuildcraftAchievements;
    public static HashSet<String> recipesBlacklist;
    public static float diffX;
    public static float diffY;
    public static float diffZ;
    public static GameProfile gameProfile;
    private static FloatBuffer modelviewF;
    private static FloatBuffer projectionF;
    private static IntBuffer viewport;
    private static FloatBuffer pos;
    public Thread serverThread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mod.EventHandler
    public void loadConfiguration(FMLPreInitializationEvent evt) {
        BCLog.initLog();
        BuildcraftRecipeRegistry.assemblyTable = AssemblyRecipeManager.INSTANCE;
        BuildcraftRecipeRegistry.integrationTable = IntegrationRecipeManager.INSTANCE;
        BuildcraftRecipeRegistry.refinery = RefineryRecipeManager.INSTANCE;
        BuildcraftRecipeRegistry.programmingTable = ProgrammingRecipeManager.INSTANCE;
        BuildcraftFuelRegistry.fuel = FuelManager.INSTANCE;
        BuildcraftFuelRegistry.coolant = CoolantManager.INSTANCE;
        BuilderAPI.schematicRegistry = SchematicRegistry.INSTANCE;
        mainConfiguration = new BuildCraftConfiguration(new File(evt.getModConfigurationDirectory(), "buildcraft/main.conf"));
        try {
            mainConfiguration.load();
            Property updateCheck = mainConfiguration.get("general", "update.check", true);
            updateCheck.comment = "set to true for version check on startup";
            if (updateCheck.getBoolean(true)) {
                Version.check();
            }
            Property hideRFNumbers = mainConfiguration.get("general", "hidePowerNumbers", false);
            hideRFNumbers.comment = "set to true to not display any RF or RF/t numbers.";
            hidePowerNumbers = hideRFNumbers.getBoolean(false);
            Property hideMBNumbers = mainConfiguration.get("general", "hideFluidNumbers", false);
            hideMBNumbers.comment = "set to true to not display any mB or mB/t numbers.";
            hideFluidNumbers = hideMBNumbers.getBoolean(false);
            Property lifespan = mainConfiguration.get("general", "itemLifespan", itemLifespan);
            lifespan.comment = "the lifespan in ticks of items dropped on the ground by pipes and machines, vanilla = 6000, default = 1200";
            if ((itemLifespan = lifespan.getInt(itemLifespan)) < 100) {
                itemLifespan = 100;
            }
            Property factor = mainConfiguration.get("general", "network.updateFactor", 10);
            factor.comment = "increasing this number will decrease network update frequency, useful for overloaded servers";
            updateFactor = factor.getInt(10);
            Property longFactor = mainConfiguration.get("general", "network.stateRefreshPeriod", 40);
            longFactor.comment = "delay between full client sync packets, increasing it saves bandwidth, decreasing makes for better client syncronization.";
            longUpdateFactor = longFactor.getInt(40);
            wrenchItem = new ItemWrench().setUnlocalizedName("wrenchItem");
            CoreProxy.proxy.registerItem(wrenchItem);
            mapLocationItem = new ItemMapLocation().setUnlocalizedName("mapLocation");
            CoreProxy.proxy.registerItem(mapLocationItem);
            listItem = (ItemList)new ItemList().setUnlocalizedName("list");
            CoreProxy.proxy.registerItem(listItem);
            Property modifyWorldProp = mainConfiguration.get("general", "modifyWorld", true);
            modifyWorldProp.comment = "set to false if BuildCraft should not generate custom blocks (e.g. oil)";
            modifyWorld = modifyWorldProp.getBoolean(true);
            if (modifyWorld) {
                BlockSpring.EnumSpring.WATER.canGen = mainConfiguration.get("worldgen", "waterSpring", true).getBoolean(true);
                springBlock = new BlockSpring().setBlockName("eternalSpring");
                CoreProxy.proxy.registerBlock(springBlock, ItemSpring.class);
            }
            Property consumeWater = mainConfiguration.get("general", "consumeWater", consumeWaterSources);
            consumeWaterSources = consumeWater.getBoolean(consumeWaterSources);
            consumeWater.comment = "set to true if the Pump should consume water";
            woodenGearItem = new ItemGear().setUnlocalizedName("woodenGearItem");
            CoreProxy.proxy.registerItem(woodenGearItem);
            OreDictionary.registerOre((String)"gearWood", (ItemStack)new ItemStack(woodenGearItem));
            stoneGearItem = new ItemGear().setUnlocalizedName("stoneGearItem");
            CoreProxy.proxy.registerItem(stoneGearItem);
            OreDictionary.registerOre((String)"gearStone", (ItemStack)new ItemStack(stoneGearItem));
            ironGearItem = new ItemGear().setUnlocalizedName("ironGearItem");
            CoreProxy.proxy.registerItem(ironGearItem);
            OreDictionary.registerOre((String)"gearIron", (ItemStack)new ItemStack(ironGearItem));
            goldGearItem = new ItemGear().setUnlocalizedName("goldGearItem");
            CoreProxy.proxy.registerItem(goldGearItem);
            OreDictionary.registerOre((String)"gearGold", (ItemStack)new ItemStack(goldGearItem));
            diamondGearItem = new ItemGear().setUnlocalizedName("diamondGearItem");
            CoreProxy.proxy.registerItem(diamondGearItem);
            OreDictionary.registerOre((String)"gearDiamond", (ItemStack)new ItemStack(diamondGearItem));
            MinecraftForge.EVENT_BUS.register((Object)this);
            MinecraftForge.EVENT_BUS.register((Object)new BlockHighlightHandler());
        }
        finally {
            if (mainConfiguration.hasChanged()) {
                mainConfiguration.save();
            }
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        BuildCraftAPI.proxy = CoreProxy.proxy;
        this.channels = NetworkRegistry.INSTANCE.newChannel("BC-CORE", new ChannelHandler[]{new BuildCraftChannelHandler(), new PacketHandler()});
        StatementManager.registerParameterClass("buildcraft:stackTrigger", StatementParameterItemStack.class);
        StatementManager.registerParameterClass("buildcraft:stackAction", StatementParameterItemStack.class);
        StatementManager.registerParameterClass(StatementParameterItemStack.class);
        StatementManager.registerParameterClass(StatementParameterDirection.class);
        StatementManager.registerParameterClass(StatementParameterRedstoneGateSideOnly.class);
        StatementManager.registerTriggerProvider(new DefaultTriggerProvider());
        StatementManager.registerActionProvider(new DefaultActionProvider());
        RobotManager.registerAIRobot(AIRobotMain.class, "aiRobotMain", "buildcraft.core.robots.AIRobotMain");
        RobotManager.registerAIRobot(BoardRobotBomber.class, "boardRobotBomber", "buildcraft.core.robots.boards.BoardRobotBomber");
        RobotManager.registerAIRobot(BoardRobotBuilder.class, "boardRobotBuilder", "buildcraft.core.robots.boards.BoardRobotBuilder");
        RobotManager.registerAIRobot(BoardRobotButcher.class, "boardRobotButcher", "buildcraft.core.robots.boards.BoardRobotButcher");
        RobotManager.registerAIRobot(BoardRobotCarrier.class, "boardRobotCarrier", "buildcraft.core.robots.boards.BoardRobotCarrier");
        RobotManager.registerAIRobot(BoardRobotCrafter.class, "boardRobotCrafter", "buildcraft.core.robots.boards.BoardRobotCrafter");
        RobotManager.registerAIRobot(BoardRobotDelivery.class, "boardRobotDelivery", "buildcraft.core.robots.boards.BoardRobotDelivery");
        RobotManager.registerAIRobot(BoardRobotFarmer.class, "boardRobotFarmer", "buildcraft.core.robots.boards.BoardRobotFarmer");
        RobotManager.registerAIRobot(BoardRobotFluidCarrier.class, "boardRobotFluidCarrier", "buildcraft.core.robots.boards.BoardRobotFluidCarrier");
        RobotManager.registerAIRobot(BoardRobotHarvester.class, "boardRobotHarvester", "buildcraft.core.robots.boards.BoardRobotHarvester");
        RobotManager.registerAIRobot(BoardRobotKnight.class, "boardRobotKnight", "buildcraft.core.robots.boards.BoardRobotKnight");
        RobotManager.registerAIRobot(BoardRobotLeaveCutter.class, "boardRobotLeaveCutter", "buildcraft.core.robots.boards.BoardRobotLeaveCutter");
        RobotManager.registerAIRobot(BoardRobotLumberjack.class, "boardRobotLumberjack", "buildcraft.core.robots.boards.BoardRobotLumberjack");
        RobotManager.registerAIRobot(BoardRobotMiner.class, "boardRobotMiner", "buildcraft.core.robots.boards.BoardRobotMiner");
        RobotManager.registerAIRobot(BoardRobotPicker.class, "boardRobotPicker", "buildcraft.core.robots.boards.BoardRobotPicker");
        RobotManager.registerAIRobot(BoardRobotPlanter.class, "boardRobotPlanter", "buildcraft.core.robots.boards.BoardRobotPlanter");
        RobotManager.registerAIRobot(BoardRobotPump.class, "boardRobotPump", "buildcraft.core.robots.boards.BoardRobotPump");
        RobotManager.registerAIRobot(BoardRobotShovelman.class, "boardRobotShovelman", "buildcraft.core.robots.boards.BoardRobotShovelman");
        RobotManager.registerAIRobot(BoardRobotStripes.class, "boardRobotStripes", "buildcraft.core.robots.boards.BoardRobotStripes");
        RobotManager.registerAIRobot(AIRobotAttack.class, "aiRobotAttack", "buildcraft.core.robots.AIRobotAttack");
        RobotManager.registerAIRobot(AIRobotBreak.class, "aiRobotBreak", "buildcraft.core.robots.AIRobotBreak");
        RobotManager.registerAIRobot(AIRobotCraftAssemblyTable.class, "aiRobotCraftAssemblyTable", "buildcraft.core.robots.AIRobotCraftAssemblyTable");
        RobotManager.registerAIRobot(AIRobotCraftFurnace.class, "aiRobotCraftFurnace", "buildcraft.core.robots.AIRobotCraftFurnace");
        RobotManager.registerAIRobot(AIRobotCraftWorkbench.class, "aiRobotCraftWorkbench", "buildcraft.core.robots.AIRobotCraftWorkbench");
        RobotManager.registerAIRobot(AIRobotDeliverRequested.class, "aiRobotDeliverRequested", "buildcraft.core.robots.AIRobotDeliverRequested");
        RobotManager.registerAIRobot(AIRobotDisposeItems.class, "aiRobotDisposeItems", "buildcraft.core.robots.AIRobotDisposeItems");
        RobotManager.registerAIRobot(AIRobotFetchAndEquipItemStack.class, "aiRobotFetchAndEquipItemStack", "buildcraft.core.robots.AIRobotFetchAndEquipItemStack");
        RobotManager.registerAIRobot(AIRobotFetchItem.class, "aiRobotFetchItem", "buildcraft.core.robots.AIRobotFetchItem");
        RobotManager.registerAIRobot(AIRobotGoAndLinkToDock.class, "aiRobotGoAndLinkToDock", "buildcraft.core.robots.AIRobotGoAndLinkToDock");
        RobotManager.registerAIRobot(AIRobotGoto.class, "aiRobotGoto", "buildcraft.core.robots.AIRobotGoto");
        RobotManager.registerAIRobot(AIRobotGotoBlock.class, "aiRobotGotoBlock", "buildcraft.core.robots.AIRobotGotoBlock");
        RobotManager.registerAIRobot(AIRobotGotoSleep.class, "aiRobotGotoSleep", "buildcraft.core.robots.AIRobotGotoSleep");
        RobotManager.registerAIRobot(AIRobotGotoStation.class, "aiRobotGotoStation", "buildcraft.core.robots.AIRobotGotoStation");
        RobotManager.registerAIRobot(AIRobotGotoStationAndLoad.class, "aiRobotGotoStationAndLoad", "buildcraft.core.robots.AIRobotGotoStationAndLoad");
        RobotManager.registerAIRobot(AIRobotGotoStationAndLoadFluids.class, "aiRobotGotoStationAndLoadFluids", "buildcraft.core.robots.AIRobotGotoStationAndLoadFluids");
        RobotManager.registerAIRobot(AIRobotGotoStationAndUnload.class, "aiRobotGotoStationAndUnload", "buildcraft.core.robots.AIRobotGotoStationAndUnload");
        RobotManager.registerAIRobot(AIRobotGotoStationToLoad.class, "aiRobotGotoStationToLoad", "buildcraft.core.robots.AIRobotGotoStationToLoad");
        RobotManager.registerAIRobot(AIRobotGotoStationToLoadFluids.class, "aiRobotGotoStationToLoadFluids", "buildcraft.core.robots.AIRobotGotoStationToLoadFluids");
        RobotManager.registerAIRobot(AIRobotGotoStationToUnload.class, "aiRobotGotoStationToUnload", "buildcraft.core.robots.AIRobotGotoStationToUnload");
        RobotManager.registerAIRobot(AIRobotGotoStationToUnloadFluids.class, "aiRobotGotoStationToUnloadFluids", "buildcraft.core.robots.AIRobotGotoStationToUnloadFluids");
        RobotManager.registerAIRobot(AIRobotLoad.class, "aiRobotLoad", "buildcraft.core.robots.AIRobotLoad");
        RobotManager.registerAIRobot(AIRobotLoadFluids.class, "aiRobotLoadFluids", "buildcraft.core.robots.AIRobotLoadFluids");
        RobotManager.registerAIRobot(AIRobotPumpBlock.class, "aiRobotPumpBlock", "buildcraft.core.robots.AIRobotPumpBlock");
        RobotManager.registerAIRobot(AIRobotRecharge.class, "aiRobotRecharge", "buildcraft.core.robots.AIRobotRecharge");
        RobotManager.registerAIRobot(AIRobotSearchAndGotoStation.class, "aiRobotSearchAndGotoStation", "buildcraft.core.robots.AIRobotSearchAndGotoStation");
        RobotManager.registerAIRobot(AIRobotSearchBlock.class, "aiRobotSearchBlock", "buildcraft.core.robots.AIRobotSearchBlock");
        RobotManager.registerAIRobot(AIRobotSearchEntity.class, "aiRobotSearchEntity", "buildcraft.core.robots.AIRobotSearchEntity");
        RobotManager.registerAIRobot(AIRobotSearchRandomBlock.class, "aiRobotSearchRandomBlock", "buildcraft.core.robots.AIRobotSearchRandomBlock");
        RobotManager.registerAIRobot(AIRobotSearchRandomGroundBlock.class, "aiRobotSearchRandomGroundBlock", "buildcraft.core.robots.AIRobotSearchRandomGroundBlock");
        RobotManager.registerAIRobot(AIRobotSearchStackRequest.class, "aiRobotSearchStackRequest", "buildcraft.core.robots.AIRobotSearchStackRequest");
        RobotManager.registerAIRobot(AIRobotSearchStation.class, "aiRobotSearchStation", "buildcraft.core.robots.AIRobotSearchStation");
        RobotManager.registerAIRobot(AIRobotSleep.class, "aiRobotSleep", "buildcraft.core.robots.AIRobotSleep");
        RobotManager.registerAIRobot(AIRobotStraightMoveTo.class, "aiRobotStraightMoveTo", "buildcraft.core.robots.AIRobotStraightMoveTo");
        RobotManager.registerAIRobot(AIRobotUnload.class, "aiRobotUnload", "buildcraft.core.robots.AIRobotUnload");
        RobotManager.registerAIRobot(AIRobotUnloadFluids.class, "aiRobotUnloadFluids", "buildcraft.core.robots.AIRobotUnloadFluids");
        RobotManager.registerAIRobot(AIRobotUseToolOnBlock.class, "aiRobotUseToolOnBlock", "buildcraft.core.robots.AIRobotUseToolOnBlock");
        RobotManager.registerResourceId(ResourceIdAssemblyTable.class, "resourceIdAssemblyTable", "buildcraft.core.robots.ResourceIdAssemblyTable");
        RobotManager.registerResourceId(ResourceIdBlock.class, "resourceIdBlock", "buildcraft.core.robots.ResourceIdBlock");
        RobotManager.registerResourceId(ResourceIdRequest.class, "resourceIdRequest", "buildcraft.core.robots.ResourceIdRequest");
        if (modifyWorld) {
            MinecraftForge.EVENT_BUS.register((Object)new SpringPopulate());
        }
        for (String l : mainConfiguration.get("general", "recipesBlacklist", new String[0]).getStringList()) {
            recipesBlacklist.add(JavaTools.stripSurroundingQuotes(l.trim()));
        }
        if (mainConfiguration.hasChanged()) {
            mainConfiguration.save();
        }
        if (loadDefaultRecipes) {
            this.loadRecipes();
        }
        EntityRegistry.registerModEntity(EntityRobot.class, (String)"bcRobot", (int)10, (Object)instance, (int)50, (int)1, (boolean)true);
        EntityList.stringToClassMapping.remove("BuildCraft|Core.bcLaser");
        EntityList.stringToClassMapping.remove("BuildCraft|Core.bcEnergyLaser");
        FMLCommonHandler.instance().bus().register((Object)new CraftingHandler());
        CoreProxy.proxy.initializeRendering();
        CoreProxy.proxy.initializeEntityRendering();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        BCLog.logger.info("BuildCraft's fake player: UUID = " + gameProfile.getId().toString() + ", name = '" + gameProfile.getName() + "'!");
        for (Object o : Block.blockRegistry) {
            Block block = (Block)o;
            if (!(block instanceof BlockFluidBase) && !(block instanceof BlockLiquid) && !(block instanceof IPlantable)) continue;
            BuildCraftAPI.softBlocks.add(block);
        }
        BuildCraftAPI.softBlocks.add(Blocks.snow);
        BuildCraftAPI.softBlocks.add(Blocks.vine);
        BuildCraftAPI.softBlocks.add((Block)Blocks.fire);
        BuildCraftAPI.softBlocks.add(Blocks.air);
        FMLCommonHandler.instance().bus().register((Object)new TickHandlerCore());
        BuildCraftAPI.isSoftProperty = new WorldPropertyIsSoft();
        BuildCraftAPI.isWoodProperty = new WorldPropertyIsWood();
        BuildCraftAPI.isLeavesProperty = new WorldPropertyIsLeaf();
        BuildCraftAPI.isOreProperty = new IWorldProperty[4];
        for (int i = 0; i < BuildCraftAPI.isOreProperty.length; ++i) {
            BuildCraftAPI.isOreProperty[i] = new WorldPropertyIsOre(i);
        }
        BuildCraftAPI.isHarvestableProperty = new WorldPropertyIsHarvestable();
        BuildCraftAPI.isFarmlandProperty = new WorldPropertyIsFarmland();
        BuildCraftAPI.isShoveled = new WorldPropertyIsShoveled();
        BuildCraftAPI.isDirtProperty = new WorldPropertyIsDirt();
        BuildCraftAPI.isFluidSource = new WorldPropertyIsFluidSource();
        ColorUtils.initialize();
        actionControl = new IActionExternal[IControllable.Mode.values().length];
        for (IControllable.Mode mode : IControllable.Mode.values()) {
            if (mode == IControllable.Mode.Unknown || mode == IControllable.Mode.Mode) continue;
            BuildCraftCore.actionControl[mode.ordinal()] = new ActionMachineControl(mode);
        }
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        this.serverThread = Thread.currentThread();
        event.registerServerCommand((ICommand)new CommandBuildCraft());
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void textureHook(TextureStitchEvent.Pre event) {
        if (event.map.getTextureType() == 1) {
            iconProvider = new CoreIconProvider();
            iconProvider.registerIcons((IIconRegister)event.map);
            EnumColor.registerIcons((IIconRegister)event.map);
        } else if (event.map.getTextureType() == 0) {
            redLaserTexture = event.map.registerIcon("buildcraft:blockRedLaser");
            blueLaserTexture = event.map.registerIcon("buildcraft:blockBlueLaser");
            stripesLaserTexture = event.map.registerIcon("buildcraft:blockStripesLaser");
            transparentTexture = event.map.registerIcon("buildcraft:blockTransparentLaser");
        }
    }

    public void loadRecipes() {
        CoreProxy.proxy.addCraftingRecipe(new ItemStack(wrenchItem), "I I", " G ", " I ", Character.valueOf('I'), "ingotIron", Character.valueOf('G'), "gearStone");
        CoreProxy.proxy.addCraftingRecipe(new ItemStack(woodenGearItem), " S ", "S S", " S ", Character.valueOf('S'), "stickWood");
        CoreProxy.proxy.addCraftingRecipe(new ItemStack(stoneGearItem), " I ", "IGI", " I ", Character.valueOf('I'), "cobblestone", Character.valueOf('G'), "gearWood");
        CoreProxy.proxy.addCraftingRecipe(new ItemStack(ironGearItem), " I ", "IGI", " I ", Character.valueOf('I'), "ingotIron", Character.valueOf('G'), "gearStone");
        CoreProxy.proxy.addCraftingRecipe(new ItemStack(goldGearItem), " I ", "IGI", " I ", Character.valueOf('I'), "ingotGold", Character.valueOf('G'), "gearIron");
        CoreProxy.proxy.addCraftingRecipe(new ItemStack(diamondGearItem), " I ", "IGI", " I ", Character.valueOf('I'), "gemDiamond", Character.valueOf('G'), "gearGold");
        CoreProxy.proxy.addCraftingRecipe(new ItemStack(mapLocationItem), "ppp", "pYp", "ppp", Character.valueOf('p'), Items.paper, Character.valueOf('Y'), "dyeYellow");
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Item)listItem), "ppp", "pYp", "ppp", Character.valueOf('p'), Items.paper, Character.valueOf('Y'), "dyeGreen");
    }

    @Mod.EventHandler
    public void processIMCRequests(FMLInterModComms.IMCEvent event) {
        InterModComms.processIMC(event);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void renderLast(RenderWorldLastEvent evt) {
    }

    @SubscribeEvent
    public void cleanRegistries(WorldEvent.Unload unload) {
        BuildCraftAPI.isSoftProperty.clear();
        BuildCraftAPI.isWoodProperty.clear();
        BuildCraftAPI.isLeavesProperty.clear();
        for (int i = 0; i < BuildCraftAPI.isOreProperty.length; ++i) {
            BuildCraftAPI.isOreProperty[i].clear();
        }
        BuildCraftAPI.isHarvestableProperty.clear();
        BuildCraftAPI.isFarmlandProperty.clear();
        BuildCraftAPI.isShoveled.clear();
        BuildCraftAPI.isDirtProperty.clear();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        woodenGearAchievement = new Achievement("achievement.woodenGear", "woodenGearAchievement", 0, 0, woodenGearItem, null).registerStat();
        stoneGearAchievement = new Achievement("achievement.stoneGear", "stoneGearAchievement", 2, 0, stoneGearItem, woodenGearAchievement).registerStat();
        ironGearAchievement = new Achievement("achievement.ironGear", "ironGearAchievement", 4, 0, ironGearItem, stoneGearAchievement).registerStat();
        goldGearAchievement = new Achievement("achievement.goldGear", "goldGearAchievement", 6, 0, goldGearItem, ironGearAchievement).registerStat();
        diamondGearAchievement = new Achievement("achievement.diamondGear", "diamondGearAchievement", 8, 0, diamondGearItem, goldGearAchievement).registerStat();
        wrenchAchievement = new Achievement("achievement.wrench", "wrenchAchievement", 3, 2, wrenchItem, stoneGearAchievement).registerStat();
        engineAchievement1 = new Achievement("achievement.redstoneEngine", "engineAchievement1", 1, -2, new ItemStack((Block)BuildCraftEnergy.engineBlock, 1, 0), woodenGearAchievement).registerStat();
        engineAchievement2 = new Achievement("achievement.stirlingEngine", "engineAchievement2", 3, -2, new ItemStack((Block)BuildCraftEnergy.engineBlock, 1, 1), engineAchievement1).registerStat();
        engineAchievement3 = new Achievement("achievement.combustionEngine", "engineAchievement3", 5, -2, new ItemStack((Block)BuildCraftEnergy.engineBlock, 1, 2), engineAchievement2).registerStat();
        aLotOfCraftingAchievement = new Achievement("achievement.aLotOfCrafting", "aLotOfCraftingAchievement", 1, 2, (Block)BuildCraftFactory.autoWorkbenchBlock, woodenGearAchievement).registerStat();
        straightDownAchievement = new Achievement("achievement.straightDown", "straightDownAchievement", 5, 2, (Block)BuildCraftFactory.miningWellBlock, ironGearAchievement).registerStat();
        chunkDestroyerAchievement = new Achievement("achievement.chunkDestroyer", "chunkDestroyerAchievement", 9, 2, (Block)BuildCraftFactory.quarryBlock, diamondGearAchievement).registerStat();
        fasterFillingAchievement = new Achievement("achievement.fasterFilling", "fasterFillingAchievement", 7, 2, (Block)BuildCraftBuilders.fillerBlock, goldGearAchievement).registerStat();
        timeForSomeLogicAchievement = new Achievement("achievement.timeForSomeLogic", "timeForSomeLogicAchievement", 9, -2, (Block)BuildCraftSilicon.assemblyTableBlock, diamondGearAchievement).registerStat();
        refineAndRedefineAchievement = new Achievement("achievement.refineAndRedefine", "refineAndRedefineAchievement", 10, 0, (Block)BuildCraftFactory.refineryBlock, diamondGearAchievement).registerStat();
        tinglyLaserAchievement = new Achievement("achievement.tinglyLaser", "tinglyLaserAchievement", 11, -2, (Block)BuildCraftSilicon.laserBlock, timeForSomeLogicAchievement).registerStat();
        architectAchievement = new Achievement("achievement.architect", "architectAchievement", 11, 2, (Block)BuildCraftBuilders.architectBlock, chunkDestroyerAchievement).registerStat();
        builderAchievement = new Achievement("achievement.builder", "builderAchievement", 13, 2, (Block)BuildCraftBuilders.builderBlock, architectAchievement).registerStat();
        blueprintAchievement = new Achievement("achievement.blueprint", "blueprintAchievement", 11, 4, (Item)BuildCraftBuilders.blueprintItem, architectAchievement).registerStat();
        templateAchievement = new Achievement("achievement.template", "templateAchievement", 13, 4, (Item)BuildCraftBuilders.templateItem, blueprintAchievement).registerStat();
        libraryAchievement = new Achievement("achievement.blueprintLibrary", "blueprintLibraryAchievement", 15, 2, (Block)BuildCraftBuilders.libraryBlock, builderAchievement).registerStat();
        BuildcraftAchievements = new AchievementPage("Buildcraft", new Achievement[]{woodenGearAchievement, stoneGearAchievement, ironGearAchievement, goldGearAchievement, diamondGearAchievement, wrenchAchievement, engineAchievement1, engineAchievement2, engineAchievement3, aLotOfCraftingAchievement, straightDownAchievement, chunkDestroyerAchievement, fasterFillingAchievement, timeForSomeLogicAchievement, refineAndRedefineAchievement, tinglyLaserAchievement, architectAchievement, builderAchievement, blueprintAchievement, templateAchievement, libraryAchievement});
        AchievementPage.registerAchievementPage((AchievementPage)BuildcraftAchievements);
    }

    static {
        render = RenderMode.Full;
        debugWorldgen = false;
        modifyWorld = false;
        colorBlindMode = false;
        hidePowerNumbers = false;
        hideFluidNumbers = false;
        itemLifespan = 1200;
        updateFactor = 10;
        longUpdateFactor = 40L;
        triggerMachineActive = new TriggerMachine(true);
        triggerMachineInactive = new TriggerMachine(false);
        triggerEnergyHigh = new TriggerEnergy(true);
        triggerEnergyLow = new TriggerEnergy(false);
        triggerEmptyInventory = new TriggerInventory(TriggerInventory.State.Empty);
        triggerContainsInventory = new TriggerInventory(TriggerInventory.State.Contains);
        triggerSpaceInventory = new TriggerInventory(TriggerInventory.State.Space);
        triggerFullInventory = new TriggerInventory(TriggerInventory.State.Full);
        triggerEmptyFluid = new TriggerFluidContainer(TriggerFluidContainer.State.Empty);
        triggerContainsFluid = new TriggerFluidContainer(TriggerFluidContainer.State.Contains);
        triggerSpaceFluid = new TriggerFluidContainer(TriggerFluidContainer.State.Space);
        triggerFullFluid = new TriggerFluidContainer(TriggerFluidContainer.State.Full);
        triggerRedstoneActive = new TriggerRedstoneInput(true);
        triggerRedstoneInactive = new TriggerRedstoneInput(false);
        triggerInventoryBelow25 = new TriggerInventoryLevel(TriggerInventoryLevel.TriggerType.BELOW25);
        triggerInventoryBelow50 = new TriggerInventoryLevel(TriggerInventoryLevel.TriggerType.BELOW50);
        triggerInventoryBelow75 = new TriggerInventoryLevel(TriggerInventoryLevel.TriggerType.BELOW75);
        triggerFluidContainerBelow25 = new TriggerFluidContainerLevel(TriggerFluidContainerLevel.TriggerType.BELOW25);
        triggerFluidContainerBelow50 = new TriggerFluidContainerLevel(TriggerFluidContainerLevel.TriggerType.BELOW50);
        triggerFluidContainerBelow75 = new TriggerFluidContainerLevel(TriggerFluidContainerLevel.TriggerType.BELOW75);
        actionRedstone = new ActionRedstoneOutput();
        loadDefaultRecipes = true;
        consumeWaterSources = false;
        recipesBlacklist = new HashSet();
        gameProfile = new GameProfile(UUID.nameUUIDFromBytes("buildcraft.core".getBytes()), "[BuildCraft]");
        pos = ByteBuffer.allocateDirect(12).asFloatBuffer();
    }

    public static enum RenderMode {
        Full,
        NoDynamic;

    }
}

