/*
 * Decompiled with CFR 0.152.
 */
package buildcraft;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftMod;
import buildcraft.api.blueprints.BuilderAPI;
import buildcraft.api.boards.RedstoneBoardRegistry;
import buildcraft.api.recipes.BuildcraftRecipeRegistry;
import buildcraft.api.statements.IActionInternal;
import buildcraft.api.statements.ITriggerInternal;
import buildcraft.api.statements.StatementManager;
import buildcraft.builders.schematics.SchematicRotateMeta;
import buildcraft.commander.BlockRequester;
import buildcraft.commander.BlockZonePlan;
import buildcraft.commander.TileRequester;
import buildcraft.commander.TileZonePlan;
import buildcraft.compat.CompatHooks;
import buildcraft.core.InterModComms;
import buildcraft.core.ItemBuildCraft;
import buildcraft.core.network.BuildCraftChannelHandler;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.robots.ItemRobot;
import buildcraft.robots.RobotIntegrationRecipe;
import buildcraft.robots.boards.BoardRobotBomberNBT;
import buildcraft.robots.boards.BoardRobotBuilderNBT;
import buildcraft.robots.boards.BoardRobotButcherNBT;
import buildcraft.robots.boards.BoardRobotCarrierNBT;
import buildcraft.robots.boards.BoardRobotCrafterNBT;
import buildcraft.robots.boards.BoardRobotDeliveryNBT;
import buildcraft.robots.boards.BoardRobotFarmerNBT;
import buildcraft.robots.boards.BoardRobotFluidCarrierNBT;
import buildcraft.robots.boards.BoardRobotHarvesterNBT;
import buildcraft.robots.boards.BoardRobotKnightNBT;
import buildcraft.robots.boards.BoardRobotLeaveCutterNBT;
import buildcraft.robots.boards.BoardRobotLumberjackNBT;
import buildcraft.robots.boards.BoardRobotMinerNBT;
import buildcraft.robots.boards.BoardRobotPickerNBT;
import buildcraft.robots.boards.BoardRobotPlanterNBT;
import buildcraft.robots.boards.BoardRobotPumpNBT;
import buildcraft.robots.boards.BoardRobotShovelmanNBT;
import buildcraft.robots.boards.BoardRobotStripesNBT;
import buildcraft.robots.statements.ActionRobotFilter;
import buildcraft.robots.statements.ActionRobotFilterTool;
import buildcraft.robots.statements.ActionRobotGotoStation;
import buildcraft.robots.statements.ActionRobotWakeUp;
import buildcraft.robots.statements.ActionRobotWorkInArea;
import buildcraft.robots.statements.ActionStationAcceptFluids;
import buildcraft.robots.statements.ActionStationAcceptItemsInv;
import buildcraft.robots.statements.ActionStationAcceptItemsPipe;
import buildcraft.robots.statements.ActionStationAllowCraft;
import buildcraft.robots.statements.ActionStationForbidRobot;
import buildcraft.robots.statements.ActionStationProvideFluids;
import buildcraft.robots.statements.ActionStationProvideItems;
import buildcraft.robots.statements.ActionStationRequestItems;
import buildcraft.robots.statements.ActionStationRequestItemsMachine;
import buildcraft.robots.statements.RobotsActionProvider;
import buildcraft.robots.statements.RobotsTriggerProvider;
import buildcraft.robots.statements.TriggerRobotSleep;
import buildcraft.silicon.BlockLaser;
import buildcraft.silicon.BlockLaserTable;
import buildcraft.silicon.GuiHandler;
import buildcraft.silicon.ItemLaserTable;
import buildcraft.silicon.ItemRedstoneBoard;
import buildcraft.silicon.ItemRedstoneChipset;
import buildcraft.silicon.SiliconProxy;
import buildcraft.silicon.TileAdvancedCraftingTable;
import buildcraft.silicon.TileAssemblyTable;
import buildcraft.silicon.TileChargingTable;
import buildcraft.silicon.TileIntegrationTable;
import buildcraft.silicon.TileLaser;
import buildcraft.silicon.TileProgrammingTable;
import buildcraft.silicon.boards.BoardProgrammingRecipe;
import buildcraft.silicon.boards.ImplRedstoneBoardRegistry;
import buildcraft.silicon.network.PacketHandlerSilicon;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import io.netty.channel.ChannelHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

@Mod(name="BuildCraft Silicon", version="6.4.10", useMetadata=false, modid="BuildCraft|Silicon", dependencies="required-after:BuildCraft|Transport@6.4.10")
public class BuildCraftSilicon
extends BuildCraftMod {
    @Mod.Instance(value="BuildCraft|Silicon")
    public static BuildCraftSilicon instance;
    public static ItemRedstoneChipset redstoneChipset;
    public static ItemRedstoneBoard redstoneBoard;
    public static BlockLaser laserBlock;
    public static BlockLaserTable assemblyTableBlock;
    public static BlockZonePlan zonePlanBlock;
    public static BlockRequester requesterBlock;
    public static Item redstoneCrystal;
    public static Item robotItem;
    public static ITriggerInternal triggerRobotSleep;
    public static IActionInternal actionRobotGotoStation;
    public static IActionInternal actionRobotWakeUp;
    public static IActionInternal actionRobotWorkInArea;
    public static IActionInternal actionRobotFilter;
    public static IActionInternal actionRobotFilterTool;
    public static IActionInternal actionRobotAllowCraft;
    public static IActionInternal actionStationRequestItems;
    public static IActionInternal actionStationAcceptItems;
    public static IActionInternal actionStationProvideItems;
    public static IActionInternal actionStationAcceptFluids;
    public static IActionInternal actionStationProvideFluids;
    public static IActionInternal actionStationForbidRobot;
    public static IActionInternal actionStationDropInPipe;
    public static IActionInternal actionStationMachineRequestItems;
    public static float chipsetCostMultiplier;
    public static List<String> blacklistedRobots;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        chipsetCostMultiplier = BuildCraftCore.mainConfiguration.getFloat("chipset.costMultiplier", "general", 1.0f, 0.001f, 1000.0f, "The multiplier for chipset recipe cost.");
        blacklistedRobots = new ArrayList<String>();
        blacklistedRobots.addAll(Arrays.asList(BuildCraftCore.mainConfiguration.get("general", "boards.blacklist", new String[0]).getStringList()));
        BuildCraftCore.mainConfiguration.save();
        laserBlock = (BlockLaser)CompatHooks.INSTANCE.getBlock(BlockLaser.class);
        laserBlock.setBlockName("laserBlock");
        CoreProxy.proxy.registerBlock((Block)laserBlock);
        assemblyTableBlock = (BlockLaserTable)CompatHooks.INSTANCE.getBlock(BlockLaserTable.class);
        assemblyTableBlock.setBlockName("laserTableBlock");
        CoreProxy.proxy.registerBlock((Block)assemblyTableBlock, ItemLaserTable.class);
        zonePlanBlock = (BlockZonePlan)CompatHooks.INSTANCE.getBlock(BlockZonePlan.class);
        zonePlanBlock.setBlockName("zonePlan");
        CoreProxy.proxy.registerBlock((Block)zonePlanBlock);
        requesterBlock = (BlockRequester)CompatHooks.INSTANCE.getBlock(BlockRequester.class);
        requesterBlock.setBlockName("requester");
        CoreProxy.proxy.registerBlock((Block)requesterBlock);
        redstoneChipset = new ItemRedstoneChipset();
        redstoneChipset.setUnlocalizedName("redstoneChipset");
        CoreProxy.proxy.registerItem(redstoneChipset);
        redstoneChipset.registerItemStacks();
        redstoneBoard = new ItemRedstoneBoard();
        redstoneBoard.setUnlocalizedName("redstone_board");
        CoreProxy.proxy.registerItem(redstoneBoard);
        redstoneCrystal = new ItemBuildCraft().setUnlocalizedName("redstoneCrystal");
        CoreProxy.proxy.registerItem(redstoneCrystal);
        OreDictionary.registerOre((String)"redstoneCrystal", (ItemStack)new ItemStack(redstoneCrystal));
        robotItem = new ItemRobot().setUnlocalizedName("robot");
        CoreProxy.proxy.registerItem(robotItem);
        RedstoneBoardRegistry.instance = new ImplRedstoneBoardRegistry();
        RedstoneBoardRegistry.instance.registerBoardClass(BoardRobotPickerNBT.instance, 20.0f);
        RedstoneBoardRegistry.instance.registerBoardClass(BoardRobotCarrierNBT.instance, 10.0f);
        RedstoneBoardRegistry.instance.registerBoardClass(BoardRobotLumberjackNBT.instance, 10.0f);
        RedstoneBoardRegistry.instance.registerBoardClass(BoardRobotHarvesterNBT.instance, 10.0f);
        RedstoneBoardRegistry.instance.registerBoardClass(BoardRobotMinerNBT.instance, 10.0f);
        RedstoneBoardRegistry.instance.registerBoardClass(BoardRobotFluidCarrierNBT.instance, 5.0f);
        RedstoneBoardRegistry.instance.registerBoardClass(BoardRobotPlanterNBT.instance, 5.0f);
        RedstoneBoardRegistry.instance.registerBoardClass(BoardRobotFarmerNBT.instance, 5.0f);
        RedstoneBoardRegistry.instance.registerBoardClass(BoardRobotLeaveCutterNBT.instance, 5.0f);
        RedstoneBoardRegistry.instance.registerBoardClass(BoardRobotButcherNBT.instance, 5.0f);
        RedstoneBoardRegistry.instance.registerBoardClass(BoardRobotShovelmanNBT.instance, 5.0f);
        RedstoneBoardRegistry.instance.registerBoardClass(BoardRobotCrafterNBT.instance, 5.0f);
        RedstoneBoardRegistry.instance.registerBoardClass(BoardRobotDeliveryNBT.instance, 5.0f);
        RedstoneBoardRegistry.instance.registerBoardClass(BoardRobotPumpNBT.instance, 5.0f);
        RedstoneBoardRegistry.instance.registerBoardClass(BoardRobotKnightNBT.instance, 1.0f);
        RedstoneBoardRegistry.instance.registerBoardClass(BoardRobotBomberNBT.instance, 1.0f);
        RedstoneBoardRegistry.instance.registerBoardClass(BoardRobotBuilderNBT.instance, 0.5f);
        RedstoneBoardRegistry.instance.registerBoardClass(BoardRobotStripesNBT.instance, 0.5f);
        StatementManager.registerActionProvider(new RobotsActionProvider());
        StatementManager.registerTriggerProvider(new RobotsTriggerProvider());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        this.channels = NetworkRegistry.INSTANCE.newChannel("BC-SILICON", new ChannelHandler[]{new BuildCraftChannelHandler(), new PacketHandlerSilicon()});
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        CoreProxy.proxy.registerTileEntity(TileLaser.class, "net.minecraft.src.buildcraft.factory.TileLaser");
        CoreProxy.proxy.registerTileEntity(TileAssemblyTable.class, "net.minecraft.src.buildcraft.factory.TileAssemblyTable");
        CoreProxy.proxy.registerTileEntity(TileAdvancedCraftingTable.class, "net.minecraft.src.buildcraft.factory.TileAssemblyAdvancedWorkbench");
        CoreProxy.proxy.registerTileEntity(TileIntegrationTable.class, "net.minecraft.src.buildcraft.factory.TileIntegrationTable");
        CoreProxy.proxy.registerTileEntity(TileChargingTable.class, "net.minecraft.src.buildcraft.factory.TileChargingTable");
        CoreProxy.proxy.registerTileEntity(TileProgrammingTable.class, "net.minecraft.src.buildcraft.factory.TileProgrammingTable");
        CoreProxy.proxy.registerTileEntity(TileZonePlan.class, "net.minecraft.src.buildcraft.commander.TileZonePlan");
        CoreProxy.proxy.registerTileEntity(TileRequester.class, "net.minecraft.src.buildcraft.commander.TileRequester");
        BuilderAPI.schematicRegistry.registerSchematicBlock((Block)laserBlock, SchematicRotateMeta.class, new int[]{2, 5, 3, 4}, true);
        if (BuildCraftCore.loadDefaultRecipes) {
            BuildCraftSilicon.loadRecipes();
        }
        SiliconProxy.proxy.registerRenderers();
    }

    public static void loadRecipes() {
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)laserBlock), "ORR", "DDR", "ORR", Character.valueOf('O'), Blocks.obsidian, Character.valueOf('R'), "dustRedstone", Character.valueOf('D'), "gemDiamond");
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)assemblyTableBlock, 1, 0), "ORO", "ODO", "OGO", Character.valueOf('O'), Blocks.obsidian, Character.valueOf('R'), "dustRedstone", Character.valueOf('D'), "gemDiamond", Character.valueOf('G'), "gearDiamond");
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)assemblyTableBlock, 1, 1), "OWO", "OCO", "ORO", Character.valueOf('O'), Blocks.obsidian, Character.valueOf('W'), Blocks.crafting_table, Character.valueOf('C'), Blocks.chest, Character.valueOf('R'), new ItemStack((Item)redstoneChipset, 1, 0));
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)assemblyTableBlock, 1, 2), "ORO", "OCO", "OGO", Character.valueOf('O'), Blocks.obsidian, Character.valueOf('R'), "dustRedstone", Character.valueOf('C'), new ItemStack((Item)redstoneChipset, 1, 0), Character.valueOf('G'), "gearDiamond");
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)assemblyTableBlock, 1, 3), "ORO", "OCO", "OGO", Character.valueOf('O'), Blocks.obsidian, Character.valueOf('R'), "dustRedstone", Character.valueOf('C'), new ItemStack((Item)redstoneChipset, 1, 0), Character.valueOf('G'), "gearGold");
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)assemblyTableBlock, 1, 4), "ORO", "OCO", "OGO", Character.valueOf('O'), Blocks.obsidian, Character.valueOf('R'), "dustRedstone", Character.valueOf('C'), Items.emerald, Character.valueOf('G'), "gearDiamond");
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)zonePlanBlock, 1, 0), "IRI", "GMG", "IDI", Character.valueOf('M'), Items.map, Character.valueOf('R'), "dustRedstone", Character.valueOf('G'), "gearGold", Character.valueOf('D'), "gearDiamond", Character.valueOf('I'), "ingotIron");
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)requesterBlock, 1, 0), "IPI", "GCG", "IRI", Character.valueOf('C'), Blocks.chest, Character.valueOf('R'), "dustRedstone", Character.valueOf('P'), Blocks.piston, Character.valueOf('G'), "gearIron", Character.valueOf('I'), "ingotIron");
        BuildcraftRecipeRegistry.assemblyTable.addRecipe("buildcraft:redstoneChipset", Math.round(100000.0f * chipsetCostMultiplier), ItemRedstoneChipset.Chipset.RED.getStack(), "dustRedstone");
        BuildcraftRecipeRegistry.assemblyTable.addRecipe("buildcraft:ironChipset", Math.round(200000.0f * chipsetCostMultiplier), ItemRedstoneChipset.Chipset.IRON.getStack(), "dustRedstone", "ingotIron");
        BuildcraftRecipeRegistry.assemblyTable.addRecipe("buildcraft:goldChipset", Math.round(400000.0f * chipsetCostMultiplier), ItemRedstoneChipset.Chipset.GOLD.getStack(), "dustRedstone", "ingotGold");
        BuildcraftRecipeRegistry.assemblyTable.addRecipe("buildcraft:diamondChipset", Math.round(800000.0f * chipsetCostMultiplier), ItemRedstoneChipset.Chipset.DIAMOND.getStack(), "dustRedstone", "gemDiamond");
        BuildcraftRecipeRegistry.assemblyTable.addRecipe("buildcraft:emeraldChipset", Math.round(1200000.0f * chipsetCostMultiplier), ItemRedstoneChipset.Chipset.EMERALD.getStack(), "dustRedstone", "gemEmerald");
        BuildcraftRecipeRegistry.assemblyTable.addRecipe("buildcraft:pulsatingChipset", Math.round(400000.0f * chipsetCostMultiplier), ItemRedstoneChipset.Chipset.PULSATING.getStack(2), "dustRedstone", Items.ender_pearl);
        BuildcraftRecipeRegistry.assemblyTable.addRecipe("buildcraft:quartzChipset", Math.round(600000.0f * chipsetCostMultiplier), ItemRedstoneChipset.Chipset.QUARTZ.getStack(), "dustRedstone", "gemQuartz");
        BuildcraftRecipeRegistry.assemblyTable.addRecipe("buildcraft:compChipset", Math.round(600000.0f * chipsetCostMultiplier), ItemRedstoneChipset.Chipset.COMP.getStack(), "dustRedstone", Items.comparator);
        BuildcraftRecipeRegistry.assemblyTable.addRecipe("buildcraft:redstoneCrystal", 10000000, new ItemStack(redstoneCrystal), new ItemStack(Blocks.redstone_block));
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Item)redstoneBoard), "PPP", "PRP", "PPP", Character.valueOf('R'), "dustRedstone", Character.valueOf('P'), Items.paper);
        CoreProxy.proxy.addCraftingRecipe(new ItemStack(robotItem), "PPP", "PRP", "C C", Character.valueOf('P'), "ingotIron", Character.valueOf('R'), redstoneCrystal, Character.valueOf('C'), ItemRedstoneChipset.Chipset.DIAMOND.getStack());
        BuildcraftRecipeRegistry.programmingTable.addRecipe(new BoardProgrammingRecipe());
        BuildcraftRecipeRegistry.integrationTable.addRecipe(new RobotIntegrationRecipe("buildcraft:robotIntegration"));
    }

    @Mod.EventHandler
    public void processRequests(FMLInterModComms.IMCEvent event) {
        InterModComms.processIMC(event);
    }

    @Mod.EventHandler
    public void whiteListAppliedEnergetics(FMLInitializationEvent event) {
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileLaser.class.getCanonicalName());
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileAssemblyTable.class.getCanonicalName());
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileAdvancedCraftingTable.class.getCanonicalName());
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileIntegrationTable.class.getCanonicalName());
    }

    @Mod.EventHandler
    public void remap(FMLMissingMappingsEvent event) {
        for (FMLMissingMappingsEvent.MissingMapping mapping : event.get()) {
            if (!mapping.name.equals("BuildCraft|Silicon:null")) continue;
            if (mapping.type == GameRegistry.Type.ITEM) {
                mapping.remap(Item.getItemFromBlock((Block)assemblyTableBlock));
                continue;
            }
            mapping.remap((Block)assemblyTableBlock);
        }
    }

    static {
        triggerRobotSleep = new TriggerRobotSleep();
        actionRobotGotoStation = new ActionRobotGotoStation();
        actionRobotWakeUp = new ActionRobotWakeUp();
        actionRobotWorkInArea = new ActionRobotWorkInArea();
        actionRobotFilter = new ActionRobotFilter();
        actionRobotFilterTool = new ActionRobotFilterTool();
        actionRobotAllowCraft = new ActionStationAllowCraft();
        actionStationRequestItems = new ActionStationRequestItems();
        actionStationAcceptItems = new ActionStationAcceptItemsInv();
        actionStationProvideItems = new ActionStationProvideItems();
        actionStationAcceptFluids = new ActionStationAcceptFluids();
        actionStationProvideFluids = new ActionStationProvideFluids();
        actionStationForbidRobot = new ActionStationForbidRobot();
        actionStationDropInPipe = new ActionStationAcceptItemsPipe();
        actionStationMachineRequestItems = new ActionStationRequestItemsMachine();
        chipsetCostMultiplier = 1.0f;
    }
}

