/*
 * Decompiled with CFR 0.152.
 */
package buildcraft;

import buildcraft.BuildCraftBuilders;
import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftFactory;
import buildcraft.BuildCraftMod;
import buildcraft.api.blueprints.BuilderAPI;
import buildcraft.api.core.EnumColor;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.core.JavaTools;
import buildcraft.api.gates.GateExpansions;
import buildcraft.api.recipes.BuildcraftRecipeRegistry;
import buildcraft.api.statements.IActionInternal;
import buildcraft.api.statements.ITriggerInternal;
import buildcraft.api.statements.StatementManager;
import buildcraft.api.transport.PipeManager;
import buildcraft.api.transport.PipeWire;
import buildcraft.compat.CompatHooks;
import buildcraft.core.CreativeTabBuildCraft;
import buildcraft.core.DefaultProps;
import buildcraft.core.InterModComms;
import buildcraft.core.ItemBuildCraft;
import buildcraft.core.PowerMode;
import buildcraft.core.network.BuildCraftChannelHandler;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.ColorUtils;
import buildcraft.robots.ItemRobotStation;
import buildcraft.robots.RobotStationPluggable;
import buildcraft.silicon.ItemRedstoneChipset;
import buildcraft.transport.BlockFilteredBuffer;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.FacadePluggable;
import buildcraft.transport.GuiHandler;
import buildcraft.transport.ItemFacade;
import buildcraft.transport.ItemGateCopier;
import buildcraft.transport.ItemPipe;
import buildcraft.transport.ItemPipeWire;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeActionProvider;
import buildcraft.transport.PipeColoringRecipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTriggerProvider;
import buildcraft.transport.TileFilteredBuffer;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.TransportProxy;
import buildcraft.transport.WireIconProvider;
import buildcraft.transport.gates.GateDefinition;
import buildcraft.transport.gates.GateExpansionPulsar;
import buildcraft.transport.gates.GateExpansionRedstoneFader;
import buildcraft.transport.gates.GateExpansionTimer;
import buildcraft.transport.gates.GatePluggable;
import buildcraft.transport.gates.ItemGate;
import buildcraft.transport.network.PacketHandlerTransport;
import buildcraft.transport.pipes.PipeFluidsCobblestone;
import buildcraft.transport.pipes.PipeFluidsDiamond;
import buildcraft.transport.pipes.PipeFluidsEmerald;
import buildcraft.transport.pipes.PipeFluidsGold;
import buildcraft.transport.pipes.PipeFluidsIron;
import buildcraft.transport.pipes.PipeFluidsQuartz;
import buildcraft.transport.pipes.PipeFluidsSandstone;
import buildcraft.transport.pipes.PipeFluidsStone;
import buildcraft.transport.pipes.PipeFluidsVoid;
import buildcraft.transport.pipes.PipeFluidsWood;
import buildcraft.transport.pipes.PipeItemsClay;
import buildcraft.transport.pipes.PipeItemsCobblestone;
import buildcraft.transport.pipes.PipeItemsDaizuli;
import buildcraft.transport.pipes.PipeItemsDiamond;
import buildcraft.transport.pipes.PipeItemsEmerald;
import buildcraft.transport.pipes.PipeItemsEmzuli;
import buildcraft.transport.pipes.PipeItemsGold;
import buildcraft.transport.pipes.PipeItemsIron;
import buildcraft.transport.pipes.PipeItemsLapis;
import buildcraft.transport.pipes.PipeItemsObsidian;
import buildcraft.transport.pipes.PipeItemsQuartz;
import buildcraft.transport.pipes.PipeItemsSandstone;
import buildcraft.transport.pipes.PipeItemsStone;
import buildcraft.transport.pipes.PipeItemsStripes;
import buildcraft.transport.pipes.PipeItemsVoid;
import buildcraft.transport.pipes.PipeItemsWood;
import buildcraft.transport.pipes.PipePowerCobblestone;
import buildcraft.transport.pipes.PipePowerDiamond;
import buildcraft.transport.pipes.PipePowerEmerald;
import buildcraft.transport.pipes.PipePowerGold;
import buildcraft.transport.pipes.PipePowerIron;
import buildcraft.transport.pipes.PipePowerQuartz;
import buildcraft.transport.pipes.PipePowerSandstone;
import buildcraft.transport.pipes.PipePowerStone;
import buildcraft.transport.pipes.PipePowerWood;
import buildcraft.transport.pipes.PipeStructureCobblestone;
import buildcraft.transport.pluggable.ItemLens;
import buildcraft.transport.pluggable.ItemPlug;
import buildcraft.transport.pluggable.LensPluggable;
import buildcraft.transport.pluggable.PlugPluggable;
import buildcraft.transport.recipes.AdvancedFacadeRecipe;
import buildcraft.transport.recipes.GateExpansionRecipe;
import buildcraft.transport.recipes.GateLogicSwapRecipe;
import buildcraft.transport.schematics.BptItemPipeFilters;
import buildcraft.transport.schematics.BptPipeIron;
import buildcraft.transport.schematics.BptPipeWooden;
import buildcraft.transport.schematics.SchematicPipe;
import buildcraft.transport.statements.ActionEnergyPulsar;
import buildcraft.transport.statements.ActionExtractionPreset;
import buildcraft.transport.statements.ActionParameterSignal;
import buildcraft.transport.statements.ActionPipeColor;
import buildcraft.transport.statements.ActionPipeDirection;
import buildcraft.transport.statements.ActionPowerLimiter;
import buildcraft.transport.statements.ActionRedstoneFaderOutput;
import buildcraft.transport.statements.ActionSignalOutput;
import buildcraft.transport.statements.ActionSingleEnergyPulse;
import buildcraft.transport.statements.ActionValve;
import buildcraft.transport.statements.TriggerClockTimer;
import buildcraft.transport.statements.TriggerParameterSignal;
import buildcraft.transport.statements.TriggerPipeContents;
import buildcraft.transport.statements.TriggerPipeSignal;
import buildcraft.transport.statements.TriggerRedstoneFaderInput;
import buildcraft.transport.stripes.StripesHandlerArrow;
import buildcraft.transport.stripes.StripesHandlerBucket;
import buildcraft.transport.stripes.StripesHandlerEntityInteract;
import buildcraft.transport.stripes.StripesHandlerHoe;
import buildcraft.transport.stripes.StripesHandlerPipes;
import buildcraft.transport.stripes.StripesHandlerPlaceBlock;
import buildcraft.transport.stripes.StripesHandlerRightClick;
import buildcraft.transport.stripes.StripesHandlerShears;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import io.netty.channel.ChannelHandler;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.RecipeSorter;

@Mod(version="6.4.10", modid="BuildCraft|Transport", name="Buildcraft Transport", dependencies="required-after:BuildCraft|Core@6.4.10")
public class BuildCraftTransport
extends BuildCraftMod {
    @Mod.Instance(value="BuildCraft|Transport")
    public static BuildCraftTransport instance;
    public static float pipeDurability;
    public static int pipeFluidsBaseFlowRate;
    public static boolean facadeTreatBlacklistAsWhitelist;
    public static boolean additionalWaterproofingRecipe;
    public static BlockGenericPipe genericPipeBlock;
    public static BlockFilteredBuffer filteredBufferBlock;
    public static Item pipeWaterproof;
    public static Item pipeGate;
    public static Item pipeWire;
    public static Item plugItem;
    public static Item lensItem;
    public static Item powerAdapterItem;
    public static Item robotStationItem;
    public static Item pipeStructureCobblestone;
    public static Item gateCopier;
    public static ItemFacade facadeItem;
    public static Item pipeItemsWood;
    public static Item pipeItemsEmerald;
    public static Item pipeItemsStone;
    public static Item pipeItemsCobblestone;
    public static Item pipeItemsIron;
    public static Item pipeItemsQuartz;
    public static Item pipeItemsGold;
    public static Item pipeItemsDiamond;
    public static Item pipeItemsObsidian;
    public static Item pipeItemsLapis;
    public static Item pipeItemsDaizuli;
    public static Item pipeItemsVoid;
    public static Item pipeItemsSandstone;
    public static Item pipeItemsEmzuli;
    public static Item pipeItemsStripes;
    public static Item pipeItemsClay;
    public static Item pipeFluidsWood;
    public static Item pipeFluidsCobblestone;
    public static Item pipeFluidsStone;
    public static Item pipeFluidsQuartz;
    public static Item pipeFluidsIron;
    public static Item pipeFluidsGold;
    public static Item pipeFluidsVoid;
    public static Item pipeFluidsSandstone;
    public static Item pipeFluidsEmerald;
    public static Item pipeFluidsDiamond;
    public static Item pipePowerWood;
    public static Item pipePowerCobblestone;
    public static Item pipePowerStone;
    public static Item pipePowerQuartz;
    public static Item pipePowerIron;
    public static Item pipePowerGold;
    public static Item pipePowerDiamond;
    public static Item pipePowerEmerald;
    public static Item pipePowerSandstone;
    public static int groupItemsTrigger;
    public static String[] facadeBlacklist;
    public static ITriggerInternal[] triggerPipe;
    public static ITriggerInternal[] triggerPipeWireActive;
    public static ITriggerInternal[] triggerPipeWireInactive;
    public static ITriggerInternal[] triggerTimer;
    public static ITriggerInternal[] triggerRedstoneLevel;
    public static IActionInternal[] actionPipeWire;
    public static IActionInternal actionEnergyPulser;
    public static IActionInternal actionSingleEnergyPulse;
    public static IActionInternal[] actionPipeColor;
    public static IActionInternal[] actionPipeDirection;
    public static IActionInternal[] actionPowerLimiter;
    public static IActionInternal[] actionRedstoneLevel;
    public static IActionInternal actionExtractionPresetRed;
    public static IActionInternal actionExtractionPresetBlue;
    public static IActionInternal actionExtractionPresetGreen;
    public static IActionInternal actionExtractionPresetYellow;
    public static IActionInternal[] actionValve;
    public static boolean debugPrintFacadeList;
    public static float gateCostMultiplier;
    private static LinkedList<PipeRecipe> pipeRecipes;
    public IIconProvider pipeIconProvider = new PipeIconProvider();
    public IIconProvider wireIconProvider = new WireIconProvider();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        try {
            Property durability = BuildCraftCore.mainConfiguration.get("general", "pipes.durability", DefaultProps.PIPES_DURABILITY);
            durability.comment = "How long a pipe will take to break";
            pipeDurability = (float)durability.getDouble(DefaultProps.PIPES_DURABILITY);
            Property baseFlowRate = BuildCraftCore.mainConfiguration.get("general", "pipes.fluids.baseFlowRate", DefaultProps.PIPES_FLUIDS_BASE_FLOW_RATE);
            pipeFluidsBaseFlowRate = baseFlowRate.getInt();
            Property printFacadeList = BuildCraftCore.mainConfiguration.get("debug", "facades.printFacadeList", false);
            debugPrintFacadeList = printFacadeList.getBoolean();
            Property enableAdditionalWaterproofingRecipe = BuildCraftCore.mainConfiguration.get("general", "pipes.fluids.enableAdditionalWaterproofingRecipe", true);
            enableAdditionalWaterproofingRecipe.comment = "Enable the slimeball based pipe waterproofing recipe";
            additionalWaterproofingRecipe = enableAdditionalWaterproofingRecipe.getBoolean();
            gateCostMultiplier = BuildCraftCore.mainConfiguration.getFloat("gate.recipeCostMultiplier", "general", 1.0f, 0.001f, 1000.0f, "The multiplier for gate recipe cost.");
            filteredBufferBlock = new BlockFilteredBuffer();
            CoreProxy.proxy.registerBlock(filteredBufferBlock.setBlockName("filteredBufferBlock"));
            GateExpansions.registerExpansion(GateExpansionPulsar.INSTANCE);
            GateExpansions.registerExpansion(GateExpansionTimer.INSTANCE);
            GateExpansions.registerExpansion(GateExpansionRedstoneFader.INSTANCE);
            Property groupItemsTriggerProp = BuildCraftCore.mainConfiguration.get("general", "pipes.groupItemsTrigger", 32);
            groupItemsTriggerProp.comment = "when reaching this amount of objects in a pipes, items will be automatically grouped";
            groupItemsTrigger = groupItemsTriggerProp.getInt();
            Property facadeBlacklistProp = BuildCraftCore.mainConfiguration.get("general", "facade.blacklist", new String[]{Block.blockRegistry.getNameForObject((Object)Blocks.bedrock), Block.blockRegistry.getNameForObject((Object)Blocks.command_block), Block.blockRegistry.getNameForObject((Object)Blocks.end_portal_frame), Block.blockRegistry.getNameForObject((Object)Blocks.grass), Block.blockRegistry.getNameForObject((Object)Blocks.leaves), Block.blockRegistry.getNameForObject((Object)Blocks.leaves2), Block.blockRegistry.getNameForObject((Object)Blocks.lit_pumpkin), Block.blockRegistry.getNameForObject((Object)Blocks.lit_redstone_lamp), Block.blockRegistry.getNameForObject((Object)Blocks.mob_spawner), Block.blockRegistry.getNameForObject((Object)Blocks.monster_egg), Block.blockRegistry.getNameForObject((Object)Blocks.redstone_lamp), Block.blockRegistry.getNameForObject((Object)Blocks.double_stone_slab), Block.blockRegistry.getNameForObject((Object)Blocks.double_wooden_slab), Block.blockRegistry.getNameForObject((Object)Blocks.sponge), JavaTools.surroundWithQuotes(Block.blockRegistry.getNameForObject((Object)BuildCraftBuilders.architectBlock)), JavaTools.surroundWithQuotes(Block.blockRegistry.getNameForObject((Object)BuildCraftBuilders.builderBlock)), JavaTools.surroundWithQuotes(Block.blockRegistry.getNameForObject((Object)BuildCraftBuilders.fillerBlock)), JavaTools.surroundWithQuotes(Block.blockRegistry.getNameForObject((Object)BuildCraftBuilders.libraryBlock)), JavaTools.surroundWithQuotes(Block.blockRegistry.getNameForObject((Object)BuildCraftFactory.autoWorkbenchBlock)), JavaTools.surroundWithQuotes(Block.blockRegistry.getNameForObject((Object)BuildCraftFactory.floodGateBlock)), JavaTools.surroundWithQuotes(Block.blockRegistry.getNameForObject((Object)BuildCraftFactory.miningWellBlock)), JavaTools.surroundWithQuotes(Block.blockRegistry.getNameForObject((Object)BuildCraftFactory.pumpBlock)), JavaTools.surroundWithQuotes(Block.blockRegistry.getNameForObject((Object)BuildCraftFactory.quarryBlock)), JavaTools.surroundWithQuotes(Block.blockRegistry.getNameForObject((Object)filteredBufferBlock))});
            facadeBlacklistProp.comment = "Blocks listed here will not have facades created. The format is modid:blockname.\nFor mods with a | character, the value needs to be surrounded with quotes.";
            facadeBlacklist = facadeBlacklistProp.getStringList();
            Property facadeAsWhitelist = BuildCraftCore.mainConfiguration.get("general", "facade.treatBlacklistAsWhitelist", false);
            facadeTreatBlacklistAsWhitelist = facadeAsWhitelist.getBoolean();
            pipeWaterproof = new ItemBuildCraft();
            pipeWaterproof.setUnlocalizedName("pipeWaterproof");
            CoreProxy.proxy.registerItem(pipeWaterproof);
            genericPipeBlock = (BlockGenericPipe)CompatHooks.INSTANCE.getBlock(BlockGenericPipe.class);
            CoreProxy.proxy.registerBlock(genericPipeBlock.setBlockName("pipeBlock"), ItemBlock.class);
            pipeItemsWood = BuildCraftTransport.buildPipe(PipeItemsWood.class, "Wooden Transport Pipe", CreativeTabBuildCraft.PIPES, "plankWood", Blocks.glass, "plankWood");
            pipeItemsEmerald = BuildCraftTransport.buildPipe(PipeItemsEmerald.class, "Emerald Transport Pipe", CreativeTabBuildCraft.PIPES, "gemEmerald", Blocks.glass, "gemEmerald");
            pipeItemsCobblestone = BuildCraftTransport.buildPipe(PipeItemsCobblestone.class, "Cobblestone Transport Pipe", CreativeTabBuildCraft.PIPES, "cobblestone", Blocks.glass, "cobblestone");
            pipeItemsStone = BuildCraftTransport.buildPipe(PipeItemsStone.class, "Stone Transport Pipe", CreativeTabBuildCraft.PIPES, "stone", Blocks.glass, "stone");
            pipeItemsQuartz = BuildCraftTransport.buildPipe(PipeItemsQuartz.class, "Quartz Transport Pipe", CreativeTabBuildCraft.PIPES, "blockQuartz", Blocks.glass, "blockQuartz");
            pipeItemsIron = BuildCraftTransport.buildPipe(PipeItemsIron.class, "Iron Transport Pipe", CreativeTabBuildCraft.PIPES, "ingotIron", Blocks.glass, "ingotIron");
            pipeItemsGold = BuildCraftTransport.buildPipe(PipeItemsGold.class, "Golden Transport Pipe", CreativeTabBuildCraft.PIPES, "ingotGold", Blocks.glass, "ingotGold");
            pipeItemsDiamond = BuildCraftTransport.buildPipe(PipeItemsDiamond.class, "Diamond Transport Pipe", CreativeTabBuildCraft.PIPES, "gemDiamond", Blocks.glass, "gemDiamond");
            pipeItemsObsidian = BuildCraftTransport.buildPipe(PipeItemsObsidian.class, "Obsidian Transport Pipe", CreativeTabBuildCraft.PIPES, Blocks.obsidian, Blocks.glass, Blocks.obsidian);
            pipeItemsLapis = BuildCraftTransport.buildPipe(PipeItemsLapis.class, "Lapis Transport Pipe", CreativeTabBuildCraft.PIPES, "blockLapis", Blocks.glass, "blockLapis");
            pipeItemsDaizuli = BuildCraftTransport.buildPipe(PipeItemsDaizuli.class, "Daizuli Transport Pipe", CreativeTabBuildCraft.PIPES, "blockLapis", Blocks.glass, "gemDiamond");
            pipeItemsSandstone = BuildCraftTransport.buildPipe(PipeItemsSandstone.class, "Sandstone Transport Pipe", CreativeTabBuildCraft.PIPES, Blocks.sandstone, Blocks.glass, Blocks.sandstone);
            pipeItemsVoid = BuildCraftTransport.buildPipe(PipeItemsVoid.class, "Void Transport Pipe", CreativeTabBuildCraft.PIPES, "dyeBlack", Blocks.glass, "dustRedstone");
            pipeItemsEmzuli = BuildCraftTransport.buildPipe(PipeItemsEmzuli.class, "Emzuli Transport Pipe", CreativeTabBuildCraft.PIPES, "blockLapis", Blocks.glass, "gemEmerald");
            pipeItemsStripes = BuildCraftTransport.buildPipe(PipeItemsStripes.class, "Stripes Transport Pipe", CreativeTabBuildCraft.PIPES, "gearGold", Blocks.glass, "gearGold");
            pipeItemsClay = BuildCraftTransport.buildPipe(PipeItemsClay.class, "Clay Transport Pipe", CreativeTabBuildCraft.PIPES, Blocks.clay, Blocks.glass, Blocks.clay);
            pipeFluidsWood = BuildCraftTransport.buildPipe(PipeFluidsWood.class, "Wooden Waterproof Pipe", CreativeTabBuildCraft.PIPES, pipeWaterproof, pipeItemsWood);
            pipeFluidsCobblestone = BuildCraftTransport.buildPipe(PipeFluidsCobblestone.class, "Cobblestone Waterproof Pipe", CreativeTabBuildCraft.PIPES, pipeWaterproof, pipeItemsCobblestone);
            pipeFluidsStone = BuildCraftTransport.buildPipe(PipeFluidsStone.class, "Stone Waterproof Pipe", CreativeTabBuildCraft.PIPES, pipeWaterproof, pipeItemsStone);
            pipeFluidsQuartz = BuildCraftTransport.buildPipe(PipeFluidsQuartz.class, "Quartz Waterproof Pipe", CreativeTabBuildCraft.PIPES, pipeWaterproof, pipeItemsQuartz);
            pipeFluidsIron = BuildCraftTransport.buildPipe(PipeFluidsIron.class, "Iron Waterproof Pipe", CreativeTabBuildCraft.PIPES, pipeWaterproof, pipeItemsIron);
            pipeFluidsGold = BuildCraftTransport.buildPipe(PipeFluidsGold.class, "Golden Waterproof Pipe", CreativeTabBuildCraft.PIPES, pipeWaterproof, pipeItemsGold);
            pipeFluidsEmerald = BuildCraftTransport.buildPipe(PipeFluidsEmerald.class, "Emerald Waterproof Pipe", CreativeTabBuildCraft.PIPES, pipeWaterproof, pipeItemsEmerald);
            pipeFluidsDiamond = BuildCraftTransport.buildPipe(PipeFluidsDiamond.class, "Diamond Waterproof Pipe", CreativeTabBuildCraft.PIPES, pipeWaterproof, pipeItemsDiamond);
            pipeFluidsSandstone = BuildCraftTransport.buildPipe(PipeFluidsSandstone.class, "Sandstone Waterproof Pipe", CreativeTabBuildCraft.PIPES, pipeWaterproof, pipeItemsSandstone);
            pipeFluidsVoid = BuildCraftTransport.buildPipe(PipeFluidsVoid.class, "Void Waterproof Pipe", CreativeTabBuildCraft.PIPES, pipeWaterproof, pipeItemsVoid);
            pipePowerWood = BuildCraftTransport.buildPipe(PipePowerWood.class, "Wooden Kinesis Pipe", CreativeTabBuildCraft.PIPES, "dustRedstone", pipeItemsWood);
            pipePowerCobblestone = BuildCraftTransport.buildPipe(PipePowerCobblestone.class, "Cobblestone Kinesis Pipe", CreativeTabBuildCraft.PIPES, "dustRedstone", pipeItemsCobblestone);
            pipePowerStone = BuildCraftTransport.buildPipe(PipePowerStone.class, "Stone Kinesis Pipe", CreativeTabBuildCraft.PIPES, "dustRedstone", pipeItemsStone);
            pipePowerQuartz = BuildCraftTransport.buildPipe(PipePowerQuartz.class, "Quartz Kinesis Pipe", CreativeTabBuildCraft.PIPES, "dustRedstone", pipeItemsQuartz);
            pipePowerIron = BuildCraftTransport.buildPipe(PipePowerIron.class, "Iron Kinesis Pipe", CreativeTabBuildCraft.PIPES, "dustRedstone", pipeItemsIron);
            pipePowerGold = BuildCraftTransport.buildPipe(PipePowerGold.class, "Golden Kinesis Pipe", CreativeTabBuildCraft.PIPES, "dustRedstone", pipeItemsGold);
            pipePowerDiamond = BuildCraftTransport.buildPipe(PipePowerDiamond.class, "Diamond Kinesis Pipe", CreativeTabBuildCraft.PIPES, "dustRedstone", pipeItemsDiamond);
            pipePowerEmerald = BuildCraftTransport.buildPipe(PipePowerEmerald.class, "Emerald Kinesis Pipe", CreativeTabBuildCraft.PIPES, "dustRedstone", pipeItemsEmerald);
            pipePowerSandstone = BuildCraftTransport.buildPipe(PipePowerSandstone.class, "Sandstone Kinesis Pipe", CreativeTabBuildCraft.PIPES, "dustRedstone", pipeItemsSandstone);
            pipeStructureCobblestone = BuildCraftTransport.buildPipe(PipeStructureCobblestone.class, "Cobblestone Structure Pipe", CreativeTabBuildCraft.PIPES, Blocks.gravel, pipeItemsCobblestone);
            pipeWire = new ItemPipeWire();
            CoreProxy.proxy.registerItem(pipeWire);
            PipeWire.item = pipeWire;
            pipeGate = new ItemGate();
            pipeGate.setUnlocalizedName("pipeGate");
            CoreProxy.proxy.registerItem(pipeGate);
            facadeItem = new ItemFacade();
            facadeItem.setUnlocalizedName("pipeFacade");
            CoreProxy.proxy.registerItem(facadeItem);
            plugItem = new ItemPlug();
            plugItem.setUnlocalizedName("pipePlug");
            CoreProxy.proxy.registerItem(plugItem);
            lensItem = new ItemLens();
            lensItem.setUnlocalizedName("pipeLens");
            CoreProxy.proxy.registerItem(lensItem);
            robotStationItem = new ItemRobotStation();
            robotStationItem.setUnlocalizedName("robotStation");
            CoreProxy.proxy.registerItem(robotStationItem);
            gateCopier = new ItemGateCopier();
            CoreProxy.proxy.registerItem(gateCopier);
            for (TriggerPipeContents.PipeContents pipeContents : TriggerPipeContents.PipeContents.values()) {
                BuildCraftTransport.triggerPipe[pipeContents.ordinal()] = new TriggerPipeContents(pipeContents);
            }
            for (Enum enum_ : PipeWire.values()) {
                BuildCraftTransport.triggerPipeWireActive[enum_.ordinal()] = new TriggerPipeSignal(true, (PipeWire)enum_);
                BuildCraftTransport.triggerPipeWireInactive[enum_.ordinal()] = new TriggerPipeSignal(false, (PipeWire)enum_);
                BuildCraftTransport.actionPipeWire[enum_.ordinal()] = new ActionSignalOutput((PipeWire)enum_);
            }
            for (Enum enum_ : TriggerClockTimer.Time.VALUES) {
                BuildCraftTransport.triggerTimer[enum_.ordinal()] = new TriggerClockTimer((TriggerClockTimer.Time)enum_);
            }
            for (int level = 0; level < triggerRedstoneLevel.length; ++level) {
                BuildCraftTransport.triggerRedstoneLevel[level] = new TriggerRedstoneFaderInput(level + 1);
                BuildCraftTransport.actionRedstoneLevel[level] = new ActionRedstoneFaderOutput(level + 1);
            }
            for (EnumColor enumColor : EnumColor.VALUES) {
                BuildCraftTransport.actionPipeColor[enumColor.ordinal()] = new ActionPipeColor(enumColor);
            }
            for (EnumColor enumColor : ForgeDirection.VALID_DIRECTIONS) {
                BuildCraftTransport.actionPipeDirection[enumColor.ordinal()] = new ActionPipeDirection((ForgeDirection)enumColor);
            }
            for (Enum enum_ : ActionValve.ValveState.VALUES) {
                BuildCraftTransport.actionValve[enum_.ordinal()] = new ActionValve((ActionValve.ValveState)enum_);
            }
            for (Enum enum_ : PowerMode.VALUES) {
                BuildCraftTransport.actionPowerLimiter[enum_.ordinal()] = new ActionPowerLimiter((PowerMode)enum_);
            }
        }
        finally {
            BuildCraftCore.mainConfiguration.save();
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        this.channels = NetworkRegistry.INSTANCE.newChannel("BC-TRANSPORT", new ChannelHandler[]{new BuildCraftChannelHandler(), new PacketHandlerTransport()});
        TransportProxy.proxy.registerTileEntities();
        BuilderAPI.schematicRegistry.registerSchematicBlock((Block)genericPipeBlock, SchematicPipe.class, new Object[0]);
        new BptPipeIron(pipeItemsIron);
        new BptPipeIron(pipeFluidsIron);
        new BptPipeIron(pipePowerIron);
        new BptPipeWooden(pipeItemsWood);
        new BptPipeWooden(pipeFluidsWood);
        new BptPipeWooden(pipePowerWood);
        new BptPipeWooden(pipeItemsEmerald);
        new BptItemPipeFilters(pipeItemsDiamond);
        StatementManager.registerParameterClass(TriggerParameterSignal.class);
        StatementManager.registerParameterClass(ActionParameterSignal.class);
        StatementManager.registerTriggerProvider(new PipeTriggerProvider());
        StatementManager.registerActionProvider(new PipeActionProvider());
        PipeManager.registerStripesHandler(new StripesHandlerRightClick());
        PipeManager.registerStripesHandler(new StripesHandlerBucket());
        PipeManager.registerStripesHandler(new StripesHandlerArrow());
        PipeManager.registerStripesHandler(new StripesHandlerShears());
        PipeManager.registerStripesHandler(new StripesHandlerPipes());
        PipeManager.registerStripesHandler(new StripesHandlerEntityInteract());
        PipeManager.registerStripesHandler(new StripesHandlerPlaceBlock());
        PipeManager.registerStripesHandler(new StripesHandlerHoe());
        PipeManager.registerPipePluggable(FacadePluggable.class, "facade");
        PipeManager.registerPipePluggable(GatePluggable.class, "gate");
        PipeManager.registerPipePluggable(LensPluggable.class, "lens");
        PipeManager.registerPipePluggable(PlugPluggable.class, "plug");
        PipeManager.registerPipePluggable(RobotStationPluggable.class, "robotStation");
        if (BuildCraftCore.loadDefaultRecipes) {
            this.loadRecipes();
        }
        TransportProxy.proxy.registerRenderers();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        facadeItem.initialize();
        if (debugPrintFacadeList) {
            try {
                PrintWriter writer = new PrintWriter("FacadeDebug.txt", "UTF-8");
                writer.println("*** REGISTERED FACADES ***");
                for (ItemStack stack : ItemFacade.allFacades) {
                    if (facadeItem.getBlocksForFacade(stack).length <= 0) continue;
                    writer.println(Block.blockRegistry.getNameForObject((Object)facadeItem.getBlocksForFacade(stack)[0]) + ":" + facadeItem.getMetaValuesForFacade(stack)[0]);
                }
                writer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void loadRecipes() {
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(pipeWaterproof, 1), (Object[])new Object[]{new ItemStack(Items.dye, 1, 2)});
        if (additionalWaterproofingRecipe) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(pipeWaterproof, 1), (Object[])new Object[]{new ItemStack(Items.slime_ball, 1)});
        }
        for (PipeRecipe pipe : pipeRecipes) {
            if (pipe.isShapeless) {
                CoreProxy.proxy.addShapelessRecipe(pipe.result, pipe.input);
                continue;
            }
            CoreProxy.proxy.addCraftingRecipe(pipe.result, pipe.input);
        }
        GameRegistry.addRecipe((IRecipe)new PipeColoringRecipe());
        RecipeSorter.register((String)"buildcraft:pipecoloring", PipeColoringRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)filteredBufferBlock, 1), "wdw", "wcw", "wpw", Character.valueOf('w'), "plankWood", Character.valueOf('d'), pipeItemsDiamond, Character.valueOf('c'), Blocks.chest, Character.valueOf('p'), Blocks.piston);
        GameRegistry.addRecipe((IRecipe)new ItemFacade.FacadeRecipe(facadeItem));
        RecipeSorter.register((String)"facadeTurningHelper", ItemFacade.FacadeRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"");
        BuildcraftRecipeRegistry.assemblyTable.addRecipe("buildcraft:pipePlug", 10000, new ItemStack(plugItem, 8), new ItemStack(pipeStructureCobblestone));
        CoreProxy.proxy.addCraftingRecipe(new ItemStack(robotStationItem), "   ", " I ", "ICI", Character.valueOf('I'), "ingotIron", Character.valueOf('C'), ItemRedstoneChipset.Chipset.GOLD.getStack());
        if (Loader.isModLoaded((String)"BuildCraft|Silicon")) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(gateCopier, 1), (Object[])new Object[]{new ItemStack(BuildCraftCore.wrenchItem), ItemRedstoneChipset.Chipset.RED.getStack(1)});
            BuildcraftRecipeRegistry.assemblyTable.addRecipe("buildcraft:redWire", 5000, PipeWire.RED.getStack(8), "dyeRed", "dustRedstone", "ingotIron");
            BuildcraftRecipeRegistry.assemblyTable.addRecipe("buildcraft:blueWire", 5000, PipeWire.BLUE.getStack(8), "dyeBlue", "dustRedstone", "ingotIron");
            BuildcraftRecipeRegistry.assemblyTable.addRecipe("buildcraft:greenWire", 5000, PipeWire.GREEN.getStack(8), "dyeGreen", "dustRedstone", "ingotIron");
            BuildcraftRecipeRegistry.assemblyTable.addRecipe("buildcraft:yellowWire", 5000, PipeWire.YELLOW.getStack(8), "dyeYellow", "dustRedstone", "ingotIron");
            for (int i = 0; i < 16; ++i) {
                BuildcraftRecipeRegistry.assemblyTable.addRecipe("buildcraft:lens:" + i, 10000, new ItemStack(lensItem, 2, i), ColorUtils.getOreDictionaryName(15 - i), "blockGlass", "ingotIron");
                BuildcraftRecipeRegistry.assemblyTable.addRecipe("buildcraft:filter:" + i, 10000, new ItemStack(lensItem, 2, i + 16), ColorUtils.getOreDictionaryName(15 - i), "blockGlass", Blocks.iron_bars);
            }
            BuildcraftRecipeRegistry.assemblyTable.addRecipe("buildcraft:simpleGate", Math.round(100000.0f * gateCostMultiplier), ItemGate.makeGateItem(GateDefinition.GateMaterial.REDSTONE, GateDefinition.GateLogic.AND), ItemRedstoneChipset.Chipset.RED.getStack(), PipeWire.RED.getStack());
            BuildCraftTransport.addGateRecipe("Iron", Math.round(200000.0f * gateCostMultiplier), GateDefinition.GateMaterial.IRON, ItemRedstoneChipset.Chipset.IRON, PipeWire.RED, PipeWire.BLUE);
            BuildCraftTransport.addGateRecipe("Gold", Math.round(400000.0f * gateCostMultiplier), GateDefinition.GateMaterial.GOLD, ItemRedstoneChipset.Chipset.GOLD, PipeWire.RED, PipeWire.BLUE, PipeWire.GREEN);
            BuildCraftTransport.addGateRecipe("Quartz", Math.round(600000.0f * gateCostMultiplier), GateDefinition.GateMaterial.QUARTZ, ItemRedstoneChipset.Chipset.QUARTZ, PipeWire.RED, PipeWire.BLUE, PipeWire.GREEN);
            BuildCraftTransport.addGateRecipe("Diamond", Math.round(800000.0f * gateCostMultiplier), GateDefinition.GateMaterial.DIAMOND, ItemRedstoneChipset.Chipset.DIAMOND, PipeWire.RED, PipeWire.BLUE, PipeWire.GREEN, PipeWire.YELLOW);
            BuildCraftTransport.addGateRecipe("Emerald", Math.round(1200000.0f * gateCostMultiplier), GateDefinition.GateMaterial.EMERALD, ItemRedstoneChipset.Chipset.EMERALD, PipeWire.RED, PipeWire.BLUE, PipeWire.GREEN, PipeWire.YELLOW);
            BuildcraftRecipeRegistry.integrationTable.addRecipe(new GateLogicSwapRecipe("buildcraft:gateSwap"));
            BuildcraftRecipeRegistry.integrationTable.addRecipe(new GateExpansionRecipe("buildcraft:expansionPulsar", GateExpansionPulsar.INSTANCE, ItemRedstoneChipset.Chipset.PULSATING.getStack()));
            BuildcraftRecipeRegistry.integrationTable.addRecipe(new GateExpansionRecipe("buildcraft:expansionQuartz", GateExpansionTimer.INSTANCE, ItemRedstoneChipset.Chipset.QUARTZ.getStack()));
            BuildcraftRecipeRegistry.integrationTable.addRecipe(new GateExpansionRecipe("buildcraft:expansionComp", GateExpansionRedstoneFader.INSTANCE, ItemRedstoneChipset.Chipset.COMP.getStack()));
            BuildcraftRecipeRegistry.integrationTable.addRecipe(new AdvancedFacadeRecipe("buildcraft:advancedFacade"));
        }
    }

    private static void addGateRecipe(String materialName, int energyCost, GateDefinition.GateMaterial material, ItemRedstoneChipset.Chipset chipset, PipeWire ... pipeWire) {
        ArrayList<ItemStack> temp = new ArrayList<ItemStack>();
        temp.add(chipset.getStack());
        for (PipeWire wire : pipeWire) {
            temp.add(wire.getStack());
        }
        Object[] inputs = temp.toArray();
        BuildcraftRecipeRegistry.assemblyTable.addRecipe("buildcraft:andGate" + materialName, energyCost, ItemGate.makeGateItem(material, GateDefinition.GateLogic.AND), inputs);
        BuildcraftRecipeRegistry.assemblyTable.addRecipe("buildcraft:orGate" + materialName, energyCost, ItemGate.makeGateItem(material, GateDefinition.GateLogic.OR), inputs);
    }

    @Mod.EventHandler
    public void processIMCRequests(FMLInterModComms.IMCEvent event) {
        InterModComms.processIMC(event);
    }

    public static Item buildPipe(Class<? extends Pipe> clas, String descr, CreativeTabBuildCraft creativeTab, Object ... ingredients) {
        ItemPipe res;
        block4: {
            block3: {
                res = BlockGenericPipe.registerPipe(clas, creativeTab);
                res.setUnlocalizedName(clas.getSimpleName());
                if (ingredients.length != 3) break block3;
                for (int i = 0; i < 17; ++i) {
                    PipeRecipe recipe = new PipeRecipe();
                    ItemStack glass = i == 0 ? new ItemStack(Blocks.glass) : new ItemStack((Block)Blocks.stained_glass, 1, i - 1);
                    recipe.result = new ItemStack((Item)res, 8, i);
                    recipe.input = new Object[]{"ABC", Character.valueOf('A'), ingredients[0], Character.valueOf('B'), glass, Character.valueOf('C'), ingredients[2]};
                    pipeRecipes.add(recipe);
                }
                break block4;
            }
            if (ingredients.length != 2) break block4;
            for (int i = 0; i < 17; ++i) {
                PipeRecipe recipe = new PipeRecipe();
                Object left = ingredients[0];
                Object right = ingredients[1];
                if (ingredients[1] instanceof ItemPipe) {
                    right = new ItemStack((Item)right, 1, i);
                }
                recipe.isShapeless = true;
                recipe.result = new ItemStack((Item)res, 1, i);
                recipe.input = new Object[]{left, right};
                pipeRecipes.add(recipe);
                if (!(ingredients[1] instanceof ItemPipe)) continue;
                PipeRecipe uncraft = new PipeRecipe();
                uncraft.isShapeless = true;
                uncraft.input = new Object[]{recipe.result};
                uncraft.result = (ItemStack)right;
                pipeRecipes.add(uncraft);
            }
        }
        return res;
    }

    @Mod.EventHandler
    public void whiteListAppliedEnergetics(FMLInitializationEvent event) {
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileGenericPipe.class.getCanonicalName());
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileFilteredBuffer.class.getCanonicalName());
    }

    static {
        triggerPipe = new ITriggerInternal[TriggerPipeContents.PipeContents.values().length];
        triggerPipeWireActive = new ITriggerInternal[PipeWire.values().length];
        triggerPipeWireInactive = new ITriggerInternal[PipeWire.values().length];
        triggerTimer = new ITriggerInternal[TriggerClockTimer.Time.VALUES.length];
        triggerRedstoneLevel = new ITriggerInternal[15];
        actionPipeWire = new ActionSignalOutput[PipeWire.values().length];
        actionEnergyPulser = new ActionEnergyPulsar();
        actionSingleEnergyPulse = new ActionSingleEnergyPulse();
        actionPipeColor = new IActionInternal[16];
        actionPipeDirection = new IActionInternal[16];
        actionPowerLimiter = new IActionInternal[7];
        actionRedstoneLevel = new IActionInternal[15];
        actionExtractionPresetRed = new ActionExtractionPreset(EnumColor.RED);
        actionExtractionPresetBlue = new ActionExtractionPreset(EnumColor.BLUE);
        actionExtractionPresetGreen = new ActionExtractionPreset(EnumColor.GREEN);
        actionExtractionPresetYellow = new ActionExtractionPreset(EnumColor.YELLOW);
        actionValve = new IActionInternal[4];
        debugPrintFacadeList = false;
        gateCostMultiplier = 1.0f;
        pipeRecipes = new LinkedList();
    }

    private static class PipeRecipe {
        boolean isShapeless = false;
        ItemStack result;
        Object[] input;

        private PipeRecipe() {
        }
    }
}

