/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.blueprints;

import buildcraft.api.blueprints.MappingNotFoundException;
import buildcraft.api.core.BCLog;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagShort;
import org.apache.logging.log4j.Level;

public class MappingRegistry {
    public HashMap<Block, Integer> blockToId = new HashMap();
    public ArrayList<Block> idToBlock = new ArrayList();
    public HashMap<Item, Integer> itemToId = new HashMap();
    public ArrayList<Item> idToItem = new ArrayList();
    public HashMap<Class<? extends Entity>, Integer> entityToId = new HashMap();
    public ArrayList<Class<? extends Entity>> idToEntity = new ArrayList();

    private void registerItem(Item item) {
        if (!this.itemToId.containsKey(item)) {
            this.idToItem.add(item);
            this.itemToId.put(item, this.idToItem.size() - 1);
        }
    }

    private void registerBlock(Block block) {
        if (!this.blockToId.containsKey(block)) {
            this.idToBlock.add(block);
            this.blockToId.put(block, this.idToBlock.size() - 1);
        }
    }

    private void registerEntity(Class<? extends Entity> entityClass) {
        if (!this.entityToId.containsKey(entityClass)) {
            this.idToEntity.add(entityClass);
            this.entityToId.put(entityClass, this.idToEntity.size() - 1);
        }
    }

    public Item getItemForId(int id) throws MappingNotFoundException {
        if (id >= this.idToItem.size()) {
            throw new MappingNotFoundException("no item mapping at position " + id);
        }
        Item result = this.idToItem.get(id);
        if (result == null) {
            throw new MappingNotFoundException("no item mapping at position " + id);
        }
        return result;
    }

    public int getIdForItem(Item item) {
        if (!this.itemToId.containsKey(item)) {
            this.registerItem(item);
        }
        return this.itemToId.get(item);
    }

    public int itemIdToRegistry(int id) {
        Item item = Item.getItemById((int)id);
        return this.getIdForItem(item);
    }

    public int itemIdToWorld(int id) throws MappingNotFoundException {
        Item item = this.getItemForId(id);
        return Item.getIdFromItem((Item)item);
    }

    public Block getBlockForId(int id) throws MappingNotFoundException {
        if (id >= this.idToBlock.size()) {
            throw new MappingNotFoundException("no block mapping at position " + id);
        }
        Block result = this.idToBlock.get(id);
        if (result == null) {
            throw new MappingNotFoundException("no block mapping at position " + id);
        }
        return result;
    }

    public int getIdForBlock(Block block) {
        if (!this.blockToId.containsKey(block)) {
            this.registerBlock(block);
        }
        return this.blockToId.get(block);
    }

    public int blockIdToRegistry(int id) {
        Block block = Block.getBlockById((int)id);
        return this.getIdForBlock(block);
    }

    public int blockIdToWorld(int id) throws MappingNotFoundException {
        Block block = this.getBlockForId(id);
        return Block.getIdFromBlock((Block)block);
    }

    public Class<? extends Entity> getEntityForId(int id) throws MappingNotFoundException {
        if (id >= this.idToEntity.size()) {
            throw new MappingNotFoundException("no entity mapping at position " + id);
        }
        Class<? extends Entity> result = this.idToEntity.get(id);
        if (result == null) {
            throw new MappingNotFoundException("no entity mapping at position " + id);
        }
        return result;
    }

    public int getIdForEntity(Class<? extends Entity> entity) {
        if (!this.entityToId.containsKey(entity)) {
            this.registerEntity(entity);
        }
        return this.entityToId.get(entity);
    }

    public void stackToRegistry(NBTTagCompound nbt) {
        Item item = Item.getItemById((int)nbt.getShort("id"));
        nbt.setShort("id", (short)this.getIdForItem(item));
    }

    public void stackToWorld(NBTTagCompound nbt) throws MappingNotFoundException {
        Item item = this.getItemForId(nbt.getShort("id"));
        nbt.setShort("id", (short)Item.getIdFromItem((Item)item));
    }

    private boolean isStackLayout(NBTTagCompound nbt) {
        return nbt.hasKey("id") && nbt.hasKey("Count") && nbt.hasKey("Damage") && nbt.getTag("id") instanceof NBTTagShort && nbt.getTag("Count") instanceof NBTTagByte && nbt.getTag("Damage") instanceof NBTTagShort;
    }

    public void scanAndTranslateStacksToRegistry(NBTTagCompound nbt) {
        if (this.isStackLayout(nbt)) {
            this.stackToRegistry(nbt);
        }
        for (Object keyO : nbt.func_150296_c()) {
            NBTTagList list;
            String key = (String)keyO;
            if (nbt.getTag(key) instanceof NBTTagCompound) {
                this.scanAndTranslateStacksToRegistry(nbt.getCompoundTag(key));
            }
            if (!(nbt.getTag(key) instanceof NBTTagList) || (list = (NBTTagList)nbt.getTag(key)).func_150303_d() != 10) continue;
            for (int i = 0; i < list.tagCount(); ++i) {
                this.scanAndTranslateStacksToRegistry(list.getCompoundTagAt(i));
            }
        }
    }

    public void scanAndTranslateStacksToWorld(NBTTagCompound nbt) throws MappingNotFoundException {
        if (this.isStackLayout(nbt)) {
            this.stackToWorld(nbt);
        }
        for (Object keyO : nbt.func_150296_c()) {
            NBTTagList list;
            String key = (String)keyO;
            if (nbt.getTag(key) instanceof NBTTagCompound) {
                try {
                    this.scanAndTranslateStacksToWorld(nbt.getCompoundTag(key));
                }
                catch (MappingNotFoundException e) {
                    nbt.removeTag(key);
                }
            }
            if (!(nbt.getTag(key) instanceof NBTTagList) || (list = (NBTTagList)nbt.getTag(key)).func_150303_d() != 10) continue;
            for (int i = list.tagCount() - 1; i >= 0; --i) {
                try {
                    this.scanAndTranslateStacksToWorld(list.getCompoundTagAt(i));
                    continue;
                }
                catch (MappingNotFoundException e) {
                    list.removeTag(i);
                }
            }
        }
    }

    public void write(NBTTagCompound nbt) {
        NBTTagList blocksMapping = new NBTTagList();
        for (Block block : this.idToBlock) {
            NBTTagCompound sub = new NBTTagCompound();
            String name = Block.blockRegistry.getNameForObject((Object)block);
            if (name == null || name.length() == 0) {
                BCLog.logger.error("Block " + block.getUnlocalizedName() + " (" + block.getClass().getName() + ") has an empty registry name! This is a bug!");
            } else {
                sub.setString("name", name);
            }
            blocksMapping.appendTag((NBTBase)sub);
        }
        nbt.setTag("blocksMapping", (NBTBase)blocksMapping);
        NBTTagList itemsMapping = new NBTTagList();
        for (Item i : this.idToItem) {
            NBTTagCompound sub = new NBTTagCompound();
            String name = Item.itemRegistry.getNameForObject((Object)i);
            if (name == null || name.length() == 0) {
                BCLog.logger.error("Item " + i.getUnlocalizedName() + " (" + i.getClass().getName() + ") has an empty registry name! This is a bug!");
            } else {
                sub.setString("name", name);
            }
            itemsMapping.appendTag((NBTBase)sub);
        }
        nbt.setTag("itemsMapping", (NBTBase)itemsMapping);
        NBTTagList nBTTagList = new NBTTagList();
        for (Class<? extends Entity> e : this.idToEntity) {
            NBTTagCompound sub = new NBTTagCompound();
            sub.setString("name", e.getCanonicalName());
            nBTTagList.appendTag((NBTBase)sub);
        }
        nbt.setTag("entitiesMapping", (NBTBase)nBTTagList);
    }

    public void read(NBTTagCompound nbt) {
        NBTTagList blocksMapping = nbt.getTagList("blocksMapping", 10);
        for (int i = 0; i < blocksMapping.tagCount(); ++i) {
            NBTTagCompound sub = blocksMapping.getCompoundTagAt(i);
            if (!sub.hasKey("name")) {
                this.idToBlock.add(null);
                BCLog.logger.log(Level.WARN, "Can't load a block - corrupt blueprint!");
                continue;
            }
            String name = sub.getString("name");
            Block b = null;
            if (Block.blockRegistry.containsKey(name)) {
                b = (Block)Block.blockRegistry.getObject(name);
            }
            if (b != null) {
                this.registerBlock(b);
                continue;
            }
            this.idToBlock.add(null);
            BCLog.logger.log(Level.WARN, "Can't load block " + name);
        }
        NBTTagList itemsMapping = nbt.getTagList("itemsMapping", 10);
        for (int i = 0; i < itemsMapping.tagCount(); ++i) {
            NBTTagCompound sub = itemsMapping.getCompoundTagAt(i);
            if (!sub.hasKey("name")) {
                this.idToItem.add(null);
                BCLog.logger.log(Level.WARN, "Can't load an item - corrupt blueprint!");
                continue;
            }
            String name = sub.getString("name");
            Item item = null;
            if (Item.itemRegistry.containsKey(name)) {
                item = (Item)Item.itemRegistry.getObject(name);
            }
            if (item != null) {
                this.registerItem(item);
                continue;
            }
            this.idToItem.add(null);
            BCLog.logger.log(Level.WARN, "Can't load item " + name);
        }
        NBTTagList entitiesMapping = nbt.getTagList("entitiesMapping", 10);
        for (int i = 0; i < entitiesMapping.tagCount(); ++i) {
            NBTTagCompound sub = entitiesMapping.getCompoundTagAt(i);
            String name = sub.getString("name");
            Class<?> e = null;
            try {
                e = Class.forName(name);
            }
            catch (ClassNotFoundException e1) {
                e1.printStackTrace();
            }
            if (e != null) {
                this.registerEntity(e);
                continue;
            }
            this.idToEntity.add(null);
            BCLog.logger.log(Level.WARN, "Can't load entity " + name);
        }
    }
}

