/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.blueprints;

import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.MappingRegistry;
import buildcraft.api.blueprints.SchematicBlockBase;
import buildcraft.api.core.BuildCraftAPI;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.WorldServer;

public class SchematicMask
extends SchematicBlockBase {
    public boolean isConcrete = true;

    public SchematicMask() {
    }

    public SchematicMask(boolean isConcrete) {
        this.isConcrete = isConcrete;
    }

    @Override
    public void placeInWorld(IBuilderContext context, int x, int y, int z, LinkedList<ItemStack> stacks) {
        if (this.isConcrete) {
            if (stacks.size() == 0 || !BuildCraftAPI.isSoftBlock(context.world(), x, y, z)) {
                return;
            }
            ItemStack stack = stacks.getFirst();
            context.world().setBlock(x, y, z, Blocks.air, 0, 3);
            stack.tryPlaceItemIntoWorld((EntityPlayer)BuildCraftAPI.proxy.getBuildCraftPlayer((WorldServer)context.world()).get(), context.world(), x, y, z, 1, 0.0f, 0.0f, 0.0f);
        } else {
            context.world().setBlock(x, y, z, Blocks.air, 0, 3);
        }
    }

    @Override
    public boolean isAlreadyBuilt(IBuilderContext context, int x, int y, int z) {
        if (this.isConcrete) {
            return !BuildCraftAPI.isSoftBlock(context.world(), x, y, z);
        }
        return BuildCraftAPI.isSoftBlock(context.world(), x, y, z);
    }

    @Override
    public void writeSchematicToNBT(NBTTagCompound nbt, MappingRegistry registry) {
        nbt.setBoolean("isConcrete", this.isConcrete);
    }

    @Override
    public void readSchematicFromNBT(NBTTagCompound nbt, MappingRegistry registry) {
        this.isConcrete = nbt.getBoolean("isConcrete");
    }
}

