/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.robots;

import buildcraft.api.core.BlockIndex;
import buildcraft.api.robots.RobotManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class ResourceId {
    public BlockIndex index = new BlockIndex();
    public ForgeDirection side = ForgeDirection.UNKNOWN;
    public int localId = 0;

    protected ResourceId() {
    }

    public boolean equals(Object obj) {
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ResourceId compareId = (ResourceId)obj;
        return this.index.equals(compareId.index) && this.side == compareId.side && this.localId == compareId.localId;
    }

    public int hashCode() {
        return (this.index != null ? this.index.hashCode() : 0) * 37 + (this.side != null ? this.side.ordinal() : 0) * 37 + this.localId;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagCompound indexNBT = new NBTTagCompound();
        this.index.writeTo(indexNBT);
        nbt.setTag("index", (NBTBase)indexNBT);
        nbt.setByte("side", (byte)this.side.ordinal());
        nbt.setInteger("localId", this.localId);
        nbt.setString("resourceName", RobotManager.getResourceIdName(this.getClass()));
    }

    protected void readFromNBT(NBTTagCompound nbt) {
        this.index = new BlockIndex(nbt.getCompoundTag("index"));
        this.side = ForgeDirection.values()[nbt.getByte("side")];
        this.localId = nbt.getInteger("localId");
    }

    public static ResourceId load(NBTTagCompound nbt) {
        try {
            Class<?> cls = null;
            cls = nbt.hasKey("class") ? RobotManager.getResourceIdByLegacyClassName(nbt.getString("class")) : RobotManager.getResourceIdByName(nbt.getString("resourceName"));
            ResourceId id = (ResourceId)cls.newInstance();
            id.readFromNBT(nbt);
            return id;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public void taken(long robotId) {
    }

    public void released(long robotId) {
    }
}

