/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.BuildCraftBuilders;
import buildcraft.api.events.BlockInteractionEvent;
import buildcraft.api.tools.IToolWrench;
import buildcraft.builders.ItemConstructionMarker;
import buildcraft.builders.TileArchitect;
import buildcraft.core.BlockBuildCraft;
import buildcraft.core.CreativeTabBuildCraft;
import buildcraft.core.utils.Utils;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockArchitect
extends BlockBuildCraft {
    IIcon blockTextureTop;
    IIcon blockTextureSide;
    IIcon blockTextureFront;

    public BlockArchitect() {
        super(Material.iron, CreativeTabBuildCraft.BLOCKS);
    }

    public TileEntity createNewTileEntity(World world, int metadata) {
        return new TileArchitect();
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer entityplayer, int par6, float par7, float par8, float par9) {
        Item equipped;
        if (entityplayer.isSneaking()) {
            return false;
        }
        BlockInteractionEvent event = new BlockInteractionEvent(entityplayer, (Block)this);
        FMLCommonHandler.instance().bus().post((Event)event);
        if (event.isCanceled()) {
            return false;
        }
        Item item = equipped = entityplayer.getCurrentEquippedItem() != null ? entityplayer.getCurrentEquippedItem().getItem() : null;
        if (equipped instanceof IToolWrench && ((IToolWrench)equipped).canWrench(entityplayer, x, y, z)) {
            int meta = world.getBlockMetadata(x, y, z);
            switch (ForgeDirection.values()[meta]) {
                case WEST: {
                    world.setBlockMetadataWithNotify(x, y, z, ForgeDirection.SOUTH.ordinal(), 0);
                    break;
                }
                case EAST: {
                    world.setBlockMetadataWithNotify(x, y, z, ForgeDirection.NORTH.ordinal(), 0);
                    break;
                }
                case NORTH: {
                    world.setBlockMetadataWithNotify(x, y, z, ForgeDirection.WEST.ordinal(), 0);
                    break;
                }
                default: {
                    world.setBlockMetadataWithNotify(x, y, z, ForgeDirection.EAST.ordinal(), 0);
                }
            }
            world.markBlockForUpdate(x, y, z);
            ((IToolWrench)equipped).wrenchUsed(entityplayer, x, y, z);
            return true;
        }
        if (equipped instanceof ItemConstructionMarker) {
            ItemConstructionMarker.link(entityplayer.getCurrentEquippedItem(), world, x, y, z);
            return true;
        }
        if (!world.isRemote) {
            entityplayer.openGui((Object)BuildCraftBuilders.instance, 10, world, x, y, z);
        }
        return true;
    }

    @Override
    public void breakBlock(World world, int i, int j, int k, Block block, int par6) {
        Utils.preDestroyBlock(world, i, j, k);
        super.breakBlock(world, i, j, k, block, par6);
    }

    @Override
    public void onBlockPlacedBy(World world, int i, int j, int k, EntityLivingBase entityliving, ItemStack stack) {
        super.onBlockPlacedBy(world, i, j, k, entityliving, stack);
        ForgeDirection orientation = Utils.get2dOrientation(entityliving);
        world.setBlockMetadataWithNotify(i, j, k, orientation.getOpposite().ordinal(), 1);
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return false;
    }

    @Override
    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int i, int j) {
        if (j == 0 && i == 3) {
            return this.blockTextureFront;
        }
        if (i == j) {
            return this.blockTextureFront;
        }
        switch (i) {
            case 1: {
                return this.blockTextureTop;
            }
        }
        return this.blockTextureSide;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister par1IconRegister) {
        this.blockTextureTop = par1IconRegister.registerIcon("buildcraft:architect_top");
        this.blockTextureSide = par1IconRegister.registerIcon("buildcraft:architect_side");
        this.blockTextureFront = par1IconRegister.registerIcon("buildcraft:architect_front");
    }
}

