/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.BuildCraftBuilders;
import buildcraft.api.events.BlockInteractionEvent;
import buildcraft.builders.TileBlueprintLibrary;
import buildcraft.core.BlockBuildCraft;
import buildcraft.core.CreativeTabBuildCraft;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BlockBlueprintLibrary
extends BlockBuildCraft {
    private IIcon textureTop;
    private IIcon textureSide;

    public BlockBlueprintLibrary() {
        super(Material.wood, CreativeTabBuildCraft.BLOCKS);
    }

    public boolean onBlockActivated(World world, int i, int j, int k, EntityPlayer entityplayer, int par6, float par7, float par8, float par9) {
        super.onBlockActivated(world, i, j, k, entityplayer, par6, par7, par8, par9);
        if (entityplayer.isSneaking()) {
            return false;
        }
        BlockInteractionEvent event = new BlockInteractionEvent(entityplayer, (Block)this);
        FMLCommonHandler.instance().bus().post((Event)event);
        if (event.isCanceled()) {
            return false;
        }
        TileEntity tile = world.getTileEntity(i, j, k);
        if (tile instanceof TileBlueprintLibrary && !world.isRemote) {
            entityplayer.openGui((Object)BuildCraftBuilders.instance, 13, world, i, j, k);
        }
        return true;
    }

    public TileEntity createNewTileEntity(World world, int metadata) {
        return new TileBlueprintLibrary();
    }

    public IIcon getIcon(int i, int j) {
        switch (i) {
            case 0: 
            case 1: {
                return this.textureTop;
            }
        }
        return this.textureSide;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister par1IconRegister) {
        this.textureTop = par1IconRegister.registerIcon("buildcraft:library_topbottom");
        this.textureSide = par1IconRegister.registerIcon("buildcraft:library_side");
    }
}

