/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.api.events.BlockInteractionEvent;
import buildcraft.builders.BlockMarker;
import buildcraft.builders.ItemBlueprint;
import buildcraft.builders.ItemConstructionMarker;
import buildcraft.builders.TileConstructionMarker;
import buildcraft.core.utils.Utils;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class BlockConstructionMarker
extends BlockMarker {
    @Override
    public TileEntity createNewTileEntity(World world, int metadata) {
        return new TileConstructionMarker();
    }

    @Override
    public void breakBlock(World world, int x, int y, int z, Block block, int par6) {
        Utils.preDestroyBlock(world, x, y, z);
        TileConstructionMarker marker = (TileConstructionMarker)world.getTileEntity(x, y, z);
        if (marker != null && marker.itemBlueprint != null && !world.isRemote) {
            float f1 = 0.7f;
            double d = (double)(world.rand.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
            double d1 = (double)(world.rand.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
            double d2 = (double)(world.rand.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
            EntityItem itemToDrop = new EntityItem(world, (double)x + d, (double)y + d1, (double)z + d2, marker.itemBlueprint);
            itemToDrop.delayBeforeCanPickup = 10;
            world.spawnEntityInWorld((Entity)itemToDrop);
        }
        super.breakBlock(world, x, y, z, block, par6);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister par1IconRegister) {
        this.blockIcon = par1IconRegister.registerIcon("buildcraft:constructMarker");
    }

    @Override
    public void onBlockPlacedBy(World world, int i, int j, int k, EntityLivingBase entityliving, ItemStack stack) {
        super.onBlockPlacedBy(world, i, j, k, entityliving, stack);
        TileConstructionMarker tile = (TileConstructionMarker)world.getTileEntity(i, j, k);
        tile.direction = Utils.get2dOrientation(entityliving);
    }

    @Override
    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer entityplayer, int par6, float par7, float par8, float par9) {
        Item equipped;
        super.onBlockActivated(world, x, y, z, entityplayer, par6, par7, par8, par9);
        BlockInteractionEvent event = new BlockInteractionEvent(entityplayer, (Block)this);
        FMLCommonHandler.instance().bus().post((Event)event);
        if (event.isCanceled()) {
            return false;
        }
        TileConstructionMarker marker = (TileConstructionMarker)world.getTileEntity(x, y, z);
        Item item = equipped = entityplayer.getCurrentEquippedItem() != null ? entityplayer.getCurrentEquippedItem().getItem() : null;
        if (equipped instanceof ItemBlueprint) {
            if (marker.itemBlueprint == null) {
                ItemStack stack = entityplayer.inventory.getCurrentItem().copy();
                stack.stackSize = 1;
                marker.setBlueprint(stack);
                stack = null;
                if (entityplayer.inventory.getCurrentItem().stackSize > 1) {
                    stack = entityplayer.getCurrentEquippedItem().copy();
                    stack.stackSize = entityplayer.getCurrentEquippedItem().stackSize - 1;
                }
                entityplayer.inventory.setInventorySlotContents(entityplayer.inventory.currentItem, stack);
                return true;
            }
        } else if (equipped instanceof ItemConstructionMarker && ItemConstructionMarker.linkStarted(entityplayer.getCurrentEquippedItem())) {
            ItemConstructionMarker.link(entityplayer.getCurrentEquippedItem(), world, x, y, z);
        }
        return true;
    }
}

