/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.BuildCraftBuilders;
import buildcraft.api.events.BlockInteractionEvent;
import buildcraft.api.filler.IFillerPattern;
import buildcraft.builders.TileFiller;
import buildcraft.core.BlockBuildCraft;
import buildcraft.core.CreativeTabBuildCraft;
import buildcraft.core.utils.Utils;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockFiller
extends BlockBuildCraft {
    public IFillerPattern currentPattern;
    private IIcon textureSides;
    private IIcon textureTopOn;
    private IIcon textureTopOff;

    public BlockFiller() {
        super(Material.iron);
        this.setHardness(5.0f);
        this.setCreativeTab(CreativeTabBuildCraft.BLOCKS.get());
    }

    public boolean onBlockActivated(World world, int i, int j, int k, EntityPlayer entityplayer, int par6, float par7, float par8, float par9) {
        if (entityplayer.isSneaking()) {
            return false;
        }
        BlockInteractionEvent event = new BlockInteractionEvent(entityplayer, (Block)this);
        FMLCommonHandler.instance().bus().post((Event)event);
        if (event.isCanceled()) {
            return false;
        }
        if (!world.isRemote) {
            entityplayer.openGui((Object)BuildCraftBuilders.instance, 12, world, i, j, k);
        }
        return true;
    }

    public IIcon getIcon(IBlockAccess world, int x, int y, int z, int side) {
        int m = world.getBlockMetadata(x, y, z);
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile != null && tile instanceof TileFiller) {
            TileFiller filler = (TileFiller)tile;
            if (side == 1 || side == 0) {
                if (!filler.hasWork()) {
                    return this.textureTopOff;
                }
                return this.textureTopOn;
            }
            if (filler.currentPattern != null) {
                return filler.currentPattern.getIcon();
            }
            return this.textureSides;
        }
        return this.getIcon(side, m);
    }

    public IIcon getIcon(int i, int j) {
        if (i == 0 || i == 1) {
            return this.textureTopOn;
        }
        return this.textureSides;
    }

    public TileEntity createNewTileEntity(World world, int metadata) {
        return new TileFiller();
    }

    @Override
    public void breakBlock(World world, int x, int y, int z, Block block, int par6) {
        Utils.preDestroyBlock(world, x, y, z);
        super.breakBlock(world, x, y, z, block, par6);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister par1IconRegister) {
        this.textureTopOn = par1IconRegister.registerIcon("buildcraft:blockFillerTopOn");
        this.textureTopOff = par1IconRegister.registerIcon("buildcraft:blockFillerTopOff");
        this.textureSides = par1IconRegister.registerIcon("buildcraft:blockFillerSides");
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return false;
    }

    @Override
    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        return 1;
    }
}

