/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.BuildCraftCore;
import buildcraft.api.events.BlockInteractionEvent;
import buildcraft.api.items.IMapLocation;
import buildcraft.builders.TileMarker;
import buildcraft.core.BlockBuildCraft;
import buildcraft.core.CreativeTabBuildCraft;
import buildcraft.core.utils.Utils;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockMarker
extends BlockBuildCraft {
    public BlockMarker() {
        super(Material.circuits);
        this.setLightLevel(0.5f);
        this.setHardness(0.0f);
        this.setCreativeTab(CreativeTabBuildCraft.ITEMS.get());
    }

    public static boolean canPlaceTorch(World world, int x, int y, int z, ForgeDirection side) {
        Block block = world.getBlock(x, y, z);
        return block != null && (block.renderAsNormalBlock() && block.isOpaqueCube() || block.isSideSolid((IBlockAccess)world, x, y, z, side));
    }

    private AxisAlignedBB getBoundingBox(int meta) {
        double w = 0.15;
        double h = 0.65;
        ForgeDirection dir = ForgeDirection.getOrientation((int)meta);
        switch (dir) {
            case DOWN: {
                return AxisAlignedBB.getBoundingBox((double)(0.5 - w), (double)(1.0 - h), (double)(0.5 - w), (double)(0.5 + w), (double)1.0, (double)(0.5 + w));
            }
            case UP: {
                return AxisAlignedBB.getBoundingBox((double)(0.5 - w), (double)0.0, (double)(0.5 - w), (double)(0.5 + w), (double)h, (double)(0.5 + w));
            }
            case SOUTH: {
                return AxisAlignedBB.getBoundingBox((double)(0.5 - w), (double)(0.5 - w), (double)0.0, (double)(0.5 + w), (double)(0.5 + w), (double)h);
            }
            case NORTH: {
                return AxisAlignedBB.getBoundingBox((double)(0.5 - w), (double)(0.5 - w), (double)(1.0 - h), (double)(0.5 + w), (double)(0.5 + w), (double)1.0);
            }
            case EAST: {
                return AxisAlignedBB.getBoundingBox((double)0.0, (double)(0.5 - w), (double)(0.5 - w), (double)h, (double)(0.5 + w), (double)(0.5 + w));
            }
        }
        return AxisAlignedBB.getBoundingBox((double)(1.0 - h), (double)(0.5 - w), (double)(0.5 - w), (double)1.0, (double)(0.5 + w), (double)(0.5 + w));
    }

    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        AxisAlignedBB bBox = this.getBoundingBox(meta);
        bBox.offset((double)x, (double)y, (double)z);
        return bBox;
    }

    public void setBlockBoundsBasedOnState(IBlockAccess world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        AxisAlignedBB bb = this.getBoundingBox(meta);
        this.setBlockBounds((float)bb.minX, (float)bb.minY, (float)bb.minZ, (float)bb.maxX, (float)bb.maxY, (float)bb.maxZ);
    }

    public int getRenderType() {
        return BuildCraftCore.markerModel;
    }

    public boolean isACube() {
        return false;
    }

    public TileEntity createNewTileEntity(World world, int metadata) {
        return new TileMarker();
    }

    public boolean onBlockActivated(World world, int i, int j, int k, EntityPlayer entityplayer, int par6, float par7, float par8, float par9) {
        if (entityplayer.inventory.getCurrentItem() != null && entityplayer.inventory.getCurrentItem().getItem() instanceof IMapLocation) {
            return false;
        }
        BlockInteractionEvent event = new BlockInteractionEvent(entityplayer, (Block)this);
        FMLCommonHandler.instance().bus().post((Event)event);
        if (event.isCanceled()) {
            return false;
        }
        TileEntity tile = world.getTileEntity(i, j, k);
        if (tile instanceof TileMarker) {
            ((TileMarker)tile).tryConnection();
        }
        return true;
    }

    @Override
    public void breakBlock(World world, int x, int y, int z, Block block, int par6) {
        Utils.preDestroyBlock(world, x, y, z);
        super.breakBlock(world, x, y, z, block, par6);
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return null;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, Block block) {
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof TileMarker) {
            ((TileMarker)tile).updateSignals();
        }
        this.dropTorchIfCantStay(world, x, y, z);
    }

    public boolean canPlaceBlockOnSide(World world, int x, int y, int z, int side) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        return BlockMarker.canPlaceTorch(world, x - dir.offsetX, y - dir.offsetY, z - dir.offsetZ, dir);
    }

    public int onBlockPlaced(World world, int x, int y, int z, int side, float par6, float par7, float par8, int meta) {
        return side;
    }

    public void onBlockAdded(World world, int x, int y, int z) {
        super.onBlockAdded(world, x, y, z);
        this.dropTorchIfCantStay(world, x, y, z);
    }

    private void dropTorchIfCantStay(World world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        if (!this.canPlaceBlockOnSide(world, x, y, z, meta)) {
            this.dropBlockAsItem(world, x, y, z, 0, 0);
            world.setBlockToAir(x, y, z);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iconRegister) {
        this.blockIcon = iconRegister.registerIcon("buildcraft:blockMarker");
    }
}

