/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.api.blueprints.SchematicBlock;
import buildcraft.api.blueprints.SchematicFluid;
import buildcraft.builders.schematics.SchematicBlockCreative;
import buildcraft.builders.schematics.SchematicTileCreative;
import buildcraft.core.blueprints.SchematicRegistry;
import java.util.BitSet;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;

public final class HeuristicBlockDetection {
    private static BitSet craftableBlockList = new BitSet(65536);

    private HeuristicBlockDetection() {
    }

    public static void start() {
        for (Block block : Block.blockRegistry) {
            if (block == null || block == Blocks.air) continue;
            for (int meta = 0; meta < 16; ++meta) {
                if (SchematicRegistry.INSTANCE.isSupported(block, meta)) continue;
                try {
                    if (block.hasTileEntity(meta)) {
                        SchematicRegistry.INSTANCE.registerSchematicBlock(block, meta, SchematicTileCreative.class, new Object[0]);
                        continue;
                    }
                    boolean creativeOnly = false;
                    try {
                        if (creativeOnly) {
                            SchematicRegistry.INSTANCE.registerSchematicBlock(block, meta, SchematicBlockCreative.class, new Object[0]);
                            continue;
                        }
                        if (block instanceof IFluidBlock) {
                            IFluidBlock fblock = (IFluidBlock)block;
                            if (fblock.getFluid() == null) continue;
                            SchematicRegistry.INSTANCE.registerSchematicBlock(block, meta, SchematicFluid.class, new FluidStack(fblock.getFluid(), 1000));
                            continue;
                        }
                        SchematicRegistry.INSTANCE.registerSchematicBlock(block, meta, SchematicBlock.class, new Object[0]);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static boolean canCraft(Block block, int meta) {
        int pos = Block.getIdFromBlock((Block)block) << 4 | meta;
        return craftableBlockList.get(pos);
    }
}

