/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.builders.TileConstructionMarker;
import buildcraft.core.EntityLaser;
import buildcraft.core.render.RenderBoxProvider;
import buildcraft.core.render.RenderBuildingItems;
import buildcraft.core.render.RenderLaser;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.opengl.GL11;

public class RenderConstructionMarker
extends RenderBoxProvider {
    private final RenderBuildingItems renderItems = new RenderBuildingItems();
    private final EntityItem dummyEntityItem = new EntityItem(null);
    private final RenderItem customRenderItem;
    private ModelBase model = new ModelBase(){};
    private ModelRenderer box = new ModelRenderer(this.model, 0, 1);

    public RenderConstructionMarker() {
        this.box.addBox(-8.0f, -8.0f, -8.0f, 16, 4, 16);
        this.box.rotationPointX = 8.0f;
        this.box.rotationPointY = 8.0f;
        this.box.rotationPointZ = 8.0f;
        this.customRenderItem = new RenderItem(){

            public boolean shouldBob() {
                return false;
            }

            public boolean shouldSpreadItems() {
                return false;
            }
        };
        this.customRenderItem.setRenderManager(RenderManager.instance);
    }

    @Override
    public void renderTileEntityAt(TileEntity tileentity, double x, double y, double z, float f) {
        super.renderTileEntityAt(tileentity, x, y, z, f);
        TileConstructionMarker marker = (TileConstructionMarker)tileentity;
        if (marker != null) {
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)8192);
            GL11.glEnable((int)2884);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glTranslated((double)x, (double)y, (double)z);
            GL11.glTranslated((double)(-tileentity.xCoord), (double)(-tileentity.yCoord), (double)(-tileentity.zCoord));
            if (marker.laser != null) {
                GL11.glPushMatrix();
                RenderLaser.doRenderLaser(TileEntityRendererDispatcher.instance.field_147553_e, marker.laser, EntityLaser.LASER_TEXTURES[4]);
                GL11.glPopMatrix();
            }
            if (marker.itemBlueprint != null) {
                this.doRenderItem(marker.itemBlueprint, (float)marker.xCoord + 0.5f, (float)marker.yCoord + 0.2f, (float)marker.zCoord + 0.5f);
            }
            GL11.glPopAttrib();
            GL11.glPopMatrix();
            this.renderItems.render(tileentity, x, y, z);
        }
    }

    public void doRenderItem(ItemStack stack, double x, double y, double z) {
        if (stack == null) {
            return;
        }
        float renderScale = 1.5f;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        GL11.glTranslatef((float)0.0f, (float)0.25f, (float)0.0f);
        GL11.glScalef((float)renderScale, (float)renderScale, (float)renderScale);
        this.dummyEntityItem.setEntityItemStack(stack);
        this.customRenderItem.doRender(this.dummyEntityItem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
        GL11.glPopMatrix();
    }
}

