/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.BlockIndex;
import buildcraft.api.core.IAreaProvider;
import buildcraft.api.core.Position;
import buildcraft.core.Box;
import buildcraft.core.IBoxProvider;
import buildcraft.core.LaserData;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.blueprints.BlueprintReadConfiguration;
import buildcraft.core.blueprints.RecursiveBlueprintReader;
import buildcraft.core.inventory.SimpleInventory;
import buildcraft.core.network.BuildCraftPacket;
import buildcraft.core.network.CommandWriter;
import buildcraft.core.network.ICommandReceiver;
import buildcraft.core.network.PacketCommand;
import buildcraft.core.utils.Utils;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileArchitect
extends TileBuildCraft
implements IInventory,
IBoxProvider,
ICommandReceiver {
    public String currentAuthorName = "";
    public Box box = new Box();
    public String name = "";
    public BlueprintReadConfiguration readConfiguration = new BlueprintReadConfiguration();
    public LinkedList<LaserData> subLasers = new LinkedList();
    public ArrayList<BlockIndex> subBlueprints = new ArrayList();
    private SimpleInventory inv = new SimpleInventory(2, "Architect", 1);
    private RecursiveBlueprintReader reader;

    public TileArchitect() {
        this.box.kind = Box.Kind.BLUE_STRIPES;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.worldObj.isRemote && this.reader != null) {
            this.reader.iterate();
            if (this.reader.isDone()) {
                this.reader = null;
            }
        }
    }

    @Override
    public void initialize() {
        IAreaProvider a;
        super.initialize();
        if (!this.worldObj.isRemote && !this.box.isInitialized() && (a = Utils.getNearbyAreaProvider(this.worldObj, this.xCoord, this.yCoord, this.zCoord)) != null) {
            this.box.initialize(a);
            a.removeFromWorld();
            this.sendNetworkUpdate();
        }
    }

    public int getSizeInventory() {
        return 2;
    }

    public ItemStack getStackInSlot(int i) {
        return this.inv.getStackInSlot(i);
    }

    public ItemStack decrStackSize(int i, int j) {
        ItemStack result = this.inv.decrStackSize(i, j);
        if (i == 0) {
            this.initializeComputing();
        }
        return result;
    }

    public void setInventorySlotContents(int i, ItemStack itemstack) {
        this.inv.setInventorySlotContents(i, itemstack);
        if (i == 0) {
            this.initializeComputing();
        }
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        return this.inv.getStackInSlotOnClosing(slot);
    }

    public String getInventoryName() {
        return "Template";
    }

    public int getInventoryStackLimit() {
        return 1;
    }

    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        return this.worldObj.getTileEntity(this.xCoord, this.yCoord, this.zCoord) == this;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        if (nbt.hasKey("box")) {
            this.box.initialize(nbt.getCompoundTag("box"));
        }
        this.inv.readFromNBT(nbt);
        this.name = nbt.getString("name");
        this.currentAuthorName = nbt.getString("lastAuthor");
        if (nbt.hasKey("readConfiguration")) {
            this.readConfiguration.readFromNBT(nbt.getCompoundTag("readConfiguration"));
        }
        NBTTagList subBptList = nbt.getTagList("subBlueprints", 10);
        for (int i = 0; i < subBptList.tagCount(); ++i) {
            BlockIndex index = new BlockIndex(subBptList.getCompoundTagAt(i));
            this.addSubBlueprint(index);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        if (this.box.isInitialized()) {
            NBTTagCompound boxStore = new NBTTagCompound();
            this.box.writeToNBT(boxStore);
            nbt.setTag("box", (NBTBase)boxStore);
        }
        this.inv.writeToNBT(nbt);
        nbt.setString("name", this.name);
        nbt.setString("lastAuthor", this.currentAuthorName);
        NBTTagCompound readConf = new NBTTagCompound();
        this.readConfiguration.writeToNBT(readConf);
        nbt.setTag("readConfiguration", (NBTBase)readConf);
        NBTTagList subBptList = new NBTTagList();
        for (BlockIndex b : this.subBlueprints) {
            NBTTagCompound subBpt = new NBTTagCompound();
            b.writeTo(subBpt);
            subBptList.appendTag((NBTBase)subBpt);
        }
        nbt.setTag("subBlueprints", (NBTBase)subBptList);
    }

    @Override
    public void writeData(ByteBuf stream) {
        this.box.writeData(stream);
        Utils.writeUTF(stream, this.name);
        this.readConfiguration.writeData(stream);
        stream.writeShort(this.subLasers.size());
        for (LaserData ld : this.subLasers) {
            ld.writeData(stream);
        }
    }

    @Override
    public void readData(ByteBuf stream) {
        this.box.readData(stream);
        this.name = Utils.readUTF(stream);
        this.readConfiguration.readData(stream);
        int size = stream.readUnsignedShort();
        this.subLasers.clear();
        for (int i = 0; i < size; ++i) {
            LaserData ld = new LaserData();
            ld.readData(stream);
            this.subLasers.add(ld);
        }
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.destroy();
    }

    private void initializeComputing() {
        if (this.getWorldObj().isRemote) {
            return;
        }
        this.reader = new RecursiveBlueprintReader(this);
    }

    public int getComputingProgressScaled(int scale) {
        if (this.reader != null) {
            return (int)(this.reader.getComputingProgressScaled() * (float)scale);
        }
        return 0;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean hasCustomInventoryName() {
        return true;
    }

    public boolean isItemValidForSlot(int var1, ItemStack var2) {
        return false;
    }

    @Override
    public Box getBox() {
        return this.box;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        Box completeBox = new Box(this).extendToEncompass(this.box);
        for (LaserData d : this.subLasers) {
            completeBox.extendToEncompass(d.tail);
        }
        return completeBox.getBoundingBox();
    }

    public BuildCraftPacket getPacketSetName() {
        return new PacketCommand(this, "setName", new CommandWriter(){

            @Override
            public void write(ByteBuf data) {
                Utils.writeUTF(data, TileArchitect.this.name);
            }
        });
    }

    @Override
    public void receiveCommand(String command, Side side, Object sender, ByteBuf stream) {
        if ("setName".equals(command)) {
            this.name = Utils.readUTF(stream);
            if (side.isServer()) {
                BuildCraftCore.instance.sendToPlayersNear(this.getPacketSetName(), this);
            }
        } else if (side.isServer() && "setReadConfiguration".equals(command)) {
            this.readConfiguration.readData(stream);
            this.sendNetworkUpdate();
        }
    }

    public void rpcSetConfiguration(BlueprintReadConfiguration conf) {
        this.readConfiguration = conf;
        BuildCraftCore.instance.sendToServer(new PacketCommand(this, "setReadConfiguration", new CommandWriter(){

            @Override
            public void write(ByteBuf data) {
                TileArchitect.this.readConfiguration.writeData(data);
            }
        }));
    }

    public void addSubBlueprint(TileEntity sub) {
        this.addSubBlueprint(new BlockIndex(sub));
        this.sendNetworkUpdate();
    }

    private void addSubBlueprint(BlockIndex index) {
        this.subBlueprints.add(index);
        LaserData laser = new LaserData(new Position(index), new Position(this));
        laser.head.x += 0.5;
        laser.head.y += 0.5;
        laser.head.z += 0.5;
        laser.tail.x += 0.5;
        laser.tail.y += 0.5;
        laser.tail.z += 0.5;
        this.subLasers.add(laser);
    }
}

