/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.blueprints;

import buildcraft.api.core.BCLog;
import buildcraft.builders.blueprints.BlueprintId;
import buildcraft.core.blueprints.BlueprintBase;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;

public class BlueprintDatabase {
    private static final String BPT_EXTENSION = ".bpt";
    private static final String TPL_EXTENSION = ".tpl";
    private static final int PAGE_SIZE = 12;
    private final int bufferSize = 8192;
    private File outputDir;
    private File[] inputDirs;
    private Set<BlueprintId> blueprintIds;
    private BlueprintId[] pages = new BlueprintId[0];

    public void init(String[] inputPaths, String outputPath) {
        this.outputDir = new File(outputPath);
        if (!this.outputDir.exists()) {
            this.outputDir.mkdirs();
        }
        this.inputDirs = new File[inputPaths.length];
        for (int i = 0; i < this.inputDirs.length; ++i) {
            this.inputDirs[i] = new File(inputPaths[i]);
        }
        this.refresh();
    }

    public void refresh() {
        this.blueprintIds = new TreeSet<BlueprintId>();
        this.loadIndex(this.inputDirs);
    }

    public BlueprintId add(BlueprintBase blueprint) {
        BlueprintId id = this.save(blueprint);
        if (!this.blueprintIds.contains(id)) {
            this.blueprintIds.add(id);
            this.pages = this.blueprintIds.toArray(this.pages);
        }
        return id;
    }

    public void deleteBlueprint(BlueprintId id) {
        File blueprintFile = this.getBlueprintFile(id);
        if (blueprintFile != null) {
            blueprintFile.delete();
            this.blueprintIds.remove(id);
            this.pages = new BlueprintId[this.blueprintIds.size()];
            this.pages = this.blueprintIds.toArray(this.pages);
        }
    }

    private BlueprintId save(BlueprintBase blueprint) {
        blueprint.id.generateUniqueId(blueprint.getData());
        BlueprintId id = blueprint.id;
        File blueprintFile = this.getBlueprintFile(id, this.outputDir);
        if (!blueprintFile.exists()) {
            try {
                FileOutputStream f = new FileOutputStream(blueprintFile);
                f.write(blueprint.getData());
                f.close();
            }
            catch (IOException ex) {
                BCLog.logger.error(String.format("Failed to save Blueprint file: %s %s", blueprintFile.getName(), ex.getMessage()));
            }
        }
        return id;
    }

    private File getBlueprintFile(BlueprintId id) {
        String name = "";
        name = id.kind == BlueprintId.Kind.Blueprint ? String.format(Locale.ENGLISH, "%s.bpt", id.toString()) : String.format(Locale.ENGLISH, "%s.tpl", id.toString());
        for (File dir : this.inputDirs) {
            File f = new File(dir, name);
            if (!f.exists()) continue;
            return f;
        }
        return null;
    }

    private File getBlueprintFile(BlueprintId id, File folder) {
        String name = "";
        name = id.kind == BlueprintId.Kind.Blueprint ? String.format(Locale.ENGLISH, "%s.bpt", id.toString()) : String.format(Locale.ENGLISH, "%s.tpl", id.toString());
        return new File(folder, name);
    }

    private void loadIndex(File[] dirs) {
        for (File dir : dirs) {
            if (dir == null) continue;
            this.loadIndex(dir);
        }
    }

    private void loadIndex(File directory) {
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(BlueprintDatabase.BPT_EXTENSION) || name.endsWith(BlueprintDatabase.TPL_EXTENSION);
            }
        };
        if (directory.exists()) {
            File[] files = directory.listFiles(filter);
            if (files == null || files.length == 0) {
                return;
            }
            for (File blueprintFile : files) {
                String fileName = blueprintFile.getName();
                BlueprintId id = new BlueprintId();
                int sepIndex = fileName.lastIndexOf(45);
                int dotIndex = fileName.lastIndexOf(46);
                String extension = fileName.substring(dotIndex);
                if (sepIndex > 0) {
                    String prefix = fileName.substring(0, sepIndex);
                    String suffix = fileName.substring(sepIndex + 1);
                    id.name = prefix;
                    id.uniqueId = BlueprintId.toBytes(suffix.substring(0, suffix.length() - 4));
                } else {
                    id.name = fileName.substring(0, dotIndex);
                    id.uniqueId = new byte[0];
                }
                id.kind = extension.equals(BPT_EXTENSION) ? BlueprintId.Kind.Blueprint : BlueprintId.Kind.Template;
                if (this.blueprintIds.contains(id)) continue;
                this.blueprintIds.add(id);
            }
            this.pages = this.blueprintIds.toArray(new BlueprintId[this.blueprintIds.size()]);
        }
    }

    public boolean exists(BlueprintId id) {
        return this.blueprintIds.contains(id);
    }

    public BlueprintBase load(BlueprintId id) {
        if (id == null) {
            return null;
        }
        BlueprintBase bpt = BlueprintDatabase.load(this.getBlueprintFile(id));
        if (bpt != null) {
            bpt.id = id;
        }
        return bpt;
    }

    public static BlueprintBase load(File blueprintFile) {
        if (blueprintFile != null && blueprintFile.exists()) {
            try {
                FileInputStream f = new FileInputStream(blueprintFile);
                byte[] data = new byte[(int)blueprintFile.length()];
                f.read(data);
                f.close();
                return BlueprintDatabase.load(data);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static BlueprintBase load(byte[] data) {
        try {
            NBTTagCompound nbt = CompressedStreamTools.func_152457_a((byte[])data, (NBTSizeTracker)NBTSizeTracker.field_152451_a);
            BlueprintBase blueprint = BlueprintBase.loadBluePrint(nbt);
            blueprint.setData(data);
            return blueprint;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ArrayList<BlueprintId> getPage(int pageId) {
        ArrayList<BlueprintId> result = new ArrayList<BlueprintId>();
        if (pageId < 0) {
            return result;
        }
        for (int i = pageId * 12; i < pageId * 12 + 12 && i < this.pages.length; ++i) {
            result.add(this.pages[i]);
        }
        return result;
    }

    public int getPageNumber() {
        return (int)Math.ceil((float)this.blueprintIds.size() / 12.0f);
    }
}

