/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.gui;

import buildcraft.builders.TileBlueprintLibrary;
import buildcraft.core.gui.BuildCraftContainer;
import buildcraft.core.gui.slots.SlotBlueprintLibrary;
import buildcraft.core.gui.slots.SlotOutput;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;

public class ContainerBlueprintLibrary
extends BuildCraftContainer {
    protected IInventory playerInventory;
    protected TileBlueprintLibrary library;
    private int progressIn;
    private int progressOut;

    public ContainerBlueprintLibrary(EntityPlayer player, TileBlueprintLibrary library) {
        super(library.getSizeInventory());
        this.playerInventory = player.inventory;
        this.library = library;
        this.addSlotToContainer(new SlotBlueprintLibrary(library, player, 0, 211, 61));
        this.addSlotToContainer(new SlotOutput(library, 1, 167, 61));
        this.addSlotToContainer(new SlotBlueprintLibrary(library, player, 2, 167, 79));
        this.addSlotToContainer(new SlotOutput(library, 3, 211, 79));
        for (int l = 0; l < 3; ++l) {
            for (int k1 = 0; k1 < 9; ++k1) {
                this.addSlotToContainer(new Slot(this.playerInventory, k1 + l * 9 + 9, 66 + k1 * 18, 140 + l * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.addSlotToContainer(new Slot(this.playerInventory, i1, 66 + i1 * 18, 198));
        }
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        for (int i = 0; i < this.crafters.size(); ++i) {
            ICrafting icrafting = (ICrafting)this.crafters.get(i);
            if (this.progressIn != this.library.progressIn) {
                icrafting.sendProgressBarUpdate((Container)this, 0, this.library.progressIn);
            }
            if (this.progressOut == this.library.progressOut) continue;
            icrafting.sendProgressBarUpdate((Container)this, 1, this.library.progressOut);
        }
        this.progressIn = this.library.progressIn;
        this.progressOut = this.library.progressOut;
    }

    public void updateProgressBar(int i, int j) {
        if (i == 0) {
            this.library.progressIn = j;
        } else if (i == 1) {
            this.library.progressOut = j;
        }
    }

    public boolean canInteractWith(EntityPlayer entityplayer) {
        return this.library.isUseableByPlayer(entityplayer);
    }
}

