/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.gui;

import buildcraft.builders.TileBuilder;
import buildcraft.core.gui.BuildCraftContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;

public class ContainerBuilder
extends BuildCraftContainer {
    IInventory playerIInventory;
    TileBuilder builder;

    public ContainerBuilder(IInventory playerInventory, TileBuilder builder) {
        super(builder.getSizeInventory());
        this.playerIInventory = playerInventory;
        this.builder = builder;
        this.addSlotToContainer(new Slot((IInventory)builder, 0, 80, 27));
        for (int k = 0; k < 3; ++k) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.addSlotToContainer(new Slot((IInventory)builder, 1 + j1 + k * 9, 8 + j1 * 18, 72 + k * 18));
            }
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addSlotToContainer(new Slot(playerInventory, x + y * 9 + 9, 8 + x * 18, 140 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.addSlotToContainer(new Slot(playerInventory, x, 8 + x * 18, 198));
        }
        if (!builder.getWorldObj().isRemote && playerInventory instanceof InventoryPlayer) {
            builder.updateRequirements(((InventoryPlayer)playerInventory).player);
            builder.addGuiWatcher(((InventoryPlayer)playerInventory).player);
        }
    }

    public void onContainerClosed(EntityPlayer player) {
        super.onContainerClosed(player);
        this.builder.removeGuiWatcher(player);
    }

    public boolean canInteractWith(EntityPlayer entityplayer) {
        return this.builder.isUseableByPlayer(entityplayer);
    }
}

