/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.gui;

import buildcraft.BuildCraftCore;
import buildcraft.builders.TileArchitect;
import buildcraft.builders.gui.ContainerArchitect;
import buildcraft.core.DefaultProps;
import buildcraft.core.blueprints.BlueprintReadConfiguration;
import buildcraft.core.gui.GuiBuildCraft;
import buildcraft.core.gui.buttons.GuiBetterButton;
import buildcraft.core.gui.tooltips.ToolTip;
import buildcraft.core.gui.tooltips.ToolTipLine;
import buildcraft.core.network.CommandWriter;
import buildcraft.core.network.PacketCommand;
import buildcraft.core.utils.StringUtils;
import buildcraft.core.utils.Utils;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiArchitect
extends GuiBuildCraft {
    private static final int TEXT_X = 90;
    private static final int TEXT_Y = 62;
    private static final int TEXT_WIDTH = 156;
    private static final int TEXT_HEIGHT = 12;
    private static final ResourceLocation TEXTURE = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_GUI + "/architect_gui.png");
    private TileArchitect architect;
    private GuiBetterButton optionRotate;
    private GuiBetterButton optionExcavate;
    private GuiBetterButton optionAllowCreative;
    private GuiTextField textField;

    public GuiArchitect(EntityPlayer player, TileArchitect architect) {
        super(new ContainerArchitect(player, architect), architect, TEXTURE);
        this.architect = architect;
        this.xSize = 256;
        this.ySize = 166;
    }

    public void initGui() {
        super.initGui();
        Keyboard.enableRepeatEvents((boolean)true);
        this.optionRotate = new GuiBetterButton(0, this.guiLeft + 5, this.guiTop + 30, 79, "");
        this.buttonList.add(this.optionRotate);
        this.optionExcavate = new GuiBetterButton(1, this.guiLeft + 5, this.guiTop + 55, 79, "");
        this.buttonList.add(this.optionExcavate);
        this.optionAllowCreative = new GuiBetterButton(2, this.guiLeft + 5, this.guiTop + 80, 79, "");
        this.optionAllowCreative.setToolTip(new ToolTip(500, new ToolTipLine(StringUtils.localize("tile.architect.tooltip.allowCreative.1")), new ToolTipLine(StringUtils.localize("tile.architect.tooltip.allowCreative.2"))));
        this.buttonList.add(this.optionAllowCreative);
        this.textField = new GuiTextField(this.fontRendererObj, 90, 62, 156, 12);
        this.textField.setMaxStringLength(32);
        this.textField.setText(this.architect.name);
        this.textField.setFocused(true);
        this.updateButtons();
    }

    public void onGuiClosed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void actionPerformed(GuiButton button) {
        BlueprintReadConfiguration conf = this.architect.readConfiguration;
        if (button == this.optionRotate) {
            conf.rotate = !conf.rotate;
        } else if (button == this.optionExcavate) {
            conf.excavate = !conf.excavate;
        } else if (button == this.optionAllowCreative) {
            conf.allowCreative = !conf.allowCreative;
        }
        this.architect.rpcSetConfiguration(conf);
        this.updateButtons();
    }

    private void updateButtons() {
        BlueprintReadConfiguration conf = this.architect.readConfiguration;
        this.optionRotate.displayString = conf.rotate ? StringUtils.localize("tile.architect.rotate") : StringUtils.localize("tile.architect.norotate");
        this.optionExcavate.displayString = conf.excavate ? StringUtils.localize("tile.architect.excavate") : StringUtils.localize("tile.architect.noexcavate");
        this.optionAllowCreative.displayString = conf.allowCreative ? StringUtils.localize("tile.architect.allowCreative") : StringUtils.localize("tile.architect.noallowCreative");
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int par1, int par2) {
        String title = StringUtils.localize("tile.architectBlock.name");
        this.fontRendererObj.drawString(title, this.getCenteredOffset(title), 6, 0x404040);
        this.textField.drawTextBox();
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.renderEngine.bindTexture(TEXTURE);
        this.drawTexturedModalRect(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        int i1 = ((ContainerArchitect)this.container).computingTime;
        this.drawTexturedModalRect(this.guiLeft + 159, this.guiTop + 34, 0, 166, i1 + 1, 16);
    }

    @Override
    protected void mouseClicked(int i, int j, int k) {
        super.mouseClicked(i, j, k);
        this.textField.mouseClicked(i - this.guiLeft, j - this.guiTop, k);
    }

    protected void keyTyped(char c, int i) {
        if (this.textField.isFocused()) {
            if (c == '\r' || c == '\u001b') {
                this.textField.setFocused(false);
            } else {
                this.textField.textboxKeyTyped(c, i);
                final String text = this.textField.getText();
                BuildCraftCore.instance.sendToServer(new PacketCommand(this.architect, "setName", new CommandWriter(){

                    @Override
                    public void write(ByteBuf data) {
                        Utils.writeUTF(data, text);
                    }
                }));
            }
        } else {
            super.keyTyped(c, i);
        }
    }
}

