/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.gui;

import buildcraft.BuildCraftBuilders;
import buildcraft.builders.TileBlueprintLibrary;
import buildcraft.builders.blueprints.BlueprintId;
import buildcraft.builders.gui.ContainerBlueprintLibrary;
import buildcraft.core.DefaultProps;
import buildcraft.core.gui.GuiBuildCraft;
import buildcraft.core.utils.StringUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiBlueprintLibrary
extends GuiBuildCraft {
    private static final ResourceLocation TEXTURE = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_GUI + "/library_rw.png");
    private GuiButton nextPageButton;
    private GuiButton prevPageButton;
    private GuiButton deleteButton;
    private TileBlueprintLibrary library;

    public GuiBlueprintLibrary(EntityPlayer player, TileBlueprintLibrary library) {
        super(new ContainerBlueprintLibrary(player, library), library, TEXTURE);
        this.xSize = 234;
        this.ySize = 225;
        this.library = library;
    }

    public void initGui() {
        super.initGui();
        this.prevPageButton = new GuiButton(0, this.guiLeft + 158, this.guiTop + 23, 20, 20, "<");
        this.nextPageButton = new GuiButton(1, this.guiLeft + 180, this.guiTop + 23, 20, 20, ">");
        this.buttonList.add(this.prevPageButton);
        this.buttonList.add(this.nextPageButton);
        this.deleteButton = new GuiButton(2, this.guiLeft + 158, this.guiTop + 114, 25, 20, StringUtils.localize("gui.del"));
        this.buttonList.add(this.deleteButton);
        this.library.refresh();
        this.checkDelete();
        this.checkPages();
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int par1, int par2) {
        String title = StringUtils.localize("tile.libraryBlock.name");
        this.fontRendererObj.drawString(title, this.getCenteredOffset(title), 6, 0x404040);
        int c = 0;
        for (BlueprintId bpt : this.library.currentPage) {
            String name = bpt.name;
            if (name.length() > 32) {
                name = name.substring(0, 32);
            }
            if (c == this.library.selected) {
                int l1 = 8;
                int i2 = 24;
                if (bpt.kind == BlueprintId.Kind.Blueprint) {
                    this.drawGradientRect(l1, i2 + 9 * c, l1 + 146, i2 + 9 * (c + 1), -6242064, -6242064);
                } else {
                    this.drawGradientRect(l1, i2 + 9 * c, l1 + 146, i2 + 9 * (c + 1), -2130706433, -2130706433);
                }
            }
            if (bpt.kind == BlueprintId.Kind.Blueprint) {
                this.fontRendererObj.drawString(name, 9, 25 + 9 * c, 3166336);
            } else {
                this.fontRendererObj.drawString(name, 9, 25 + 9 * c, 0);
            }
            ++c;
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.renderEngine.bindTexture(TEXTURE);
        this.drawTexturedModalRect(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        int inP = (int)((double)this.library.progressIn / 100.0 * 22.0);
        int outP = (int)((double)this.library.progressOut / 100.0 * 22.0);
        this.drawTexturedModalRect(this.guiLeft + 186 + 22 - inP, this.guiTop + 61, 256 - inP, 16, inP, 16);
        this.drawTexturedModalRect(this.guiLeft + 186, this.guiTop + 78, 234, 0, outP, 16);
    }

    protected void actionPerformed(GuiButton button) {
        if (button == this.nextPageButton) {
            this.library.pageNext();
        } else if (button == this.prevPageButton) {
            this.library.pagePrev();
        } else if (this.deleteButton != null && button == this.deleteButton) {
            this.library.deleteSelectedBpt();
        }
    }

    @Override
    protected void mouseClicked(int i, int j, int k) {
        int ySlot;
        super.mouseClicked(i, j, k);
        int x = i - this.guiLeft;
        int y = j - this.guiTop;
        if (x >= 8 && x <= 88 && (ySlot = (y - 24) / 9) >= 0 && ySlot <= 11 && ySlot < this.library.currentPage.size()) {
            this.library.selectBlueprint(ySlot);
        }
        this.checkDelete();
        this.checkPages();
    }

    protected void checkDelete() {
        this.deleteButton.enabled = this.library.selected != -1;
    }

    protected void checkPages() {
        this.prevPageButton.enabled = this.library.pageId != 0;
        this.nextPageButton.enabled = this.library.pageId < BuildCraftBuilders.clientDB.getPageNumber() - 1;
    }
}

