/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.gui;

import buildcraft.BuildCraftCore;
import buildcraft.builders.TileBuilder;
import buildcraft.builders.gui.ContainerBuilder;
import buildcraft.core.DefaultProps;
import buildcraft.core.fluids.Tank;
import buildcraft.core.gui.AdvancedSlot;
import buildcraft.core.gui.GuiAdvancedInterface;
import buildcraft.core.gui.ItemSlot;
import buildcraft.core.network.CommandWriter;
import buildcraft.core.network.PacketCommand;
import buildcraft.core.utils.StringUtils;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiBuilder
extends GuiAdvancedInterface {
    private static final ResourceLocation BLUEPRINT_TEXTURE = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_GUI + "/builder_blueprint.png");
    private static final ResourceLocation FOREGROUND_TEXTURE = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_GUI + "/builder_foreground.png");
    private IInventory playerInventory;
    private TileBuilder builder;
    private GuiButton selectedButton;

    public GuiBuilder(IInventory playerInventory, TileBuilder builder) {
        super(new ContainerBuilder(playerInventory, builder), builder, BLUEPRINT_TEXTURE);
        this.playerInventory = playerInventory;
        this.builder = builder;
        this.xSize = 176;
        this.ySize = 225;
        this.resetNullSlots(24);
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.slots.set(i * 4 + j, new ItemSlot(this, 179 + j * 18, 18 + i * 18));
            }
        }
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int par1, int par2) {
        super.drawGuiContainerForegroundLayer(par1, par2);
        this.drawCenteredString(StringUtils.localize("tile.builderBlock.name"), 89, 16, 0x404040);
        this.fontRendererObj.drawString(StringUtils.localize("gui.building.resources"), 8, 60, 0x404040);
        this.fontRendererObj.drawString(StringUtils.localize("gui.inventory"), 8, this.ySize - 97, 0x404040);
        this.fontRendererObj.drawString(StringUtils.localize("gui.needed"), 178, 7, 0x404040);
        this.fontRendererObj.drawString(StringUtils.localize("gui.building.fluids"), 178, 133, 0x404040);
        this.drawTooltipForSlotAt(par1, par2);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f, int x, int y) {
        int i;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.renderEngine.bindTexture(BLUEPRINT_TEXTURE);
        this.drawTexturedModalRect(this.guiLeft, this.guiTop, 0, 0, 256, this.ySize);
        for (AdvancedSlot s : this.slots) {
            ((ItemSlot)s).stack = null;
        }
        Collection<ItemStack> needs = this.builder.getNeededItems();
        if (needs != null) {
            int s = 0;
            for (ItemStack stack : needs) {
                if (s >= this.slots.size()) break;
                ((ItemSlot)this.slots.get((int)s)).stack = stack.copy();
                ++s;
            }
        }
        this.drawBackgroundSlots();
        for (i = 0; i < this.builder.fluidTanks.length; ++i) {
            Tank tank = this.builder.fluidTanks[i];
            this.drawFluid(tank.getFluid(), this.guiLeft + 179 + 18 * i, this.guiTop + 145, 16, 47, tank.getCapacity());
        }
        this.mc.renderEngine.bindTexture(FOREGROUND_TEXTURE);
        for (i = 0; i < this.builder.fluidTanks.length; ++i) {
            this.drawTexturedModalRect(this.guiLeft + 179 + 18 * i, this.guiTop + 145, 0, 54, 16, 47);
        }
    }

    public void initGui() {
        super.initGui();
        for (int i = 0; i < 4; ++i) {
            this.buttonList.add(new BuilderEraseButton(i, this.guiLeft + 178 + 18 * i, this.guiTop + 197, 18, 18));
        }
    }

    @Override
    protected void mouseMovedOrUp(int mouseX, int mouseY, int eventType) {
        super.mouseMovedOrUp(mouseX, mouseY, eventType);
        if (this.selectedButton != null && eventType == 0) {
            this.selectedButton.mouseReleased(mouseX, mouseY);
            this.selectedButton = null;
        }
    }

    private class BuilderEraseButton
    extends GuiButton {
        private boolean clicked;

        public BuilderEraseButton(int id, int x, int y, int width, int height) {
            super(id, x, y, width, height, null);
        }

        public boolean mousePressed(Minecraft mc, int x, int y) {
            if (super.mousePressed(mc, x, y)) {
                GuiBuilder.this.selectedButton = this;
                this.clicked = true;
                BuildCraftCore.instance.sendToServer(new PacketCommand(GuiBuilder.this.builder, "eraseFluidTank", new CommandWriter(){

                    @Override
                    public void write(ByteBuf data) {
                        data.writeInt(BuilderEraseButton.this.id);
                    }
                }));
                return true;
            }
            return false;
        }

        public void mouseReleased(int x, int y) {
            super.mouseReleased(x, y);
            this.clicked = false;
        }

        public void drawButton(Minecraft mc, int x, int y) {
            this.field_146123_n = x >= this.xPosition && y >= this.yPosition && x < this.xPosition + this.width && y < this.yPosition + this.height;
            mc.renderEngine.bindTexture(FOREGROUND_TEXTURE);
            this.drawTexturedModalRect(this.xPosition, this.yPosition, 0, (this.clicked ? 1 : (this.field_146123_n ? 2 : 0)) * 18, 18, 18);
            this.mouseDragged(mc, x, y);
        }
    }
}

