/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.gui;

import buildcraft.api.filler.FillerManager;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementMouseClick;
import buildcraft.builders.TileFiller;
import buildcraft.builders.gui.ContainerFiller;
import buildcraft.core.DefaultProps;
import buildcraft.core.builders.patterns.FillerPattern;
import buildcraft.core.gui.AdvancedSlot;
import buildcraft.core.gui.GuiAdvancedInterface;
import buildcraft.core.gui.GuiTools;
import buildcraft.core.gui.StatementParameterSlot;
import buildcraft.core.gui.StatementSlot;
import buildcraft.core.gui.buttons.GuiBetterButton;
import buildcraft.core.gui.buttons.StandardButtonTextureSets;
import buildcraft.core.utils.StringUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;

public class GuiFiller
extends GuiAdvancedInterface {
    private static final ResourceLocation TEXTURE = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_GUI + "/filler.png");
    private final IInventory playerInventory;
    private final TileFiller filler;
    private final GuiFiller instance;
    private final StatementSlot fakeStatementSlot;

    public GuiFiller(IInventory playerInventory, TileFiller filler) {
        super(new ContainerFiller(playerInventory, filler), filler, TEXTURE);
        this.playerInventory = playerInventory;
        this.filler = filler;
        this.instance = this;
        this.fakeStatementSlot = new StatementSlot(this.instance, -1, -1, 0){

            @Override
            public IStatement getStatement() {
                return ((GuiFiller)((GuiFiller)GuiFiller.this).instance).filler.currentPattern;
            }
        };
        this.xSize = 175;
        this.ySize = 240;
    }

    public void initGui() {
        super.initGui();
        this.buttonList.clear();
        this.buttonList.add(new GuiBetterButton(0, this.guiLeft + 38 - 18, this.guiTop + 30, 10, StandardButtonTextureSets.LEFT_BUTTON, ""));
        this.buttonList.add(new GuiBetterButton(1, this.guiLeft + 38 + 16 + 8, this.guiTop + 30, 10, StandardButtonTextureSets.RIGHT_BUTTON, ""));
        this.slots.clear();
        for (int i = 0; i < 4; ++i) {
            this.slots.add(new FillerParameterSlot(77 + i * 18, 30, i));
        }
    }

    protected void actionPerformed(GuiButton button) {
        super.actionPerformed(button);
        if (button.id == 0) {
            this.filler.currentPattern = (FillerPattern)FillerManager.registry.getPreviousPattern(this.filler.currentPattern);
        } else if (button.id == 1) {
            this.filler.currentPattern = (FillerPattern)FillerManager.registry.getNextPattern(this.filler.currentPattern);
        }
        this.filler.rpcSetPatternFromString(this.filler.currentPattern.getUniqueTag());
    }

    @Override
    protected void mouseClicked(int x, int y, int k) {
        int i;
        super.mouseClicked(x, y, k);
        AdvancedSlot slot = this.getSlotAtLocation(x, y);
        if (slot != null && (i = ((FillerParameterSlot)slot).slot) < this.filler.patternParameters.length) {
            if (this.filler.patternParameters[i] != null) {
                this.filler.patternParameters[i].onClick(this.filler, this.filler.currentPattern, this.mc.thePlayer.inventory.getItemStack(), new StatementMouseClick(k, GuiFiller.isShiftKeyDown()));
            } else {
                this.filler.patternParameters[i] = this.filler.currentPattern.createParameter(i);
            }
            this.filler.rpcSetParameter(i, this.filler.patternParameters[i]);
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f, int mx, int my) {
        super.drawGuiContainerBackgroundLayer(f, mx, my);
        this.drawBackgroundSlots();
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int mx, int my) {
        String title = StringUtils.localize("tile.fillerBlock.name");
        this.fontRendererObj.drawString(title, this.getCenteredOffset(title), 6, 0x404040);
        this.fontRendererObj.drawString(StringUtils.localize("gui.filling.resources"), 8, 74, 0x404040);
        this.fontRendererObj.drawString(StringUtils.localize("gui.inventory"), 8, 142, 0x404040);
        GuiTools.drawCenteredString(this.fontRendererObj, this.filler.currentPattern.getDescription(), 56);
    }

    class FillerParameterSlot
    extends StatementParameterSlot {
        public FillerParameterSlot(int x, int y, int slot) {
            super(GuiFiller.this.instance, x, y, slot, GuiFiller.this.fakeStatementSlot);
        }

        @Override
        public IStatementParameter getParameter() {
            if (this.slot >= ((GuiFiller)((GuiFiller)GuiFiller.this).instance).filler.patternParameters.length) {
                return null;
            }
            return ((GuiFiller)((GuiFiller)GuiFiller.this).instance).filler.patternParameters[this.slot];
        }

        @Override
        public void setParameter(IStatementParameter param, boolean notifyServer) {
        }
    }
}

