/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.urbanism;

import buildcraft.BuildCraftCore;
import buildcraft.builders.urbanism.AnchoredBox;
import buildcraft.builders.urbanism.EntityUrbanist;
import buildcraft.core.Box;
import buildcraft.core.IBoxesProvider;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.network.BuildCraftPacket;
import buildcraft.core.network.CommandWriter;
import buildcraft.core.network.ICommandReceiver;
import buildcraft.core.network.PacketCommand;
import buildcraft.core.utils.Utils;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;

public class TileUrbanist
extends TileBuildCraft
implements IInventory,
IBoxesProvider,
ICommandReceiver {
    public EntityUrbanist urbanist;
    public ArrayList<AnchoredBox> frames = new ArrayList();
    private EntityLivingBase player;
    private int thirdPersonView = 0;
    private double posX;
    private double posY;
    private double posZ;
    private float yaw;
    private int p2x = 0;
    private int p2y = 0;
    private int p2z = 0;
    private boolean isCreatingFrame = false;

    public void createUrbanistEntity() {
        if (this.worldObj.isRemote && this.urbanist == null) {
            this.urbanist = new EntityUrbanist(this.worldObj);
            this.worldObj.spawnEntityInWorld((Entity)this.urbanist);
            this.player = Minecraft.getMinecraft().renderViewEntity;
            this.urbanist.copyLocationAndAnglesFrom((Entity)this.player);
            this.urbanist.tile = this;
            this.urbanist.player = this.player;
            this.urbanist.rotationYaw = 0.0f;
            this.urbanist.rotationPitch = 0.0f;
            Minecraft.getMinecraft().renderViewEntity = this.urbanist;
            this.thirdPersonView = Minecraft.getMinecraft().gameSettings.thirdPersonView;
            Minecraft.getMinecraft().gameSettings.thirdPersonView = 8;
            this.posX = this.urbanist.posX;
            this.posY = this.urbanist.posY + 10.0;
            this.posZ = this.urbanist.posZ;
            this.yaw = 0.0f;
            this.urbanist.setPositionAndRotation(this.posX, this.posY, this.posZ, this.yaw, 50.0f);
            this.urbanist.setPositionAndUpdate(this.posX, this.posY, this.posZ);
        }
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
    }

    private BuildCraftPacket createXYZPacket(String name, final int x, final int y, final int z) {
        return new PacketCommand(this, name, new CommandWriter(){

            @Override
            public void write(ByteBuf data) {
                data.writeInt(x);
                data.writeShort(y);
                data.writeInt(z);
            }
        });
    }

    @Override
    public void receiveCommand(String command, Side side, Object sender, ByteBuf stream) {
        if (side.isClient() && "setFrameKind".equals(command)) {
            this.setFrameKind(stream.readInt(), stream.readInt());
        } else if (side.isServer() && "startFiller".equals(command)) {
            String fillerTag = Utils.readUTF(stream);
            Box box = new Box();
            box.readData(stream);
            this.startFiller(fillerTag, box);
        } else {
            int x = stream.readInt();
            int y = stream.readInt();
            int z = stream.readInt();
            if (side.isServer() && "setBlock".equals(command)) {
                this.worldObj.setBlock(x, y, z, Blocks.brick_block);
            } else if (!side.isServer() || !"eraseBlock".equals(command)) {
                if ("createFrame".equals(command)) {
                    this.createFrame(x, y, z);
                } else if ("moveFrame".equals(command)) {
                    this.moveFrame(x, y, z);
                }
            }
        }
    }

    public void rpcEraseBlock(int x, int y, int z) {
        BuildCraftCore.instance.sendToServer(this.createXYZPacket("eraseBlock", x, y, z));
    }

    public void createFrame(int x, int y, int z) {
        this.isCreatingFrame = true;
        AnchoredBox a = new AnchoredBox();
        a.box = new Box(x, y, z, x, y + 2, z);
        a.x1 = x;
        a.y1 = y;
        a.z1 = z;
        this.frames.add(a);
    }

    public void rpcCreateFrame(int x, int y, int z) {
        this.p2x = x;
        this.p2y = y;
        this.p2z = z;
        this.createFrame(x, y, z);
        BuildCraftCore.instance.sendToServer(this.createXYZPacket("createFrame", x, y, z));
    }

    public void moveFrame(int x, int y, int z) {
        if (this.isCreatingFrame && this.frames.size() > 0) {
            this.frames.get(this.frames.size() - 1).setP2(x, y, z);
        }
    }

    public void rpcMoveFrame(int x, int y, int z) {
        if (this.p2x != x || this.p2y != y || this.p2z != z) {
            this.p2x = x;
            this.p2y = y;
            this.p2z = z;
            this.moveFrame(x, y, z);
            BuildCraftCore.instance.sendToServer(this.createXYZPacket("moveFrame", x, y, z));
        }
    }

    public void setFrameKind(int id, int kind) {
        AnchoredBox b;
        if (id < this.frames.size() && (b = this.frames.get(id)) != null) {
            b.box.kind = Box.Kind.values()[kind];
        }
    }

    public void startFiller(String fillerTag, Box box) {
    }

    public void rpcStartFiller(final String fillerTag, final Box box) {
        BuildCraftCore.instance.sendToServer(new PacketCommand(this, "startFiller", new CommandWriter(){

            @Override
            public void write(ByteBuf data) {
                Utils.writeUTF(data, fillerTag);
                box.writeData(data);
            }
        }));
    }

    public void destroyUrbanistEntity() {
        Minecraft.getMinecraft().renderViewEntity = this.player;
        Minecraft.getMinecraft().gameSettings.thirdPersonView = this.thirdPersonView;
        this.worldObj.removeEntity((Entity)this.urbanist);
        this.urbanist.setDead();
        this.urbanist = null;
    }

    public int getSizeInventory() {
        return 0;
    }

    public ItemStack getStackInSlot(int var1) {
        return null;
    }

    public ItemStack decrStackSize(int var1, int var2) {
        return null;
    }

    public ItemStack getStackInSlotOnClosing(int var1) {
        return null;
    }

    public void setInventorySlotContents(int var1, ItemStack var2) {
    }

    public String getInventoryName() {
        return null;
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public int getInventoryStackLimit() {
        return 0;
    }

    public boolean isUseableByPlayer(EntityPlayer var1) {
        return true;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int var1, ItemStack var2) {
        return false;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        Box box = new Box(this);
        for (AnchoredBox b : this.frames) {
            box.extendToEncompass(b.box);
        }
        return box.getBoundingBox();
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.setInteger("nbFrames", this.frames.size());
        for (int i = 0; i < this.frames.size(); ++i) {
            NBTTagCompound cpt = new NBTTagCompound();
            this.frames.get(i).writeToNBT(cpt);
            nbt.setTag("frame[" + i + "]", (NBTBase)cpt);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.frames.clear();
        int size = nbt.getInteger("nbFrames");
        for (int i = 0; i < size; ++i) {
            AnchoredBox b = new AnchoredBox();
            b.readFromNBT(nbt.getCompoundTag("frame[" + i + "]"));
            this.frames.add(b);
        }
    }

    @Override
    public void initialize() {
    }

    @Override
    public void writeData(ByteBuf stream) {
        stream.writeShort(this.frames.size());
        for (AnchoredBox b : this.frames) {
            b.writeData(stream);
        }
    }

    @Override
    public void readData(ByteBuf stream) {
        this.frames.clear();
        int size = stream.readUnsignedShort();
        for (int i = 0; i < size; ++i) {
            AnchoredBox b = new AnchoredBox();
            b.readData(stream);
            this.frames.add(b);
        }
    }

    @Override
    public ArrayList<Box> getBoxes() {
        ArrayList<Box> result = new ArrayList<Box>();
        for (AnchoredBox b : this.frames) {
            result.add(b.box);
        }
        return result;
    }

    public class FrameTask {
        int nbOfTasks;
        AnchoredBox frame;

        public void taskDone() {
            --this.nbOfTasks;
            if (this.nbOfTasks <= 0) {
                TileUrbanist.this.frames.remove(this.frame);
            }
        }
    }
}

