/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.urbanism;

import buildcraft.api.filler.IFillerPattern;
import buildcraft.builders.urbanism.GuiUrbanist;
import buildcraft.builders.urbanism.UrbanistToolArea;
import buildcraft.builders.urbanism.UrbanistToolsIconProvider;
import buildcraft.core.Box;
import buildcraft.core.DefaultProps;
import buildcraft.core.builders.patterns.FillerPattern;
import buildcraft.core.gui.AdvancedSlot;
import buildcraft.core.gui.GuiAdvancedInterface;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;

class UrbanistToolFiller
extends UrbanistToolArea {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_GUI + "/urbanist_tool_filler.png");
    private static final int GUI_TEXTURE_WIDTH = 64;
    private static final int GUI_TEXTURE_HEIGHT = 210;
    LinkedList<FillerSlot> fillerSlots = new LinkedList();
    ArrayList<IFillerPattern> patterns = new ArrayList();
    int selection = -1;

    public UrbanistToolFiller() {
        for (FillerPattern pattern : FillerPattern.patterns.values()) {
            this.patterns.add(pattern);
        }
    }

    @Override
    public IIcon getIcon() {
        return UrbanistToolsIconProvider.INSTANCE.getIcon(4);
    }

    @Override
    public String getDescription() {
        return "Build from Filler Pattern";
    }

    @Override
    public void drawGuiContainerBackgroundLayer(GuiUrbanist gui, float f, int x, int y) {
        Minecraft.getMinecraft().renderEngine.bindTexture(GUI_TEXTURE);
        gui.drawTexturedModalRect(0, 0, 0, 0, 64, 210);
    }

    @Override
    public void drawSelection(GuiUrbanist gui, float f, int x, int y) {
        Minecraft.getMinecraft().renderEngine.bindTexture(GUI_TEXTURE);
        for (int i = 0; i < this.fillerSlots.size(); ++i) {
            if (!this.fillerSlots.get((int)i).isSelected) continue;
            gui.drawTexturedModalRect(4, 42 + 18 * i, 64, 0, 18, 18);
        }
    }

    @Override
    public void drawGuiContainerForegroundLayer(GuiUrbanist gui, int par1, int par2) {
        gui.getFontRenderer().drawString("Filler", 4, 4, 0x404040);
    }

    @Override
    public boolean onInterface(int mouseX, int mouseY) {
        return mouseX < 64 && mouseY < 210;
    }

    @Override
    public void createSlots(GuiUrbanist gui, ArrayList<AdvancedSlot> slots) {
        for (int i = 0; i < 8; ++i) {
            FillerSlot slot = new FillerSlot(gui, i);
            this.fillerSlots.add(slot);
            slots.add(slot);
        }
    }

    @Override
    public void show() {
        for (int i = 0; i < 8; ++i) {
            this.fillerSlots.get((int)i).x = 4;
            this.fillerSlots.get((int)i).y = 42 + 18 * i;
        }
    }

    @Override
    public void hide() {
        for (int i = 0; i < 8; ++i) {
            this.fillerSlots.get((int)i).x = -100;
        }
    }

    @Override
    public void areaSet(GuiUrbanist gui, int x1, int y1, int z1, int x2, int y2, int z2) {
        super.areaSet(gui, x1, y1, z1, x2, y2, z2);
        if (this.selection != -1) {
            Box box = new Box();
            box.initialize(x1, y1, z1, x2, y2, z2);
            gui.urbanist.rpcStartFiller(this.fillerSlots.get(this.selection).getPattern().getUniqueTag(), box);
        }
    }

    class FillerSlot
    extends AdvancedSlot {
        public int index;
        public boolean isSelected;

        public FillerSlot(GuiAdvancedInterface gui, int index) {
            super(gui, -100, -100);
            this.isSelected = false;
            this.index = index;
        }

        @Override
        public ResourceLocation getTexture() {
            return TextureMap.locationBlocksTexture;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public IIcon getIcon() {
            if (this.index < UrbanistToolFiller.this.patterns.size()) {
                return this.getPattern().getIcon();
            }
            return null;
        }

        @Override
        public String getDescription() {
            return this.getPattern().getDescription();
        }

        @Override
        public void selected() {
            for (FillerSlot s : UrbanistToolFiller.this.fillerSlots) {
                s.isSelected = false;
            }
            this.isSelected = true;
            UrbanistToolFiller.this.selection = this.index;
        }

        public IFillerPattern getPattern() {
            return UrbanistToolFiller.this.patterns.get(this.index);
        }
    }
}

