/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.commander;

import buildcraft.BuildCraftBuilders;
import buildcraft.api.events.BlockInteractionEvent;
import buildcraft.commander.TileZonePlan;
import buildcraft.core.BlockBuildCraft;
import buildcraft.core.utils.Utils;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockZonePlan
extends BlockBuildCraft {
    private IIcon blockTextureSide;
    private IIcon blockTextureFront;

    public BlockZonePlan() {
        super(Material.iron);
    }

    public TileEntity createNewTileEntity(World world, int meta) {
        return new TileZonePlan();
    }

    public boolean onBlockActivated(World world, int i, int j, int k, EntityPlayer entityplayer, int par6, float par7, float par8, float par9) {
        BlockInteractionEvent event = new BlockInteractionEvent(entityplayer, (Block)this);
        FMLCommonHandler.instance().bus().post((Event)event);
        if (event.isCanceled()) {
            return false;
        }
        if (!world.isRemote) {
            entityplayer.openGui((Object)BuildCraftBuilders.instance, 15, world, i, j, k);
        }
        return true;
    }

    @Override
    public void onBlockPlacedBy(World world, int i, int j, int k, EntityLivingBase entityliving, ItemStack stack) {
        super.onBlockPlacedBy(world, i, j, k, entityliving, stack);
        ForgeDirection orientation = Utils.get2dOrientation(entityliving);
        world.setBlockMetadataWithNotify(i, j, k, orientation.getOpposite().ordinal(), 1);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister par1IconRegister) {
        this.blockTextureSide = par1IconRegister.registerIcon("buildcraft:zonePlan_side");
        this.blockTextureFront = par1IconRegister.registerIcon("buildcraft:zonePlan_front");
    }

    public IIcon getIcon(int i, int j) {
        if (j == 0 && i == 3) {
            return this.blockTextureFront;
        }
        if (i == j) {
            return this.blockTextureFront;
        }
        return this.blockTextureSide;
    }
}

