/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.commander;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.EnumColor;
import buildcraft.commander.ContainerZonePlan;
import buildcraft.commander.TileZonePlan;
import buildcraft.core.BCDynamicTexture;
import buildcraft.core.DefaultProps;
import buildcraft.core.ZonePlan;
import buildcraft.core.gui.AdvancedSlot;
import buildcraft.core.gui.GuiAdvancedInterface;
import buildcraft.core.gui.buttons.GuiBetterButton;
import buildcraft.core.gui.tooltips.ToolTip;
import buildcraft.core.gui.tooltips.ToolTipLine;
import buildcraft.core.network.CommandWriter;
import buildcraft.core.network.PacketCommand;
import buildcraft.core.utils.StringUtils;
import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiZonePlan
extends GuiAdvancedInterface {
    private static final ResourceLocation TMP_TEXTURE = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_GUI + "/map_gui.png");
    private int mapWidth = 200;
    private int mapHeight = 100;
    private TileZonePlan zonePlan;
    private BCDynamicTexture newSelection;
    private int selX1 = 0;
    private int selX2 = 0;
    private int selY1 = 0;
    private int selY2 = 0;
    private boolean inSelection = false;
    private BCDynamicTexture currentSelection;
    private int mapXMin = 0;
    private int mapYMin = 0;
    private int zoomLevel = 1;
    private int cx;
    private int cz;
    private AreaSlot colorSelected = null;
    private float alpha = 0.8f;
    private GuiBetterButton tool;
    private List inventorySlots;
    private List savedButtonList;

    public GuiZonePlan(IInventory inventory, TileZonePlan iZonePlan) {
        super(new ContainerZonePlan(inventory, iZonePlan), inventory, TMP_TEXTURE);
        this.getContainer().gui = this;
        this.xSize = 256;
        this.ySize = 220;
        this.zonePlan = iZonePlan;
        this.getContainer().mapTexture = new BCDynamicTexture(this.mapWidth, this.mapHeight);
        this.getContainer().mapTexture.createDynamicTexture();
        this.currentSelection = new BCDynamicTexture(this.mapWidth, this.mapHeight);
        this.currentSelection.createDynamicTexture();
        this.newSelection = new BCDynamicTexture(1, 1);
        this.newSelection.createDynamicTexture();
        this.getContainer().currentAreaSelection = new ZonePlan();
        this.cx = this.zonePlan.xCoord;
        this.cz = this.zonePlan.zCoord;
        this.resetNullSlots(16);
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.slots.set(i * 4 + j, new AreaSlot(this, 8 + 18 * i, 138 + 18 * j, EnumColor.values()[i * 4 + j]));
            }
        }
        this.colorSelected = (AreaSlot)this.slots.get(0);
        this.newSelection.setColor(0, 0, this.colorSelected.color.getDarkHex(), this.alpha);
        this.uploadMap();
        this.getContainer().loadArea(this.colorSelected.color.ordinal());
        this.inventorySlots = this.container.inventorySlots;
    }

    public void initGui() {
        super.initGui();
        this.tool = new GuiBetterButton(0, this.guiLeft + 5, this.guiTop + 20, 20, "+");
        this.tool.setToolTip(new ToolTip(new ToolTipLine(StringUtils.localize("tip.tool.add"))));
        this.buttonList.add(this.tool);
        this.savedButtonList = this.buttonList;
    }

    private void uploadMap() {
        BuildCraftCore.instance.sendToServer(new PacketCommand(this.getContainer(), "computeMap", new CommandWriter(){

            @Override
            public void write(ByteBuf data) {
                data.writeInt(GuiZonePlan.this.cx);
                data.writeInt(GuiZonePlan.this.cz);
                data.writeShort(GuiZonePlan.this.getContainer().mapTexture.width);
                data.writeShort(GuiZonePlan.this.getContainer().mapTexture.height);
                data.writeByte(GuiZonePlan.this.zoomLevel);
            }
        }));
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f, int x, int y) {
        super.drawGuiContainerBackgroundLayer(f, x, y);
        this.mapXMin = (this.width - this.getContainer().mapTexture.width) / 2;
        this.mapYMin = this.getContainer().mapTexture.height <= 200 ? this.guiTop + 20 : (this.height - this.getContainer().mapTexture.height) / 2;
        this.getContainer().mapTexture.drawMap(this.mapXMin, this.mapYMin, this.zLevel);
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)3042);
        this.currentSelection.drawMap(this.mapXMin, this.mapYMin, this.zLevel);
        GL11.glPopAttrib();
        this.newSelection.updateDynamicTexture();
        if (this.inSelection && this.selX2 != 0) {
            GL11.glPushAttrib((int)8192);
            GL11.glEnable((int)3042);
            int x1 = this.selX1 < this.selX2 ? this.selX1 : this.selX2;
            int x2 = this.selX1 < this.selX2 ? this.selX2 : this.selX1;
            int y1 = this.selY1 < this.selY2 ? this.selY1 : this.selY2;
            int y2 = this.selY1 < this.selY2 ? this.selY2 : this.selY1;
            this.drawTexturedModalRect(x1, y1, 0, 0, x2 - x1 + 1, y2 - y1 + 1);
            GL11.glPopAttrib();
        }
        if (this.getContainer().mapTexture.height <= 200) {
            this.drawBackgroundSlots();
            this.bindTexture(this.texture);
            this.drawTexturedModalRect(this.guiLeft + this.colorSelected.x, this.guiTop + this.colorSelected.y, 0, 220, 16, 16);
            this.drawTexturedModalRect(this.guiLeft + 236, this.guiTop + 38, 16, 220, 8, (int)((float)this.zonePlan.progress / 120.0f * 27.0f));
        }
    }

    @Override
    protected void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        boolean clickOnMap;
        super.mouseClicked(mouseX, mouseY, mouseButton);
        int blocksX = (mouseX - this.mapXMin) * this.zoomLevel;
        int blocksZ = (mouseY - this.mapYMin) * this.zoomLevel;
        int blockStartX = this.cx - this.mapWidth * this.zoomLevel / 2;
        int blockStartZ = this.cz - this.mapHeight * this.zoomLevel / 2;
        boolean bl = clickOnMap = mouseX >= this.mapXMin && mouseX <= this.mapXMin + this.getContainer().mapTexture.width && mouseY >= this.mapYMin && mouseY <= this.mapYMin + this.getContainer().mapTexture.height;
        if (clickOnMap) {
            if (mouseButton == 1) {
                this.cx = blockStartX + blocksX;
                this.cz = blockStartZ + blocksZ;
                this.uploadMap();
                this.refreshSelectedArea();
            } else {
                this.inSelection = true;
                this.selX1 = mouseX;
                this.selY1 = mouseY;
                this.selX2 = 0;
                this.selY2 = 0;
            }
        } else {
            AdvancedSlot slot = this.getSlotAtLocation(mouseX, mouseY);
            if (slot instanceof AreaSlot) {
                this.colorSelected = (AreaSlot)slot;
                this.newSelection.setColor(0, 0, this.colorSelected.color.getDarkHex(), this.alpha);
                this.getContainer().loadArea(this.colorSelected.color.ordinal());
            }
        }
    }

    @Override
    protected void mouseClickMove(int mouseX, int mouseY, int lastButtonBlicked, long time) {
        super.mouseClickMove(mouseX, mouseY, lastButtonBlicked, time);
        if (this.inSelection && mouseX >= this.mapXMin && mouseX <= this.mapXMin + this.getContainer().mapTexture.width && mouseY >= this.mapYMin && mouseY <= this.mapYMin + this.getContainer().mapTexture.height) {
            this.selX2 = mouseX;
            this.selY2 = mouseY;
        }
    }

    @Override
    protected void mouseMovedOrUp(int mouseX, int mouseY, int eventType) {
        super.mouseMovedOrUp(mouseX, mouseY, eventType);
        if (eventType != -1 && this.inSelection) {
            boolean val = this.tool.displayString.equals("+");
            int blockStartX = this.cx - this.mapWidth * this.zoomLevel / 2;
            int blockStartZ = this.cz - this.mapHeight * this.zoomLevel / 2;
            int x1 = this.selX1 < this.selX2 ? this.selX1 : this.selX2;
            int x2 = this.selX1 < this.selX2 ? this.selX2 : this.selX1;
            int y1 = this.selY1 < this.selY2 ? this.selY1 : this.selY2;
            int y2 = this.selY1 < this.selY2 ? this.selY2 : this.selY1;
            int lengthX = (x2 - x1) * this.zoomLevel;
            int lengthY = (y2 - y1) * this.zoomLevel;
            for (int i = 0; i <= lengthX; ++i) {
                for (int j = 0; j <= lengthY; ++j) {
                    int x = blockStartX + (x1 - this.mapXMin) * this.zoomLevel + i;
                    int z = blockStartZ + (y1 - this.mapYMin) * this.zoomLevel + j;
                    this.getContainer().currentAreaSelection.set(x, z, val);
                }
            }
            this.inSelection = false;
            this.getContainer().saveArea(this.colorSelected.color.ordinal());
            this.refreshSelectedArea();
        }
    }

    protected void keyTyped(char carac, int val) {
        super.keyTyped(carac, val);
        if (val == 63) {
            this.uploadMap();
            this.refreshSelectedArea();
        } else if (carac == '+' && this.zoomLevel > 1) {
            --this.zoomLevel;
            this.uploadMap();
            this.refreshSelectedArea();
        } else if (carac == '-' && this.zoomLevel < 6) {
            ++this.zoomLevel;
            this.uploadMap();
            this.refreshSelectedArea();
        } else if (carac == 'm') {
            this.mapWidth = 200;
            this.mapHeight = 100;
            this.getContainer().mapTexture = new BCDynamicTexture(this.mapWidth, this.mapHeight);
            this.getContainer().mapTexture.createDynamicTexture();
            this.currentSelection = new BCDynamicTexture(this.mapWidth, this.mapHeight);
            this.currentSelection.createDynamicTexture();
            this.uploadMap();
            this.refreshSelectedArea();
            this.container.inventorySlots = this.inventorySlots;
            this.buttonList = this.savedButtonList;
        } else if (carac == 'M') {
            this.mapWidth = this.mc.displayWidth;
            this.mapHeight = this.mc.displayHeight;
            this.getContainer().mapTexture = new BCDynamicTexture(this.mapWidth, this.mapHeight);
            this.getContainer().mapTexture.createDynamicTexture();
            this.currentSelection = new BCDynamicTexture(this.mapWidth, this.mapHeight);
            this.currentSelection.createDynamicTexture();
            this.uploadMap();
            this.refreshSelectedArea();
            this.container.inventorySlots = new LinkedList();
            this.buttonList = new LinkedList();
        }
    }

    public void refreshSelectedArea() {
        int color = this.colorSelected.color.getDarkHex();
        int rAdd = color >> 16 & 0xFF;
        int gAdd = color >> 8 & 0xFF;
        int bAdd = color & 0xFF;
        for (int i = 0; i < this.currentSelection.width; ++i) {
            for (int j = 0; j < this.currentSelection.height; ++j) {
                int blockStartX = this.cx - this.mapWidth * this.zoomLevel / 2;
                int blockStartZ = this.cz - this.mapHeight * this.zoomLevel / 2;
                double r = 0.0;
                double g = 0.0;
                double b = 0.0;
                for (int stepi = 0; stepi < this.zoomLevel; ++stepi) {
                    for (int stepj = 0; stepj < this.zoomLevel; ++stepj) {
                        int x = blockStartX + i * this.zoomLevel + stepi;
                        int z = blockStartZ + j * this.zoomLevel + stepj;
                        if (!this.getContainer().currentAreaSelection.get(x, z)) continue;
                        r += (double)rAdd;
                        g += (double)gAdd;
                        b += (double)bAdd;
                    }
                }
                r /= (double)(this.zoomLevel * this.zoomLevel);
                g /= (double)(this.zoomLevel * this.zoomLevel);
                b /= (double)(this.zoomLevel * this.zoomLevel);
                g /= 255.0;
                b /= 255.0;
                if ((r /= 255.0) != 0.0) {
                    this.currentSelection.setColor(i, j, r, g, b, this.alpha);
                    continue;
                }
                this.currentSelection.setColor(i, j, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public ContainerZonePlan getContainer() {
        return (ContainerZonePlan)super.getContainer();
    }

    protected void actionPerformed(GuiButton button) {
        if (button == this.tool) {
            if (this.tool.displayString.equals("+")) {
                this.tool.displayString = "-";
                this.tool.getToolTip().remove(0);
                this.tool.getToolTip().add(new ToolTipLine(StringUtils.localize("tip.tool.remove")));
            } else {
                this.tool.displayString = "+";
                this.tool.getToolTip().remove(0);
                this.tool.getToolTip().add(new ToolTipLine(StringUtils.localize("tip.tool.add")));
            }
        }
    }

    public void handleMouseInput() {
        int wheel;
        super.handleMouseInput();
        int mouseX = Mouse.getEventX() * this.width / this.mc.displayWidth;
        int mouseY = this.height - Mouse.getEventY() * this.height / this.mc.displayHeight - 1;
        if (mouseX >= this.mapXMin && mouseX <= this.mapXMin + this.getContainer().mapTexture.width && mouseY >= this.mapYMin && mouseY <= this.mapYMin + this.getContainer().mapTexture.height && (wheel = Mouse.getEventDWheel()) != 0) {
            if (this.zoomLevel < 6 && wheel > 0) {
                ++this.zoomLevel;
                this.uploadMap();
                this.refreshSelectedArea();
            } else if (this.zoomLevel > 1 && wheel < 0) {
                --this.zoomLevel;
                this.uploadMap();
                this.refreshSelectedArea();
            }
        }
    }

    private static class AreaSlot
    extends AdvancedSlot {
        public EnumColor color;

        public AreaSlot(GuiAdvancedInterface gui, int x, int y, EnumColor iColor) {
            super(gui, x, y);
            this.color = iColor;
        }

        @Override
        public IIcon getIcon() {
            return this.color.getIcon();
        }

        @Override
        public String getDescription() {
            return this.color.getLocalizedName();
        }
    }
}

