/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.commander;

import buildcraft.api.core.SafeTimeTracker;
import buildcraft.core.ItemMapLocation;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.ZonePlan;
import buildcraft.core.inventory.SimpleInventory;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.material.MapColor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.chunk.Chunk;

public class TileZonePlan
extends TileBuildCraft
implements IInventory {
    public static final int RESOLUTION = 2048;
    public static final int CRAFT_TIME = 120;
    private static int RESOLUTION_CHUNKS = 128;
    public int chunkStartX;
    public int chunkStartZ;
    public byte[] colors = new byte[0x400000];
    public short progress = 0;
    private boolean scan = false;
    private int chunkIt = 0;
    private ZonePlan[] selectedAreas = new ZonePlan[16];
    private int currentSelectedArea = 0;
    private SimpleInventory inv = new SimpleInventory(2, "inv", 64);
    private SafeTimeTracker zonePlannerScanning = new SafeTimeTracker(5L);

    @Override
    public void initialize() {
        super.initialize();
        this.chunkStartX = (this.xCoord >> 4) - RESOLUTION_CHUNKS / 2;
        this.chunkStartZ = (this.zCoord >> 4) - RESOLUTION_CHUNKS / 2;
        if (!this.scan) {
            this.chunkIt = 0;
            this.scan = true;
        }
    }

    private int[] getCoords() {
        int chunkCenterX = this.xCoord >> 4;
        int chunkCenterZ = this.zCoord >> 4;
        if (this.chunkIt == 0) {
            return new int[]{chunkCenterX, chunkCenterZ};
        }
        int left = this.chunkIt;
        for (int radius = 1; radius < RESOLUTION_CHUNKS / 2; ++radius) {
            int lineLength = radius * 2;
            int perimeter = lineLength * 4;
            if (left <= perimeter) {
                int chunkX = 0;
                int chunkZ = 0;
                int remained = (left - 1) % lineLength;
                if ((left - 1) / lineLength == 0) {
                    chunkX = chunkCenterX + radius;
                    chunkZ = chunkCenterZ - lineLength / 2 + remained;
                } else if ((left - 1) / lineLength == 1) {
                    chunkX = chunkCenterX - radius;
                    chunkZ = chunkCenterZ - lineLength / 2 + remained + 1;
                } else if ((left - 1) / lineLength == 2) {
                    chunkX = chunkCenterX - lineLength / 2 + remained + 1;
                    chunkZ = chunkCenterZ + radius;
                } else {
                    chunkX = chunkCenterX - lineLength / 2 + remained;
                    chunkZ = chunkCenterZ - radius;
                }
                return new int[]{chunkX, chunkZ};
            }
            left -= perimeter;
        }
        return new int[]{chunkCenterX, chunkCenterZ};
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (this.worldObj.isRemote) {
            return;
        }
        if (this.scan && this.zonePlannerScanning.markTimeIfDelay(this.worldObj)) {
            int[] coords = this.getCoords();
            Chunk chunk = this.worldObj.getChunkFromChunkCoords(coords[0], coords[1]);
            this.loadChunk(chunk);
            if (this.chunkIt > RESOLUTION_CHUNKS * RESOLUTION_CHUNKS) {
                this.scan = false;
                this.chunkIt = 0;
            } else {
                ++this.chunkIt;
            }
        }
        if (this.inv.getStackInSlot(0) != null && this.inv.getStackInSlot(1) == null && this.inv.getStackInSlot(0).getItem() instanceof ItemMapLocation) {
            if (this.progress < 120) {
                this.progress = (short)(this.progress + 1);
                if (this.worldObj.getTotalWorldTime() % 5L == 0L) {
                    this.sendNetworkUpdate();
                }
            } else {
                ItemStack stack = this.inv.decrStackSize(0, 1);
                if (this.selectedAreas[this.currentSelectedArea] != null) {
                    ItemMapLocation.setZone(stack, this.selectedAreas[this.currentSelectedArea]);
                }
                this.inv.setInventorySlotContents(1, stack);
            }
        } else if (this.progress != 0) {
            this.progress = 0;
            this.sendNetworkUpdate();
        }
    }

    private void loadChunk(Chunk chunk) {
        for (int cx = 0; cx < 16; ++cx) {
            for (int cz = 0; cz < 16; ++cz) {
                int color;
                int x = (chunk.xPosition << 4) + cx;
                int z = (chunk.zPosition << 4) + cz;
                int y = this.getWorldObj().getHeightValue(x, z);
                while ((color = chunk.getBlock((int)cx, (int)y, (int)cz).getMapColor((int)0).colorIndex) == MapColor.airColor.colorIndex && --y >= 0) {
                }
                int ix = x - this.chunkStartX * 16;
                int iz = z - this.chunkStartZ * 16;
                this.colors[ix + iz * 2048] = (byte)color;
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.setBoolean("scan", this.scan);
        nbt.setInteger("chunkIt", this.chunkIt);
        nbt.setByteArray("colors", this.colors);
        NBTTagCompound invNBT = new NBTTagCompound();
        this.inv.writeToNBT(invNBT);
        nbt.setTag("inv", (NBTBase)invNBT);
        for (int i = 0; i < this.selectedAreas.length; ++i) {
            if (this.selectedAreas[i] == null) continue;
            NBTTagCompound subNBT = new NBTTagCompound();
            this.selectedAreas[i].writeToNBT(subNBT);
            nbt.setTag("selectedArea[" + i + "]", (NBTBase)subNBT);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.scan = nbt.getBoolean("scan");
        this.chunkIt = nbt.getInteger("chunkIt");
        this.colors = nbt.getByteArray("colors");
        if (this.colors.length != 0x400000 || this.chunkIt >= RESOLUTION_CHUNKS * RESOLUTION_CHUNKS) {
            this.colors = new byte[0x400000];
            this.scan = true;
            this.chunkIt = 0;
        }
        this.inv.readFromNBT(nbt.getCompoundTag("inv"));
        for (int i = 0; i < this.selectedAreas.length; ++i) {
            if (!nbt.hasKey("selectedArea[" + i + "]")) continue;
            this.selectedAreas[i] = new ZonePlan();
            this.selectedAreas[i].readFromNBT(nbt.getCompoundTag("selectedArea[" + i + "]"));
        }
    }

    @Override
    public void writeData(ByteBuf stream) {
        stream.writeShort((int)this.progress);
    }

    @Override
    public void readData(ByteBuf stream) {
        this.progress = stream.readShort();
    }

    public ZonePlan selectArea(int index) {
        if (this.selectedAreas[index] == null) {
            this.selectedAreas[index] = new ZonePlan();
        }
        this.currentSelectedArea = index;
        return this.selectedAreas[index];
    }

    public void setArea(int index, ZonePlan area) {
        this.selectedAreas[index] = area;
    }

    public int getSizeInventory() {
        return this.inv.getSizeInventory();
    }

    public ItemStack getStackInSlot(int slotId) {
        return this.inv.getStackInSlot(slotId);
    }

    public ItemStack decrStackSize(int slotId, int count) {
        return this.inv.decrStackSize(slotId, count);
    }

    public ItemStack getStackInSlotOnClosing(int slotId) {
        return this.inv.getStackInSlotOnClosing(slotId);
    }

    public void setInventorySlotContents(int slotId, ItemStack itemstack) {
        this.inv.setInventorySlotContents(slotId, itemstack);
    }

    public String getInventoryName() {
        return this.inv.getInventoryName();
    }

    public boolean hasCustomInventoryName() {
        return this.inv.hasCustomInventoryName();
    }

    public int getInventoryStackLimit() {
        return this.inv.getInventoryStackLimit();
    }

    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        return this.inv.isUseableByPlayer(entityplayer);
    }

    public void openInventory() {
        this.inv.openInventory();
    }

    public void closeInventory() {
        this.inv.closeInventory();
    }

    public boolean isItemValidForSlot(int i, ItemStack itemstack) {
        return this.inv.isItemValidForSlot(i, itemstack);
    }
}

