/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.api.events.BlockPlacedDownEvent;
import buildcraft.api.tiles.IHasWork;
import buildcraft.core.CreativeTabBuildCraft;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.utils.Utils;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockBuildCraft
extends BlockContainer {
    protected static boolean keepInventory = false;
    protected final Random rand = new Random();

    protected BlockBuildCraft(Material material) {
        this(material, CreativeTabBuildCraft.BLOCKS);
    }

    protected BlockBuildCraft(Material material, CreativeTabBuildCraft creativeTab) {
        super(material);
        this.setCreativeTab(creativeTab.get());
        this.setHardness(5.0f);
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        super.onBlockPlacedBy(world, x, y, z, entity, stack);
        FMLCommonHandler.instance().bus().post((Event)new BlockPlacedDownEvent((EntityPlayer)entity, world.getBlock(x, y, z), world.getBlockMetadata(x, y, z), x, y, z));
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof TileBuildCraft) {
            ((TileBuildCraft)tile).onBlockPlacedBy(entity, stack);
        }
    }

    public void breakBlock(World world, int x, int y, int z, Block block, int par6) {
        Utils.preDestroyBlock(world, x, y, z);
        super.breakBlock(world, x, y, z, block, par6);
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof IHasWork && ((IHasWork)tile).hasWork()) {
            return super.getLightValue(world, x, y, z) + 8;
        }
        return super.getLightValue(world, x, y, z);
    }
}

