/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.api.core.BlockIndex;
import java.util.Iterator;
import java.util.Random;

public class BlockScannerRandom
implements Iterable<BlockIndex> {
    private Random rand;
    private int maxDistance;

    public BlockScannerRandom(Random iRand, int iMaxDistance) {
        this.rand = iRand;
        this.maxDistance = iMaxDistance;
    }

    @Override
    public Iterator<BlockIndex> iterator() {
        return new BlockIt();
    }

    class BlockIt
    implements Iterator<BlockIndex> {
        BlockIt() {
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public BlockIndex next() {
            double radius = BlockScannerRandom.this.rand.nextFloat() * (float)BlockScannerRandom.this.maxDistance;
            double polarAngle = (double)BlockScannerRandom.this.rand.nextFloat() * 2.0 * Math.PI;
            double azimuthAngle = (double)BlockScannerRandom.this.rand.nextFloat() * Math.PI;
            int searchX = (int)(radius * Math.cos(polarAngle) * Math.sin(azimuthAngle));
            int searchY = (int)(radius * Math.cos(azimuthAngle));
            int searchZ = (int)(radius * Math.sin(polarAngle) * Math.sin(azimuthAngle));
            return new BlockIndex(searchX, searchY, searchZ);
        }

        @Override
        public void remove() {
        }
    }
}

