/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.core.CreativeTabBuildCraft;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class BlockSpring
extends Block {
    public static final Random rand = new Random();

    public BlockSpring() {
        super(Material.rock);
        this.setBlockUnbreakable();
        this.setResistance(6000000.0f);
        this.setStepSound(soundTypeStone);
        this.disableStats();
        this.setTickRandomly(true);
        this.setCreativeTab(CreativeTabBuildCraft.BLOCKS.get());
    }

    public void getSubBlocks(Item item, CreativeTabs tab, List list) {
        for (EnumSpring type : EnumSpring.VALUES) {
            list.add(new ItemStack((Block)this, 1, type.ordinal()));
        }
    }

    public int damageDropped(int meta) {
        return meta;
    }

    public void updateTick(World world, int x, int y, int z, Random random) {
        this.assertSpring(world, x, y, z);
    }

    public void onBlockAdded(World world, int x, int y, int z) {
        super.onBlockAdded(world, x, y, z);
        int meta = world.getBlockMetadata(x, y, z);
        world.scheduleBlockUpdate(x, y, z, (Block)this, EnumSpring.fromMeta((int)meta).tickRate);
    }

    private void assertSpring(World world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        EnumSpring spring = EnumSpring.fromMeta(meta);
        world.scheduleBlockUpdate(x, y, z, (Block)this, spring.tickRate);
        if (!spring.canGen || spring.liquidBlock == null) {
            return;
        }
        if (!world.isAirBlock(x, y + 1, z)) {
            return;
        }
        if (spring.chance != -1 && rand.nextInt(spring.chance) != 0) {
            return;
        }
        world.setBlock(x, y + 1, z, spring.liquidBlock);
    }

    public boolean func_149698_L() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister par1IconRegister) {
        this.blockIcon = par1IconRegister.registerIcon("bedrock");
    }

    public static enum EnumSpring {
        WATER(5, -1, Blocks.water),
        OIL(6000, 8, null);

        public static final EnumSpring[] VALUES;
        public final int tickRate;
        public final int chance;
        public Block liquidBlock;
        public boolean canGen = true;

        private EnumSpring(int tickRate, int chance, Block liquidBlock) {
            this.tickRate = tickRate;
            this.chance = chance;
            this.liquidBlock = liquidBlock;
        }

        public static EnumSpring fromMeta(int meta) {
            if (meta < 0 || meta >= VALUES.length) {
                return WATER;
            }
            return VALUES[meta];
        }

        static {
            VALUES = EnumSpring.values();
        }
    }
}

