/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.core.Version;
import buildcraft.core.proxy.CoreProxy;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;

public class CommandBuildCraft
extends CommandBase {
    public int compareTo(Object arg0) {
        return this.getCommandName().compareTo(((ICommand)arg0).getCommandName());
    }

    public String getCommandName() {
        return "buildcraft";
    }

    public String getCommandUsage(ICommandSender sender) {
        return "/" + this.getCommandName() + " help";
    }

    public boolean canCommandSenderUseCommand(ICommandSender par1ICommandSender) {
        return true;
    }

    public List getCommandAliases() {
        return null;
    }

    public void processCommand(ICommandSender sender, String[] arguments) {
        if (arguments.length <= 0) {
            throw new WrongUsageException("Type '" + this.getCommandUsage(sender) + "' for help.", new Object[0]);
        }
        if (arguments[0].matches("version")) {
            this.commandVersion(sender, arguments);
            return;
        }
        if (arguments[0].matches("help")) {
            sender.addChatMessage((IChatComponent)new ChatComponentText("Format: '" + this.getCommandName() + " <command> <arguments>'"));
            sender.addChatMessage((IChatComponent)new ChatComponentText(StatCollector.translateToLocal((String)"command.buildcraft.available")));
            sender.addChatMessage((IChatComponent)new ChatComponentText(" - version :" + StatCollector.translateToLocal((String)"command.buildcraft.versioninfo")));
            return;
        }
        throw new WrongUsageException(this.getCommandUsage(sender), new Object[0]);
    }

    private void commandVersion(ICommandSender sender, String[] arguments) {
        String colour = Version.isOutdated() ? "\u00a7c" : "\u00a7a";
        sender.addChatMessage((IChatComponent)new ChatComponentText(String.format(colour + StatCollector.translateToLocal((String)"command.buildcraft.version"), Version.getVersion(), CoreProxy.proxy.getMinecraftVersion(), Version.getRecommendedVersion())));
    }
}

