/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.api.core.Position;
import buildcraft.core.DefaultProps;
import buildcraft.core.LaserData;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public abstract class EntityLaser
extends Entity {
    public static final ResourceLocation[] LASER_TEXTURES = new ResourceLocation[]{new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_ENTITIES + "/laser_1.png"), new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_ENTITIES + "/laser_2.png"), new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_ENTITIES + "/laser_3.png"), new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_ENTITIES + "/laser_4.png"), new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_ENTITIES + "/stripes.png"), new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_ENTITIES + "/blue_stripes.png")};
    public LaserData data = new LaserData();
    protected boolean needsUpdate = true;

    public EntityLaser(World world) {
        super(world);
        this.data.head = new Position(0.0, 0.0, 0.0);
        this.data.tail = new Position(0.0, 0.0, 0.0);
    }

    public EntityLaser(World world, Position head, Position tail) {
        super(world);
        this.data.head = head;
        this.data.tail = tail;
        this.setPositionAndRotation(head.x, head.y, head.z, 0.0f, 0.0f);
        this.setSize(10.0f, 10.0f);
    }

    protected void entityInit() {
        this.preventEntitySpawning = false;
        this.noClip = true;
        this.isImmuneToFire = true;
        this.dataWatcher.addObject(8, (Object)0);
        this.dataWatcher.addObject(9, (Object)0);
        this.dataWatcher.addObject(10, (Object)0);
        this.dataWatcher.addObject(11, (Object)0);
        this.dataWatcher.addObject(12, (Object)0);
        this.dataWatcher.addObject(13, (Object)0);
        this.dataWatcher.addObject(14, (Object)0);
    }

    public void onUpdate() {
        if (this.data.head == null || this.data.tail == null) {
            return;
        }
        if (!this.worldObj.isRemote && this.needsUpdate) {
            this.updateDataServer();
            this.needsUpdate = false;
        }
        this.boundingBox.minX = Math.min(this.data.head.x, this.data.tail.x);
        this.boundingBox.minY = Math.min(this.data.head.y, this.data.tail.y);
        this.boundingBox.minZ = Math.min(this.data.head.z, this.data.tail.z);
        this.boundingBox.maxX = Math.max(this.data.head.x, this.data.tail.x);
        this.boundingBox.maxY = Math.max(this.data.head.y, this.data.tail.y);
        this.boundingBox.maxZ = Math.max(this.data.head.z, this.data.tail.z);
        this.boundingBox.minX -= 1.0;
        this.boundingBox.minY -= 1.0;
        this.boundingBox.minZ -= 1.0;
        this.boundingBox.maxX += 1.0;
        this.boundingBox.maxY += 1.0;
        this.boundingBox.maxZ += 1.0;
        this.data.update();
    }

    protected void updateDataClient() {
        this.data.head.x = this.decodeDouble(this.dataWatcher.getWatchableObjectInt(8));
        this.data.head.y = this.decodeDouble(this.dataWatcher.getWatchableObjectInt(9));
        this.data.head.z = this.decodeDouble(this.dataWatcher.getWatchableObjectInt(10));
        this.data.tail.x = this.decodeDouble(this.dataWatcher.getWatchableObjectInt(11));
        this.data.tail.y = this.decodeDouble(this.dataWatcher.getWatchableObjectInt(12));
        this.data.tail.z = this.decodeDouble(this.dataWatcher.getWatchableObjectInt(13));
        this.data.isVisible = this.dataWatcher.getWatchableObjectByte(14) == 1;
    }

    protected void updateDataServer() {
        this.dataWatcher.updateObject(8, (Object)this.encodeDouble(this.data.head.x));
        this.dataWatcher.updateObject(9, (Object)this.encodeDouble(this.data.head.y));
        this.dataWatcher.updateObject(10, (Object)this.encodeDouble(this.data.head.z));
        this.dataWatcher.updateObject(11, (Object)this.encodeDouble(this.data.tail.x));
        this.dataWatcher.updateObject(12, (Object)this.encodeDouble(this.data.tail.y));
        this.dataWatcher.updateObject(13, (Object)this.encodeDouble(this.data.tail.z));
        this.dataWatcher.updateObject(14, (Object)((byte)(this.data.isVisible ? 1 : 0)));
    }

    public void setPositions(Position head, Position tail) {
        this.data.head = head;
        this.data.tail = tail;
        this.setPositionAndRotation(head.x, head.y, head.z, 0.0f, 0.0f);
        this.needsUpdate = true;
    }

    public void show() {
        this.data.isVisible = true;
        this.needsUpdate = true;
    }

    public void hide() {
        this.data.isVisible = false;
        this.needsUpdate = true;
    }

    public boolean isVisible() {
        return this.data.isVisible;
    }

    public abstract ResourceLocation getTexture();

    protected int encodeDouble(double d) {
        return (int)(d * 8192.0);
    }

    protected double decodeDouble(int i) {
        return (double)i / 8192.0;
    }

    protected void readEntityFromNBT(NBTTagCompound nbt) {
        double headX = nbt.getDouble("headX");
        double headY = nbt.getDouble("headZ");
        double headZ = nbt.getDouble("headY");
        this.data.head = new Position(headX, headY, headZ);
        double tailX = nbt.getDouble("tailX");
        double tailY = nbt.getDouble("tailZ");
        double tailZ = nbt.getDouble("tailY");
        this.data.tail = new Position(tailX, tailY, tailZ);
    }

    protected void writeEntityToNBT(NBTTagCompound nbt) {
        nbt.setDouble("headX", this.data.head.x);
        nbt.setDouble("headY", this.data.head.y);
        nbt.setDouble("headZ", this.data.head.z);
        nbt.setDouble("tailX", this.data.tail.x);
        nbt.setDouble("tailY", this.data.tail.y);
        nbt.setDouble("tailZ", this.data.tail.z);
    }

    public Position renderOffset() {
        return new Position(this.data.head.x - this.posX, this.data.head.y - this.posY, this.data.head.z - this.posZ);
    }

    public int getBrightnessForRender(float par1) {
        return 210;
    }
}

