/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.api.boards.RedstoneBoardRegistry;
import buildcraft.api.core.BlockIndex;
import buildcraft.api.core.IBox;
import buildcraft.api.core.IZone;
import buildcraft.api.items.IMapLocation;
import buildcraft.builders.TileMarker;
import buildcraft.builders.TilePathMarker;
import buildcraft.core.Box;
import buildcraft.core.CreativeTabBuildCraft;
import buildcraft.core.ItemBuildCraft;
import buildcraft.core.ZonePlan;
import buildcraft.core.utils.NBTUtils;
import buildcraft.core.utils.StringUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemMapLocation
extends ItemBuildCraft
implements IMapLocation {
    public IIcon clean;
    public IIcon spot;
    public IIcon area;
    public IIcon path;
    public IIcon zone;

    public ItemMapLocation() {
        super(CreativeTabBuildCraft.ITEMS);
    }

    public int getItemStackLimit(ItemStack stack) {
        return NBTUtils.getItemData(stack).hasKey("kind") ? 1 : 16;
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean advanced) {
        NBTTagCompound cpt = NBTUtils.getItemData(stack);
        if (cpt.hasKey("kind")) {
            switch (cpt.getByte("kind")) {
                case 0: {
                    int x = cpt.getInteger("x");
                    int y = cpt.getInteger("y");
                    int z = cpt.getInteger("z");
                    ForgeDirection side = ForgeDirection.values()[cpt.getByte("side")];
                    list.add(StringUtils.localize("{" + x + ", " + y + ", " + z + ", " + side + "}"));
                    break;
                }
                case 1: {
                    int x = cpt.getInteger("xMin");
                    int y = cpt.getInteger("yMin");
                    int z = cpt.getInteger("zMin");
                    int xLength = cpt.getInteger("xMax") - x + 1;
                    int yLength = cpt.getInteger("yMax") - y + 1;
                    int zLength = cpt.getInteger("zMax") - z + 1;
                    list.add(StringUtils.localize("{" + x + ", " + y + ", " + z + "} + {" + xLength + " x " + yLength + " x " + zLength + "}"));
                    break;
                }
                case 2: {
                    NBTTagList pathNBT = cpt.getTagList("path", 10);
                    BlockIndex first = new BlockIndex(pathNBT.getCompoundTagAt(0));
                    int x = first.x;
                    int y = first.y;
                    int z = first.z;
                    list.add(StringUtils.localize("{" + x + ", " + y + ", " + z + "} + " + pathNBT.tagCount() + " elements"));
                    break;
                }
            }
        }
        if (cpt.hasKey("kind")) {
            // empty if block
        }
    }

    public IIcon getIconIndex(ItemStack stack) {
        NBTTagCompound cpt = NBTUtils.getItemData(stack);
        if (!cpt.hasKey("kind")) {
            this.itemIcon = this.clean;
        } else {
            switch (cpt.getByte("kind")) {
                case 0: {
                    this.itemIcon = this.spot;
                    break;
                }
                case 1: {
                    this.itemIcon = this.area;
                    break;
                }
                case 2: {
                    this.itemIcon = this.path;
                    break;
                }
                case 3: {
                    this.itemIcon = this.zone;
                }
            }
        }
        return this.itemIcon;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister par1IconRegister) {
        this.clean = par1IconRegister.registerIcon("buildcraft:map_clean");
        this.spot = par1IconRegister.registerIcon("buildcraft:map_spot");
        this.area = par1IconRegister.registerIcon("buildcraft:map_area");
        this.path = par1IconRegister.registerIcon("buildcraft:map_path");
        this.zone = par1IconRegister.registerIcon("buildcraft:map_zone");
        RedstoneBoardRegistry.instance.registerIcons(par1IconRegister);
    }

    public boolean onItemUse(ItemStack stack, EntityPlayer par2EntityPlayer, World world, int x, int y, int z, int side, float par8, float par9, float par10) {
        TileEntity tile = world.getTileEntity(x, y, z);
        NBTTagCompound cpt = NBTUtils.getItemData(stack);
        if (tile instanceof TilePathMarker) {
            cpt.setByte("kind", (byte)2);
            TilePathMarker pathTile = (TilePathMarker)tile;
            NBTTagList pathNBT = new NBTTagList();
            for (BlockIndex index : pathTile.getPath()) {
                NBTTagCompound nbt = new NBTTagCompound();
                index.writeTo(nbt);
                pathNBT.appendTag((NBTBase)nbt);
            }
            cpt.setTag("path", (NBTBase)pathNBT);
        } else if (tile instanceof TileMarker) {
            cpt.setByte("kind", (byte)1);
            TileMarker areaTile = (TileMarker)tile;
            cpt.setInteger("xMin", areaTile.xMin());
            cpt.setInteger("yMin", areaTile.yMin());
            cpt.setInteger("zMin", areaTile.zMin());
            cpt.setInteger("xMax", areaTile.xMax());
            cpt.setInteger("yMax", areaTile.yMax());
            cpt.setInteger("zMax", areaTile.zMax());
        } else {
            cpt.setByte("kind", (byte)0);
            cpt.setByte("side", (byte)side);
            cpt.setInteger("x", x);
            cpt.setInteger("y", y);
            cpt.setInteger("z", z);
        }
        return true;
    }

    @Override
    public IBox getBox(ItemStack item) {
        NBTTagCompound cpt = NBTUtils.getItemData(item);
        if (cpt.hasKey("kind") && cpt.getByte("kind") == 1) {
            int xMin = cpt.getInteger("xMin");
            int yMin = cpt.getInteger("yMin");
            int zMin = cpt.getInteger("zMin");
            int xMax = cpt.getInteger("xMax");
            int yMax = cpt.getInteger("yMax");
            int zMax = cpt.getInteger("zMax");
            return new Box(xMin, yMin, zMin, xMax, yMax, zMax);
        }
        if (cpt.hasKey("kind") && cpt.getByte("kind") == 0) {
            return ItemMapLocation.getPointBox(item);
        }
        return null;
    }

    public static IBox getPointBox(ItemStack item) {
        NBTTagCompound cpt = NBTUtils.getItemData(item);
        if (cpt.hasKey("kind") && cpt.getByte("kind") == 0) {
            int x = cpt.getInteger("x");
            int y = cpt.getInteger("y");
            int z = cpt.getInteger("z");
            return new Box(x, y, z, x, y, z);
        }
        return null;
    }

    @Override
    public ForgeDirection getPointSide(ItemStack item) {
        NBTTagCompound cpt = NBTUtils.getItemData(item);
        if (cpt.hasKey("kind") && cpt.getByte("kind") == 0) {
            return ForgeDirection.values()[cpt.getByte("side")];
        }
        return ForgeDirection.UNKNOWN;
    }

    @Override
    public BlockIndex getPoint(ItemStack item) {
        NBTTagCompound cpt = NBTUtils.getItemData(item);
        if (cpt.hasKey("kind") && cpt.getByte("kind") == 0) {
            return new BlockIndex(cpt.getInteger("x"), cpt.getInteger("y"), cpt.getInteger("z"));
        }
        return null;
    }

    @Override
    public IZone getZone(ItemStack item) {
        NBTTagCompound cpt = NBTUtils.getItemData(item);
        if (cpt.hasKey("kind") && cpt.getByte("kind") == 3) {
            ZonePlan plan = new ZonePlan();
            plan.readFromNBT(cpt);
            return plan;
        }
        if (cpt.hasKey("kind") && cpt.getByte("kind") == 1) {
            return this.getBox(item);
        }
        if (cpt.hasKey("kind") && cpt.getByte("kind") == 0) {
            return ItemMapLocation.getPointBox(item);
        }
        return null;
    }

    @Override
    public List<BlockIndex> getPath(ItemStack item) {
        NBTTagCompound cpt = NBTUtils.getItemData(item);
        if (cpt.hasKey("kind") && cpt.getByte("kind") == 2) {
            ArrayList<BlockIndex> indexList = new ArrayList<BlockIndex>();
            NBTTagList pathNBT = cpt.getTagList("path", 10);
            for (int i = 0; i < pathNBT.tagCount(); ++i) {
                indexList.add(new BlockIndex(pathNBT.getCompoundTagAt(i)));
            }
            return indexList;
        }
        if (cpt.hasKey("kind") && cpt.getByte("kind") == 0) {
            ArrayList<BlockIndex> indexList = new ArrayList<BlockIndex>();
            indexList.add(new BlockIndex(cpt.getInteger("x"), cpt.getInteger("y"), cpt.getInteger("z")));
            return indexList;
        }
        return null;
    }

    public static void setZone(ItemStack item, ZonePlan plan) {
        NBTTagCompound cpt = NBTUtils.getItemData(item);
        cpt.setByte("kind", (byte)3);
        plan.writeToNBT(cpt);
    }

    @Override
    public IMapLocation.MapLocationType getType(ItemStack stack) {
        NBTTagCompound cpt = NBTUtils.getItemData(stack);
        return IMapLocation.MapLocationType.values()[cpt.getByte("kind")];
    }
}

