/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import cofh.api.energy.IEnergyStorage;
import net.minecraft.nbt.NBTTagCompound;

public class RFBattery
implements IEnergyStorage {
    private int energy;
    private int maxEnergy;
    private int maxReceive;
    private int maxExtract;

    public RFBattery(int maxEnergy, int maxReceive, int maxExtract) {
        this.maxEnergy = maxEnergy;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
    }

    public void readFromNBT(NBTTagCompound tag) {
        if (tag.hasKey("energy") && tag.hasKey("maxEnergy") && tag.hasKey("maxReceive") && tag.hasKey("maxExtract")) {
            this.energy = tag.getInteger("energy");
            this.maxEnergy = tag.getInteger("maxEnergy");
            this.maxReceive = tag.getInteger("maxReceive");
            this.maxExtract = tag.getInteger("maxExtract");
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.setInteger("energy", this.energy);
        tag.setInteger("maxEnergy", this.maxEnergy);
        tag.setInteger("maxReceive", this.maxReceive);
        tag.setInteger("maxExtract", this.maxExtract);
    }

    public int addEnergy(int minReceive, int maxReceive, boolean simulate) {
        int amountReceived = Math.min(maxReceive, this.maxEnergy - this.energy);
        if (amountReceived < minReceive) {
            return 0;
        }
        if (!simulate) {
            this.energy += amountReceived;
        }
        return amountReceived;
    }

    public int useEnergy(int minExtract, int maxExtract, boolean simulate) {
        int amountExtracted = Math.min(maxExtract, this.energy);
        if (amountExtracted < minExtract) {
            return 0;
        }
        if (!simulate) {
            this.energy -= amountExtracted;
        }
        return amountExtracted;
    }

    @Override
    public int receiveEnergy(int maxReceive, boolean simulate) {
        return this.addEnergy(0, Math.min(maxReceive, this.maxReceive), simulate);
    }

    @Override
    public int extractEnergy(int maxExtract, boolean simulate) {
        return this.useEnergy(0, Math.min(maxExtract, this.maxExtract), simulate);
    }

    @Override
    public int getEnergyStored() {
        return this.energy;
    }

    @Override
    public int getMaxEnergyStored() {
        return this.maxEnergy;
    }

    public int getMaxEnergyReceive() {
        return this.maxReceive;
    }

    public int getMaxEnergyExtract() {
        return this.maxExtract;
    }

    public void setEnergy(int iEnergy) {
        this.energy = iEnergy;
        if (this.energy < 0) {
            this.energy = 0;
        } else if (this.energy > this.maxEnergy) {
            this.energy = this.maxEnergy;
        }
    }
}

