/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.BuildCraftCore;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class SpringPopulate {
    @SubscribeEvent
    public void populate(PopulateChunkEvent.Post event) {
        boolean doGen = TerrainGen.populate((IChunkProvider)event.chunkProvider, (World)event.world, (Random)event.rand, (int)event.chunkX, (int)event.chunkZ, (boolean)event.hasVillageGenerated, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.CUSTOM);
        if (!doGen) {
            event.setResult(Event.Result.ALLOW);
            return;
        }
        int worldX = event.chunkX << 4;
        int worldZ = event.chunkZ << 4;
        this.doPopulate(event.world, event.rand, worldX, worldZ);
    }

    private void doPopulate(World world, Random random, int x, int z) {
        if (random.nextFloat() > 0.025f) {
            return;
        }
        BiomeGenBase biomegenbase = world.getWorldChunkManager().getBiomeGenAt(x, z);
        if (biomegenbase.biomeID == BiomeGenBase.sky.biomeID || biomegenbase.biomeID == BiomeGenBase.hell.biomeID) {
            return;
        }
        int posX = x + random.nextInt(16);
        int posZ = z + random.nextInt(16);
        block0: for (int i = 0; i < 5; ++i) {
            Block candidate = world.getBlock(posX, i, posZ);
            if (candidate != Blocks.bedrock) continue;
            world.setBlock(posX, i + 1, posZ, BuildCraftCore.springBlock);
            for (int j = i + 2; j < world.getActualHeight() - 10; ++j) {
                if (this.boreToSurface(world, posX, j, posZ)) continue;
                if (!world.isAirBlock(posX, j, posZ)) break block0;
                world.setBlock(posX, j, posZ, Blocks.water);
                break block0;
            }
            break;
        }
    }

    private boolean boreToSurface(World world, int x, int y, int z) {
        if (world.isAirBlock(x, y, z)) {
            return false;
        }
        Block existing = world.getBlock(x, y, z);
        if (existing != Blocks.stone && existing != Blocks.dirt && existing != Blocks.gravel && existing != Blocks.grass) {
            return false;
        }
        world.setBlock(x, y, z, Blocks.water);
        return true;
    }
}

