/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.ISerializable;
import buildcraft.api.tiles.IControllable;
import buildcraft.core.DefaultProps;
import buildcraft.core.RFBattery;
import buildcraft.core.TileBuffer;
import buildcraft.core.network.BuildCraftPacket;
import buildcraft.core.network.ISynchronizedTile;
import buildcraft.core.network.PacketTileUpdate;
import buildcraft.core.utils.Utils;
import cofh.api.energy.IEnergyHandler;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileBuildCraft
extends TileEntity
implements IEnergyHandler,
ISynchronizedTile,
ISerializable {
    protected TileBuffer[] cache;
    protected HashSet<EntityPlayer> guiWatchers = new HashSet();
    protected IControllable.Mode mode;
    private boolean init = false;
    private String owner = "[BuildCraft]";
    private RFBattery battery;
    private int receivedTick;
    private int extractedTick;

    public String getOwner() {
        return this.owner;
    }

    public void addGuiWatcher(EntityPlayer player) {
        if (!this.guiWatchers.contains(player)) {
            this.guiWatchers.add(player);
        }
    }

    public void removeGuiWatcher(EntityPlayer player) {
        if (this.guiWatchers.contains(player)) {
            this.guiWatchers.remove(player);
        }
    }

    public void updateEntity() {
        if (!this.init && !this.isInvalid()) {
            this.initialize();
            this.init = true;
        }
        if (this.battery != null) {
            this.receivedTick = 0;
            this.extractedTick = 0;
        }
    }

    public void initialize() {
    }

    public void validate() {
        super.validate();
        this.cache = null;
    }

    public void invalidate() {
        this.init = false;
        super.invalidate();
        this.cache = null;
    }

    public void onBlockPlacedBy(EntityLivingBase entity, ItemStack stack) {
        if (entity instanceof EntityPlayer) {
            this.owner = ((EntityPlayer)entity).getDisplayName();
        }
    }

    public void destroy() {
        this.cache = null;
    }

    public void sendNetworkUpdate() {
        if (this.worldObj != null && !this.worldObj.isRemote) {
            BuildCraftCore.instance.sendToPlayers(this.getPacketUpdate(), this.worldObj, this.xCoord, this.yCoord, this.zCoord, DefaultProps.NETWORK_UPDATE_RANGE);
        }
    }

    @Override
    public void writeData(ByteBuf stream) {
    }

    @Override
    public void readData(ByteBuf stream) {
    }

    @Override
    public BuildCraftPacket getPacketUpdate() {
        return new PacketTileUpdate(this);
    }

    public Packet getDescriptionPacket() {
        return Utils.toPacket(this.getPacketUpdate(), 0);
    }

    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.setString("owner", this.owner);
        if (this.battery != null) {
            NBTTagCompound batteryNBT = new NBTTagCompound();
            this.battery.writeToNBT(batteryNBT);
            nbt.setTag("battery", (NBTBase)batteryNBT);
        }
        if (this.mode != null) {
            nbt.setByte("lastMode", (byte)this.mode.ordinal());
        }
    }

    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        if (nbt.hasKey("owner")) {
            this.owner = nbt.getString("owner");
        }
        if (this.battery != null) {
            this.battery.readFromNBT(nbt.getCompoundTag("battery"));
        }
        if (nbt.hasKey("lastMode")) {
            this.mode = IControllable.Mode.values()[nbt.getByte("lastMode")];
        }
    }

    public int hashCode() {
        return (this.xCoord * 37 + this.yCoord) * 37 + this.zCoord;
    }

    public boolean equals(Object cmp) {
        return this == cmp;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return this.battery != null;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (this.battery != null && this.canConnectEnergy(from)) {
            int received = this.battery.receiveEnergy(maxReceive - this.receivedTick, simulate);
            if (!simulate) {
                this.receivedTick += received;
            }
            return received;
        }
        return 0;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        if (this.battery != null && this.canConnectEnergy(from)) {
            int extracted = this.battery.extractEnergy(maxExtract - this.extractedTick, simulate);
            if (!simulate) {
                this.extractedTick += extracted;
            }
            return extracted;
        }
        return 0;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        if (this.battery != null && this.canConnectEnergy(from)) {
            return this.battery.getEnergyStored();
        }
        return 0;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        if (this.battery != null && this.canConnectEnergy(from)) {
            return this.battery.getMaxEnergyStored();
        }
        return 0;
    }

    public RFBattery getBattery() {
        return this.battery;
    }

    protected void setBattery(RFBattery battery) {
        this.battery = battery;
    }

    public Block getBlock(ForgeDirection side) {
        if (this.cache == null) {
            this.cache = TileBuffer.makeBuffer(this.worldObj, this.xCoord, this.yCoord, this.zCoord, false);
        }
        return this.cache[side.ordinal()].getBlock();
    }

    public TileEntity getTile(ForgeDirection side) {
        if (this.cache == null) {
            this.cache = TileBuffer.makeBuffer(this.worldObj, this.xCoord, this.yCoord, this.zCoord, false);
        }
        return this.cache[side.ordinal()].getTile();
    }

    public IControllable.Mode getControlMode() {
        return this.mode;
    }

    public void setControlMode(IControllable.Mode mode) {
        this.mode = mode;
    }
}

