/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.api.core.BlockIndex;
import buildcraft.api.core.ISerializable;
import buildcraft.core.utils.BitSetUtils;
import buildcraft.core.utils.Utils;
import io.netty.buffer.ByteBuf;
import java.util.BitSet;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;

public class ZoneChunk
implements ISerializable {
    public BitSet property;
    private boolean fullSet = false;

    public boolean get(int xChunk, int zChunk) {
        if (this.fullSet) {
            return true;
        }
        if (this.property == null) {
            return false;
        }
        return this.property.get(xChunk + zChunk * 16);
    }

    public void set(int xChunk, int zChunk, boolean value) {
        if (value) {
            if (this.fullSet) {
                return;
            }
            if (this.property == null) {
                this.property = new BitSet(256);
            }
            this.property.set(xChunk + zChunk * 16, value);
            if (this.property.cardinality() >= 256) {
                this.property = null;
                this.fullSet = true;
            }
        } else {
            if (this.fullSet) {
                this.property = new BitSet(256);
                this.property.flip(0, 255);
                this.fullSet = false;
            } else if (this.property == null) {
                this.property = new BitSet(256);
            }
            this.property.set(xChunk + zChunk * 16, value);
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.setBoolean("fullSet", this.fullSet);
        if (this.property != null) {
            nbt.setByteArray("bits", BitSetUtils.toByteArray(this.property));
        }
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.fullSet = nbt.getBoolean("fullSet");
        if (nbt.hasKey("bits")) {
            this.property = BitSetUtils.fromByteArray(nbt.getByteArray("bits"));
        }
    }

    public BlockIndex getRandomBlockIndex(Random rand) {
        int z;
        int x;
        if (this.fullSet) {
            x = rand.nextInt(16);
            z = rand.nextInt(16);
        } else {
            int bitPosition = this.property.nextSetBit(0);
            for (int bitId = rand.nextInt(this.property.cardinality()); bitId > 0; --bitId) {
                bitPosition = this.property.nextSetBit(bitPosition + 1);
            }
            z = bitPosition / 16;
            x = bitPosition - 16 * z;
        }
        int y = rand.nextInt(255);
        return new BlockIndex(x, y, z);
    }

    public boolean isEmpty() {
        return !this.fullSet && this.property.isEmpty();
    }

    @Override
    public void readData(ByteBuf stream) {
        if (stream.readBoolean()) {
            this.property = BitSetUtils.fromByteArray(Utils.readByteArray(stream));
        }
        this.fullSet = stream.readBoolean();
    }

    @Override
    public void writeData(ByteBuf stream) {
        if (this.property != null) {
            stream.writeBoolean(true);
            Utils.writeByteArray(stream, BitSetUtils.toByteArray(this.property));
        } else {
            stream.writeBoolean(false);
        }
        stream.writeBoolean(this.fullSet);
    }
}

