/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.api.core.BlockIndex;
import buildcraft.api.core.ISerializable;
import buildcraft.api.core.IZone;
import buildcraft.core.ChunkIndex;
import buildcraft.core.ZoneChunk;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ZonePlan
implements IZone,
ISerializable {
    private HashMap<ChunkIndex, ZoneChunk> chunkMapping = new HashMap();

    public boolean get(int x, int z) {
        int xChunk = x >> 4;
        int zChunk = z >> 4;
        ChunkIndex chunkId = new ChunkIndex(xChunk, zChunk);
        if (!this.chunkMapping.containsKey(chunkId)) {
            return false;
        }
        ZoneChunk property = this.chunkMapping.get(chunkId);
        return property.get(x & 0xF, z & 0xF);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void set(int x, int z, boolean val) {
        ZoneChunk property;
        int xChunk = x >> 4;
        int zChunk = z >> 4;
        ChunkIndex chunkId = new ChunkIndex(xChunk, zChunk);
        if (!this.chunkMapping.containsKey(chunkId)) {
            if (!val) return;
            property = new ZoneChunk();
            this.chunkMapping.put(chunkId, property);
        } else {
            property = this.chunkMapping.get(chunkId);
        }
        property.set(x & 0xF, z & 0xF, val);
        if (!property.isEmpty()) return;
        this.chunkMapping.remove(chunkId);
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        for (Map.Entry<ChunkIndex, ZoneChunk> e : this.chunkMapping.entrySet()) {
            NBTTagCompound subNBT = new NBTTagCompound();
            e.getKey().writeToNBT(subNBT);
            e.getValue().writeToNBT(subNBT);
            list.appendTag((NBTBase)subNBT);
        }
        nbt.setTag("chunkMapping", (NBTBase)list);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        NBTTagList list = nbt.getTagList("chunkMapping", 10);
        for (int i = 0; i < list.tagCount(); ++i) {
            NBTTagCompound subNBT = list.getCompoundTagAt(i);
            ChunkIndex id = new ChunkIndex();
            id.readFromNBT(subNBT);
            ZoneChunk chunk = new ZoneChunk();
            chunk.readFromNBT(subNBT);
            this.chunkMapping.put(id, chunk);
        }
    }

    @Override
    public double distanceTo(BlockIndex index) {
        double maxSqrDistance = Double.MAX_VALUE;
        for (Map.Entry<ChunkIndex, ZoneChunk> e : this.chunkMapping.entrySet()) {
            double cx = e.getKey().x << 12;
            double dx = cx - (double)index.x;
            double cz = e.getKey().x << 12;
            double dz = cz - (double)index.z;
            double sqrDistance = dx * dx + dz * dz;
            if (!(sqrDistance < maxSqrDistance)) continue;
            maxSqrDistance = sqrDistance;
        }
        return Math.sqrt(maxSqrDistance);
    }

    @Override
    public boolean contains(double x, double y, double z) {
        int xBlock = (int)Math.floor(x);
        int zBlock = (int)Math.floor(z);
        return this.get(xBlock, zBlock);
    }

    @Override
    public BlockIndex getRandomBlockIndex(Random rand) {
        if (this.chunkMapping.size() == 0) {
            return null;
        }
        int chunkId = rand.nextInt(this.chunkMapping.size());
        for (Map.Entry<ChunkIndex, ZoneChunk> e : this.chunkMapping.entrySet()) {
            if (chunkId == 0) {
                BlockIndex i = e.getValue().getRandomBlockIndex(rand);
                i.x = (e.getKey().x << 4) + i.x;
                i.z = (e.getKey().z << 4) + i.z;
                return i;
            }
            --chunkId;
        }
        return null;
    }

    @Override
    public void readData(ByteBuf stream) {
        this.chunkMapping.clear();
        int size = stream.readInt();
        for (int i = 0; i < size; ++i) {
            ChunkIndex key = new ChunkIndex();
            ZoneChunk value = new ZoneChunk();
            key.readData(stream);
            value.readData(stream);
            this.chunkMapping.put(key, value);
        }
    }

    @Override
    public void writeData(ByteBuf stream) {
        stream.writeInt(this.chunkMapping.size());
        for (Map.Entry<ChunkIndex, ZoneChunk> e : this.chunkMapping.entrySet()) {
            e.getKey().writeData(stream);
            e.getValue().writeData(stream);
        }
    }
}

