/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.blueprints;

import buildcraft.api.blueprints.BuildingPermission;
import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.MappingRegistry;
import buildcraft.api.blueprints.SchematicBlockBase;
import buildcraft.api.blueprints.Translation;
import buildcraft.api.core.BCLog;
import buildcraft.api.core.Position;
import buildcraft.builders.ItemBlueprint;
import buildcraft.builders.blueprints.BlueprintId;
import buildcraft.core.Box;
import buildcraft.core.blueprints.Blueprint;
import buildcraft.core.blueprints.BptContext;
import buildcraft.core.blueprints.BptError;
import buildcraft.core.blueprints.Template;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class BlueprintBase {
    public ArrayList<NBTTagCompound> subBlueprintsNBT = new ArrayList();
    public SchematicBlockBase[][][] contents;
    public int anchorX;
    public int anchorY;
    public int anchorZ;
    public int sizeX;
    public int sizeY;
    public int sizeZ;
    public BlueprintId id = new BlueprintId();
    public String author;
    public boolean rotate = true;
    public boolean excavate = true;
    public BuildingPermission buildingPermission = BuildingPermission.ALL;
    public boolean isComplete = true;
    protected MappingRegistry mapping = new MappingRegistry();
    private ComputeDataThread computeData;
    private byte[] data;
    private ForgeDirection mainDir = ForgeDirection.EAST;

    public BlueprintBase() {
    }

    public BlueprintBase(int sizeX, int sizeY, int sizeZ) {
        this.contents = new SchematicBlockBase[sizeX][sizeY][sizeZ];
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
        this.anchorX = 0;
        this.anchorY = 0;
        this.anchorZ = 0;
    }

    public void translateToBlueprint(Translation transform) {
        for (int x = 0; x < this.sizeX; ++x) {
            for (int y = 0; y < this.sizeY; ++y) {
                for (int z = 0; z < this.sizeZ; ++z) {
                    if (this.contents[x][y][z] == null) continue;
                    this.contents[x][y][z].translateToBlueprint(transform);
                }
            }
        }
    }

    public void translateToWorld(Translation transform) {
        for (int x = 0; x < this.sizeX; ++x) {
            for (int y = 0; y < this.sizeY; ++y) {
                for (int z = 0; z < this.sizeZ; ++z) {
                    if (this.contents[x][y][z] == null) continue;
                    this.contents[x][y][z].translateToWorld(transform);
                }
            }
        }
    }

    public void rotateLeft(BptContext context) {
        SchematicBlockBase[][][] newContents = new SchematicBlockBase[this.sizeZ][this.sizeY][this.sizeX];
        for (int x = 0; x < this.sizeZ; ++x) {
            for (int y = 0; y < this.sizeY; ++y) {
                for (int z = 0; z < this.sizeX; ++z) {
                    newContents[x][y][z] = this.contents[z][y][this.sizeZ - 1 - x];
                    if (newContents[x][y][z] == null) continue;
                    try {
                        newContents[x][y][z].rotateLeft(context);
                        continue;
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        BCLog.logger.throwing(t);
                    }
                }
            }
        }
        int newAnchorX = this.sizeZ - 1 - this.anchorZ;
        int newAnchorY = this.anchorY;
        int newAnchorZ = this.anchorX;
        for (NBTTagCompound sub : this.subBlueprintsNBT) {
            ForgeDirection dir = ForgeDirection.values()[sub.getByte("dir")];
            dir = dir.getRotation(ForgeDirection.UP);
            Position pos = new Position(sub.getInteger("x"), sub.getInteger("y"), sub.getInteger("z"));
            Position np = context.rotatePositionLeft(pos);
            sub.setInteger("x", (int)np.x);
            sub.setInteger("z", (int)np.z);
            sub.setByte("dir", (byte)dir.ordinal());
            NBTTagCompound nBTTagCompound = sub.getCompoundTag("bpt");
        }
        context.rotateLeft();
        this.anchorX = newAnchorX;
        this.anchorY = newAnchorY;
        this.anchorZ = newAnchorZ;
        this.contents = newContents;
        int tmp = this.sizeX;
        this.sizeX = this.sizeZ;
        this.sizeZ = tmp;
        this.mainDir = this.mainDir.getRotation(ForgeDirection.UP);
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.setString("version", "6.4.10");
        if (this instanceof Template) {
            nbt.setString("kind", "template");
        } else {
            nbt.setString("kind", "blueprint");
        }
        nbt.setInteger("sizeX", this.sizeX);
        nbt.setInteger("sizeY", this.sizeY);
        nbt.setInteger("sizeZ", this.sizeZ);
        nbt.setInteger("anchorX", this.anchorX);
        nbt.setInteger("anchorY", this.anchorY);
        nbt.setInteger("anchorZ", this.anchorZ);
        nbt.setBoolean("rotate", this.rotate);
        nbt.setBoolean("excavate", this.excavate);
        if (this.author != null) {
            nbt.setString("author", this.author);
        }
        this.saveContents(nbt);
        NBTTagList subBptList = new NBTTagList();
        for (NBTTagCompound subBpt : this.subBlueprintsNBT) {
            subBptList.appendTag((NBTBase)subBpt);
        }
        nbt.setTag("subBpt", (NBTBase)subBptList);
    }

    public static BlueprintBase loadBluePrint(NBTTagCompound nbt) {
        String kind = nbt.getString("kind");
        BlueprintBase bpt = "template".equals(kind) ? new Template() : new Blueprint();
        bpt.readFromNBT(nbt);
        return bpt;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.sizeX = nbt.getInteger("sizeX");
        this.sizeY = nbt.getInteger("sizeY");
        this.sizeZ = nbt.getInteger("sizeZ");
        this.anchorX = nbt.getInteger("anchorX");
        this.anchorY = nbt.getInteger("anchorY");
        this.anchorZ = nbt.getInteger("anchorZ");
        this.author = nbt.getString("author");
        this.rotate = nbt.hasKey("rotate") ? nbt.getBoolean("rotate") : true;
        this.excavate = nbt.hasKey("excavate") ? nbt.getBoolean("excavate") : true;
        this.contents = new SchematicBlockBase[this.sizeX][this.sizeY][this.sizeZ];
        try {
            this.loadContents(nbt);
        }
        catch (BptError e) {
            e.printStackTrace();
        }
        if (nbt.hasKey("subBpt")) {
            NBTTagList subBptList = nbt.getTagList("subBpt", 10);
            for (int i = 0; i < subBptList.tagCount(); ++i) {
                this.subBlueprintsNBT.add(subBptList.getCompoundTagAt(i));
            }
        }
    }

    public Box getBoxForPos(int x, int y, int z) {
        int xMin = x - this.anchorX;
        int yMin = y - this.anchorY;
        int zMin = z - this.anchorZ;
        int xMax = x + this.sizeX - this.anchorX - 1;
        int yMax = y + this.sizeY - this.anchorY - 1;
        int zMax = z + this.sizeZ - this.anchorZ - 1;
        Box res = new Box();
        res.initialize(xMin, yMin, zMin, xMax, yMax, zMax);
        res.reorder();
        return res;
    }

    public BptContext getContext(World world, Box box) {
        return new BptContext(world, box, this.mapping);
    }

    public void addSubBlueprint(BlueprintBase bpt, int x, int y, int z, ForgeDirection dir) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.setInteger("x", x);
        nbt.setInteger("y", y);
        nbt.setInteger("z", z);
        nbt.setByte("dir", (byte)dir.ordinal());
        NBTTagCompound bptNBT = new NBTTagCompound();
        bpt.writeToNBT(bptNBT);
        nbt.setTag("bpt", (NBTBase)bptNBT);
        this.subBlueprintsNBT.add(nbt);
    }

    public synchronized byte[] getData() {
        if (this.data != null) {
            return this.data;
        }
        if (this.computeData == null) {
            this.computeData = new ComputeDataThread();
            this.computeData.nbt = new NBTTagCompound();
            this.writeToNBT(this.computeData.nbt);
            this.computeData.start();
        }
        return null;
    }

    public static BlueprintBase instantiate(ItemStack stack, World world, int x, int y, int z, ForgeDirection o) {
        BlueprintBase bpt = ItemBlueprint.loadBlueprint(stack);
        if (bpt == null) {
            return null;
        }
        return bpt.adjustToWorld(world, x, y, z, o);
    }

    public BlueprintBase adjustToWorld(World world, int x, int y, int z, ForgeDirection o) {
        if (this.buildingPermission == BuildingPermission.NONE || this.buildingPermission == BuildingPermission.CREATIVE_ONLY && world.getWorldInfo().getGameType() != WorldSettings.GameType.CREATIVE) {
            return null;
        }
        BptContext context = this.getContext(world, this.getBoxForPos(x, y, z));
        if (this.rotate && o != ForgeDirection.EAST) {
            if (o == ForgeDirection.SOUTH) {
                this.rotateLeft(context);
            } else if (o == ForgeDirection.WEST) {
                this.rotateLeft(context);
                this.rotateLeft(context);
            } else if (o == ForgeDirection.NORTH) {
                this.rotateLeft(context);
                this.rotateLeft(context);
                this.rotateLeft(context);
            }
        }
        Translation transform = new Translation();
        transform.x = x - this.anchorX;
        transform.y = y - this.anchorY;
        transform.z = z - this.anchorZ;
        this.translateToWorld(transform);
        return this;
    }

    public synchronized void setData(byte[] b) {
        this.data = b;
    }

    public abstract void loadContents(NBTTagCompound var1) throws BptError;

    public abstract void saveContents(NBTTagCompound var1);

    public abstract void readFromWorld(IBuilderContext var1, TileEntity var2, int var3, int var4, int var5);

    public abstract ItemStack getStack();

    public void readEntitiesFromWorld(IBuilderContext context, TileEntity anchorTile) {
    }

    class ComputeDataThread
    extends Thread {
        public NBTTagCompound nbt;

        ComputeDataThread() {
        }

        @Override
        public void run() {
            try {
                BlueprintBase.this.setData(CompressedStreamTools.compress((NBTTagCompound)this.nbt));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

