/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.blueprints;

import buildcraft.api.blueprints.Schematic;
import buildcraft.api.blueprints.SchematicBlock;
import buildcraft.api.blueprints.SchematicEntity;
import buildcraft.api.core.BCLog;
import buildcraft.api.core.BlockIndex;
import buildcraft.api.core.BuildCraftAPI;
import buildcraft.api.core.IInvSlot;
import buildcraft.api.core.StackKey;
import buildcraft.builders.TileBuilder;
import buildcraft.core.blueprints.Blueprint;
import buildcraft.core.blueprints.BptBuilderBase;
import buildcraft.core.blueprints.SchematicRegistry;
import buildcraft.core.builders.BuildingSlot;
import buildcraft.core.builders.BuildingSlotBlock;
import buildcraft.core.builders.BuildingSlotEntity;
import buildcraft.core.builders.BuildingSlotIterator;
import buildcraft.core.builders.IBuildingItemsProvider;
import buildcraft.core.builders.TileAbstractBuilder;
import buildcraft.core.inventory.InventoryCopy;
import buildcraft.core.inventory.InventoryIterator;
import buildcraft.core.inventory.StackHelper;
import buildcraft.core.utils.BlockUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class BptBuilderBlueprint
extends BptBuilderBase {
    public ArrayList<ItemStack> neededItems = new ArrayList();
    protected HashSet<Integer> builtEntities = new HashSet();
    private LinkedList<BuildingSlotBlock> buildList = new LinkedList();
    private LinkedList<BuildingSlotEntity> entityList = new LinkedList();
    private LinkedList<BuildingSlot> postProcessing = new LinkedList();
    private BuildingSlotIterator iterator;

    public BptBuilderBlueprint(Blueprint bluePrint, World world, int x, int y, int z) {
        super(bluePrint, world, x, y, z);
    }

    @Override
    protected void internalInit() {
        for (int j = this.blueprint.sizeY - 1; j >= 0; --j) {
            for (int i = 0; i < this.blueprint.sizeX; ++i) {
                for (int k = 0; k < this.blueprint.sizeZ; ++k) {
                    SchematicBlock slot;
                    int xCoord = i + this.x - this.blueprint.anchorX;
                    int yCoord = j + this.y - this.blueprint.anchorY;
                    int zCoord = k + this.z - this.blueprint.anchorZ;
                    if (yCoord < 0 || yCoord >= this.context.world.getHeight() || this.clearedLocations.contains(new BlockIndex(xCoord, yCoord, zCoord)) || (slot = (SchematicBlock)this.blueprint.contents[i][j][k]) == null && !this.blueprint.excavate) continue;
                    if (slot == null) {
                        slot = new SchematicBlock();
                        slot.meta = 0;
                        slot.block = Blocks.air;
                    }
                    if (!SchematicRegistry.INSTANCE.isAllowedForBuilding(slot.block, slot.meta)) continue;
                    BuildingSlotBlock b = new BuildingSlotBlock();
                    b.schematic = slot;
                    b.x = xCoord;
                    b.y = yCoord;
                    b.z = zCoord;
                    b.mode = BuildingSlotBlock.Mode.ClearIfInvalid;
                    b.buildStage = 0;
                    this.buildList.add(b);
                }
            }
        }
        LinkedList<BuildingSlotBlock> tmpStandalone = new LinkedList<BuildingSlotBlock>();
        LinkedList<BuildingSlotBlock> tmpSupported = new LinkedList<BuildingSlotBlock>();
        LinkedList<BuildingSlotBlock> tmpExpanding = new LinkedList<BuildingSlotBlock>();
        for (int j = 0; j < this.blueprint.sizeY; ++j) {
            for (int i = 0; i < this.blueprint.sizeX; ++i) {
                for (int k = 0; k < this.blueprint.sizeZ; ++k) {
                    int xCoord = i + this.x - this.blueprint.anchorX;
                    int yCoord = j + this.y - this.blueprint.anchorY;
                    int zCoord = k + this.z - this.blueprint.anchorZ;
                    SchematicBlock slot = (SchematicBlock)this.blueprint.contents[i][j][k];
                    if (slot == null || yCoord < 0 || yCoord >= this.context.world.getHeight() || !SchematicRegistry.INSTANCE.isAllowedForBuilding(slot.block, slot.meta)) continue;
                    BuildingSlotBlock b = new BuildingSlotBlock();
                    b.schematic = slot;
                    b.x = xCoord;
                    b.y = yCoord;
                    b.z = zCoord;
                    b.mode = BuildingSlotBlock.Mode.Build;
                    if (!this.builtLocations.contains(new BlockIndex(xCoord, yCoord, zCoord))) {
                        switch (slot.getBuildStage()) {
                            case STANDALONE: {
                                tmpStandalone.add(b);
                                b.buildStage = 1;
                                break;
                            }
                            case SUPPORTED: {
                                tmpSupported.add(b);
                                b.buildStage = 2;
                                break;
                            }
                            case EXPANDING: {
                                tmpExpanding.add(b);
                                b.buildStage = 3;
                            }
                        }
                        continue;
                    }
                    this.postProcessing.add(b);
                }
            }
        }
        this.buildList.addAll(tmpStandalone);
        this.buildList.addAll(tmpSupported);
        this.buildList.addAll(tmpExpanding);
        this.iterator = new BuildingSlotIterator(this.buildList);
        int seqId = 0;
        for (SchematicEntity e : ((Blueprint)this.blueprint).entities) {
            BuildingSlotEntity b = new BuildingSlotEntity();
            b.schematic = e;
            b.sequenceNumber = seqId;
            if (!this.builtEntities.contains(seqId)) {
                this.entityList.add(b);
            } else {
                this.postProcessing.add(b);
            }
            ++seqId;
        }
        this.recomputeNeededItems();
    }

    public void deploy() {
        this.initialize();
        for (BuildingSlotBlock b : this.buildList) {
            if (b.mode == BuildingSlotBlock.Mode.ClearIfInvalid) {
                this.context.world.setBlockToAir(b.x, b.y, b.z);
                continue;
            }
            if (b.schematic.doNotBuild()) continue;
            b.stackConsumed = new LinkedList();
            try {
                for (ItemStack stk : b.getRequirements(this.context)) {
                    if (stk == null) continue;
                    b.stackConsumed.add(stk.copy());
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                BCLog.logger.throwing(t);
            }
            b.writeToWorld(this.context);
        }
        for (BuildingSlotEntity e : this.entityList) {
            e.stackConsumed = new LinkedList();
            try {
                for (ItemStack stk : e.getRequirements(this.context)) {
                    if (stk == null) continue;
                    e.stackConsumed.add(stk.copy());
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                BCLog.logger.throwing(t);
            }
            e.writeToWorld(this.context);
        }
        for (BuildingSlotBlock b : this.buildList) {
            if (b.mode == BuildingSlotBlock.Mode.ClearIfInvalid) continue;
            b.postProcessing(this.context);
        }
        for (BuildingSlotEntity e : this.entityList) {
            e.postProcessing(this.context);
        }
    }

    private void checkDone() {
        this.recomputeNeededItems();
        this.done = this.buildList.size() == 0 && this.entityList.size() == 0;
    }

    @Override
    public BuildingSlot reserveNextBlock(World world) {
        if (this.buildList.size() != 0) {
            BuildingSlot slot = this.internalGetNextBlock(world, null);
            if (slot != null) {
                slot.reserved = true;
            }
            return slot;
        }
        return null;
    }

    @Override
    public BuildingSlot getNextBlock(World world, TileAbstractBuilder inv) {
        if (this.buildList.size() != 0) {
            BuildingSlot slot = this.internalGetNextBlock(world, inv);
            this.checkDone();
            return slot;
        }
        if (this.entityList.size() != 0) {
            BuildingSlot slot = this.internalGetNextEntity(world, inv);
            this.checkDone();
            return slot;
        }
        this.checkDone();
        return null;
    }

    private BuildingSlot internalGetNextBlock(World world, TileAbstractBuilder builder) {
        if (builder != null && builder.energyAvailable() < 160) {
            this.iterator.reset();
            return null;
        }
        this.iterator.startIteration();
        while (this.iterator.hasNext()) {
            BuildingSlotBlock slot = this.iterator.next();
            if (!world.blockExists(slot.x, slot.y, slot.z)) continue;
            if (slot.buildStage > this.buildList.getFirst().buildStage) {
                this.iterator.reset();
                return null;
            }
            if (slot.built) {
                this.iterator.remove();
                if (slot.mode == BuildingSlotBlock.Mode.ClearIfInvalid) {
                    this.clearedLocations.add(new BlockIndex(slot.x, slot.y, slot.z));
                } else {
                    this.builtLocations.add(new BlockIndex(slot.x, slot.y, slot.z));
                }
                this.postProcessing.add(slot);
                continue;
            }
            if (slot.reserved) continue;
            try {
                if (slot.isAlreadyBuilt(this.context)) {
                    if (slot.mode == BuildingSlotBlock.Mode.Build) {
                        this.postProcessing.add(slot);
                    }
                    this.iterator.remove();
                    continue;
                }
                if (BlockUtils.isUnbreakableBlock(world, slot.x, slot.y, slot.z)) {
                    this.iterator.remove();
                    if (slot.mode == BuildingSlotBlock.Mode.ClearIfInvalid) {
                        this.clearedLocations.add(new BlockIndex(slot.x, slot.y, slot.z));
                        continue;
                    }
                    this.builtLocations.add(new BlockIndex(slot.x, slot.y, slot.z));
                    continue;
                }
                if (slot.mode == BuildingSlotBlock.Mode.ClearIfInvalid) {
                    if (BuildCraftAPI.isSoftBlock(world, slot.x, slot.y, slot.z) || this.isBlockBreakCanceled(world, slot.x, slot.y, slot.z)) {
                        this.iterator.remove();
                        this.clearedLocations.add(new BlockIndex(slot.x, slot.y, slot.z));
                        continue;
                    }
                    if (builder == null) {
                        this.createDestroyItems(slot);
                        return slot;
                    }
                    if (!this.canDestroy(builder, this.context, slot)) continue;
                    this.consumeEnergyToDestroy(builder, slot);
                    this.createDestroyItems(slot);
                    this.iterator.remove();
                    this.clearedLocations.add(new BlockIndex(slot.x, slot.y, slot.z));
                    return slot;
                }
                if (!slot.schematic.doNotBuild()) {
                    if (builder == null) {
                        return slot;
                    }
                    if (!this.checkRequirements(builder, slot.schematic)) continue;
                    if (this.isBlockPlaceCanceled(world, slot.x, slot.y, slot.z, slot.schematic)) {
                        this.iterator.remove();
                        this.builtLocations.add(new BlockIndex(slot.x, slot.y, slot.z));
                        continue;
                    }
                    builder.consumeEnergy(slot.getEnergyRequirement());
                    this.useRequirements(builder, slot);
                    this.iterator.remove();
                    this.postProcessing.add(slot);
                    this.builtLocations.add(new BlockIndex(slot.x, slot.y, slot.z));
                    return slot;
                }
                this.postProcessing.add(slot);
                this.iterator.remove();
            }
            catch (Throwable t) {
                t.printStackTrace();
                BCLog.logger.throwing(t);
                this.iterator.remove();
            }
        }
        return null;
    }

    private BuildingSlot internalGetNextEntity(World world, TileAbstractBuilder builder) {
        Iterator it = this.entityList.iterator();
        while (it.hasNext()) {
            BuildingSlotEntity slot = (BuildingSlotEntity)it.next();
            if (slot.isAlreadyBuilt(this.context)) {
                it.remove();
                continue;
            }
            if (!this.checkRequirements(builder, slot.schematic)) continue;
            builder.consumeEnergy(slot.getEnergyRequirement());
            this.useRequirements(builder, slot);
            it.remove();
            this.postProcessing.add(slot);
            this.builtEntities.add(slot.sequenceNumber);
            return slot;
        }
        return null;
    }

    public boolean checkRequirements(TileAbstractBuilder builder, Schematic slot) {
        LinkedList<ItemStack> tmpReq = new LinkedList<ItemStack>();
        try {
            LinkedList<ItemStack> req = new LinkedList<ItemStack>();
            slot.getRequirementsForPlacement(this.context, req);
            for (ItemStack stk : req) {
                if (stk == null) continue;
                tmpReq.add(stk.copy());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            BCLog.logger.throwing(t);
        }
        LinkedList<ItemStack> stacksUsed = new LinkedList<ItemStack>();
        if (this.context.world().getWorldInfo().getGameType() == WorldSettings.GameType.CREATIVE) {
            for (ItemStack s : tmpReq) {
                stacksUsed.add(s);
            }
            return builder.energyAvailable() >= slot.getEnergyRequirement(stacksUsed);
        }
        for (ItemStack reqStk : tmpReq) {
            Fluid fluid;
            boolean itemBlock = reqStk.getItem() instanceof ItemBlock;
            Fluid fluid2 = fluid = itemBlock ? FluidRegistry.lookupFluidForBlock((Block)((ItemBlock)reqStk.getItem()).field_150939_a) : null;
            if (fluid != null && builder instanceof TileBuilder && ((TileBuilder)builder).drainBuild(new FluidStack(fluid, 1000), true)) continue;
            for (IInvSlot slotInv : InventoryIterator.getIterable(new InventoryCopy(builder), ForgeDirection.UNKNOWN)) {
                boolean compatibleContainer;
                ItemStack invStk;
                if (!builder.isBuildingMaterialSlot(slotInv.getIndex()) || (invStk = slotInv.getStackInSlot()) == null || invStk.stackSize == 0) continue;
                FluidStack fluidStack = fluid != null ? FluidContainerRegistry.getFluidForFilledItem((ItemStack)invStk) : null;
                boolean bl = compatibleContainer = fluidStack != null && fluidStack.getFluid() == fluid && fluidStack.amount >= 1000;
                if (!StackHelper.isMatchingItem(reqStk, invStk, true, true) && !compatibleContainer) continue;
                try {
                    stacksUsed.add(slot.useItem(this.context, reqStk, slotInv));
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    BCLog.logger.throwing(t);
                }
                if (reqStk.stackSize != 0) continue;
                break;
            }
            if (reqStk.stackSize == 0) continue;
            return false;
        }
        return builder.energyAvailable() >= slot.getEnergyRequirement(stacksUsed);
    }

    @Override
    public void useRequirements(IInventory inv, BuildingSlot slot) {
        if (slot instanceof BuildingSlotBlock && ((BuildingSlotBlock)slot).mode == BuildingSlotBlock.Mode.ClearIfInvalid) {
            return;
        }
        LinkedList<ItemStack> tmpReq = new LinkedList<ItemStack>();
        try {
            for (ItemStack stk : slot.getRequirements(this.context)) {
                if (stk == null) continue;
                tmpReq.add(stk.copy());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            BCLog.logger.throwing(t);
        }
        if (this.context.world().getWorldInfo().getGameType() == WorldSettings.GameType.CREATIVE) {
            for (ItemStack s : tmpReq) {
                slot.addStackConsumed(s);
            }
            return;
        }
        ListIterator<ItemStack> itr = tmpReq.listIterator();
        while (itr.hasNext()) {
            Fluid fluid;
            ItemStack reqStk = (ItemStack)itr.next();
            boolean smallStack = reqStk.stackSize == 1;
            ItemStack usedStack = reqStk;
            boolean itemBlock = reqStk.getItem() instanceof ItemBlock;
            Fluid fluid2 = fluid = itemBlock ? FluidRegistry.lookupFluidForBlock((Block)((ItemBlock)reqStk.getItem()).field_150939_a) : null;
            if (fluid != null && inv instanceof TileBuilder && ((TileBuilder)inv).drainBuild(new FluidStack(fluid, 1000), true)) continue;
            for (IInvSlot slotInv : InventoryIterator.getIterable(inv, ForgeDirection.UNKNOWN)) {
                boolean fluidFound;
                ItemStack invStk;
                if (inv instanceof TileAbstractBuilder && !((TileAbstractBuilder)inv).isBuildingMaterialSlot(slotInv.getIndex()) || (invStk = slotInv.getStackInSlot()) == null || invStk.stackSize == 0) continue;
                FluidStack fluidStack = fluid != null ? FluidContainerRegistry.getFluidForFilledItem((ItemStack)invStk) : null;
                boolean bl = fluidFound = fluidStack != null && fluidStack.getFluid() == fluid && fluidStack.amount >= 1000;
                if (!fluidFound && !StackHelper.isCraftingEquivalent(reqStk, invStk, true)) continue;
                try {
                    usedStack = slot.getSchematic().useItem(this.context, reqStk, slotInv);
                    slot.addStackConsumed(usedStack);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    BCLog.logger.throwing(t);
                }
                if (reqStk.stackSize != 0) continue;
                break;
            }
            if (reqStk.stackSize != 0) {
                return;
            }
            if (!smallStack) continue;
            itr.set(usedStack);
        }
    }

    public void recomputeNeededItems() {
        Integer num;
        StackKey key;
        LinkedList<Object> stacks;
        this.neededItems.clear();
        HashMap<StackKey, Integer> computeStacks = new HashMap<StackKey, Integer>();
        for (BuildingSlot buildingSlot : this.buildList) {
            stacks = new LinkedList();
            try {
                stacks = buildingSlot.getRequirements(this.context);
            }
            catch (Throwable t) {
                t.printStackTrace();
                BCLog.logger.throwing(t);
            }
            for (ItemStack itemStack : stacks) {
                if (itemStack == null || itemStack.getItem() == null || itemStack.stackSize == 0) continue;
                key = new StackKey(itemStack);
                if (!computeStacks.containsKey(key)) {
                    computeStacks.put(key, itemStack.stackSize);
                    continue;
                }
                num = (Integer)computeStacks.get(key);
                num = num + itemStack.stackSize;
                computeStacks.put(key, num);
            }
        }
        for (BuildingSlotEntity buildingSlotEntity : this.entityList) {
            stacks = new LinkedList();
            try {
                stacks = buildingSlotEntity.getRequirements(this.context);
            }
            catch (Throwable t) {
                t.printStackTrace();
                BCLog.logger.throwing(t);
            }
            for (ItemStack itemStack : stacks) {
                if (itemStack == null || itemStack.getItem() == null || itemStack.stackSize == 0) continue;
                key = new StackKey(itemStack);
                if (!computeStacks.containsKey(key)) {
                    computeStacks.put(key, itemStack.stackSize);
                    continue;
                }
                num = (Integer)computeStacks.get(key);
                num = num + itemStack.stackSize;
                computeStacks.put(key, num);
            }
        }
        for (Map.Entry entry : computeStacks.entrySet()) {
            ItemStack newStack = ((StackKey)entry.getKey()).stack.copy();
            newStack.stackSize = (Integer)entry.getValue();
            this.neededItems.add(newStack);
        }
        Collections.sort(this.neededItems, new Comparator<ItemStack>(){

            @Override
            public int compare(ItemStack o1, ItemStack o2) {
                if (o1.stackSize > o2.stackSize) {
                    return -1;
                }
                if (o1.stackSize < o2.stackSize) {
                    return 1;
                }
                if (Item.getIdFromItem((Item)o1.getItem()) > Item.getIdFromItem((Item)o2.getItem())) {
                    return -1;
                }
                if (Item.getIdFromItem((Item)o1.getItem()) < Item.getIdFromItem((Item)o2.getItem())) {
                    return 1;
                }
                if (o1.getItemDamage() > o2.getItemDamage()) {
                    return -1;
                }
                if (o1.getItemDamage() < o2.getItemDamage()) {
                    return 1;
                }
                return 0;
            }
        });
    }

    @Override
    public void postProcessing(World world) {
        for (BuildingSlot s : this.postProcessing) {
            try {
                s.postProcessing(this.context);
            }
            catch (Throwable t) {
                t.printStackTrace();
                BCLog.logger.throwing(t);
            }
        }
    }

    @Override
    public void saveBuildStateToNBT(NBTTagCompound nbt, IBuildingItemsProvider builder) {
        super.saveBuildStateToNBT(nbt, builder);
        int[] entitiesBuiltArr = new int[this.builtEntities.size()];
        int id = 0;
        for (Integer i : this.builtEntities) {
            entitiesBuiltArr[id] = i;
            ++id;
        }
        nbt.setIntArray("builtEntities", entitiesBuiltArr);
    }

    @Override
    public void loadBuildStateToNBT(NBTTagCompound nbt, IBuildingItemsProvider builder) {
        super.loadBuildStateToNBT(nbt, builder);
        int[] entitiesBuiltArr = nbt.getIntArray("builtEntities");
        for (int i = 0; i < entitiesBuiltArr.length; ++i) {
            this.builtEntities.add(i);
        }
    }
}

