/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.blueprints;

import buildcraft.api.blueprints.BlueprintDeployer;
import buildcraft.api.blueprints.Translation;
import buildcraft.builders.blueprints.BlueprintDatabase;
import buildcraft.builders.blueprints.BlueprintId;
import buildcraft.core.blueprints.Blueprint;
import buildcraft.core.blueprints.BptBuilderBlueprint;
import buildcraft.core.blueprints.BptContext;
import java.io.File;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class RealBlueprintDeployer
extends BlueprintDeployer {
    @Override
    public void deployBlueprint(World world, int x, int y, int z, ForgeDirection dir, File file) {
        this.deployBlueprint(world, x, y, z, dir, (Blueprint)BlueprintDatabase.load(file));
    }

    @Override
    public void deployBlueprintFromFileStream(World world, int x, int y, int z, ForgeDirection dir, byte[] data) {
        this.deployBlueprint(world, x, y, z, dir, (Blueprint)BlueprintDatabase.load(data));
    }

    private void deployBlueprint(World world, int x, int y, int z, ForgeDirection dir, Blueprint bpt) {
        bpt.id = new BlueprintId();
        bpt.id.kind = BlueprintId.Kind.Blueprint;
        BptContext context = bpt.getContext(world, bpt.getBoxForPos(x, y, z));
        if (bpt.rotate && dir != ForgeDirection.EAST) {
            if (dir == ForgeDirection.SOUTH) {
                bpt.rotateLeft(context);
            } else if (dir == ForgeDirection.WEST) {
                bpt.rotateLeft(context);
                bpt.rotateLeft(context);
            } else if (dir == ForgeDirection.NORTH) {
                bpt.rotateLeft(context);
                bpt.rotateLeft(context);
                bpt.rotateLeft(context);
            }
        }
        Translation transform = new Translation();
        transform.x = x - bpt.anchorX;
        transform.y = y - bpt.anchorY;
        transform.z = z - bpt.anchorZ;
        bpt.translateToWorld(transform);
        new BptBuilderBlueprint(bpt, world, x, y, z).deploy();
    }
}

