/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.builders;

import buildcraft.BuildCraftBuilders;
import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.MappingNotFoundException;
import buildcraft.api.blueprints.MappingRegistry;
import buildcraft.api.core.ISerializable;
import buildcraft.api.core.Position;
import buildcraft.core.StackAtPosition;
import buildcraft.core.builders.BuildingSlot;
import buildcraft.core.builders.BuildingSlotBlock;
import buildcraft.core.builders.BuildingSlotEntity;
import buildcraft.core.builders.IBuildingItem;
import io.netty.buffer.ByteBuf;
import java.util.Date;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.MathHelper;

public class BuildingItem
implements IBuildingItem,
ISerializable {
    public static int ITEMS_SPACE = 2;
    public Position origin;
    public Position destination;
    public LinkedList<StackAtPosition> stacksToDisplay = new LinkedList();
    public boolean isDone = false;
    public BuildingSlot slotToBuild;
    public IBuilderContext context;
    private long previousUpdate;
    private float lifetimeDisplay = 0.0f;
    private float maxLifetime = 0.0f;
    private boolean initialized = false;
    private double vx;
    private double vy;
    private double vz;
    private double maxHeight;
    private float lifetime = 0.0f;

    public void initialize() {
        if (!this.initialized) {
            double dx = this.destination.x - this.origin.x;
            double dy = this.destination.y - this.origin.y;
            double dz = this.destination.z - this.origin.z;
            double size = Math.sqrt(dx * dx + dy * dy + dz * dz);
            this.maxLifetime = (float)size * 4.0f;
            this.maxHeight = size / 2.0;
            Position middle = new Position();
            middle.x = (this.destination.x + this.origin.x) / 2.0;
            middle.y = (this.destination.y + this.origin.y) / 2.0;
            middle.z = (this.destination.z + this.origin.z) / 2.0;
            Position top = new Position();
            top.x = middle.x;
            top.y = middle.y + this.maxHeight;
            top.z = middle.z;
            Position originToTop = new Position();
            originToTop.x = top.x - this.origin.x;
            originToTop.y = top.y - this.origin.y;
            originToTop.z = top.z - this.origin.z;
            Position destinationToTop = new Position();
            destinationToTop.x = this.destination.x - this.origin.x;
            destinationToTop.y = this.destination.y - this.origin.y;
            destinationToTop.z = this.destination.z - this.origin.z;
            Position distance = new Position();
            double d1 = Math.sqrt(originToTop.x * originToTop.x + originToTop.y * originToTop.y + originToTop.z * originToTop.z);
            double d2 = Math.sqrt(destinationToTop.x * destinationToTop.x + destinationToTop.y * destinationToTop.y + destinationToTop.z * destinationToTop.z);
            d1 = d1 / size * (double)this.maxLifetime;
            d2 = d2 / size * (double)this.maxLifetime;
            this.maxLifetime = (float)d1 + (float)d2;
            this.vx = dx / (double)this.maxLifetime;
            this.vy = dy / (double)this.maxLifetime;
            this.vz = dz / (double)this.maxLifetime;
            if (this.stacksToDisplay.size() == 0) {
                StackAtPosition sPos = new StackAtPosition();
                sPos.stack = new ItemStack((Block)BuildCraftBuilders.buildToolBlock);
                this.stacksToDisplay.add(sPos);
            }
            this.initialized = true;
        }
    }

    public Position getDisplayPosition(float time) {
        Position result = new Position();
        result.x = this.origin.x + this.vx * (double)time;
        result.y = this.origin.y + this.vy * (double)time + (double)MathHelper.sin((float)(time / this.maxLifetime * (float)Math.PI)) * this.maxHeight;
        result.z = this.origin.z + this.vz * (double)time;
        return result;
    }

    public void update() {
        if (this.isDone) {
            return;
        }
        this.initialize();
        this.lifetime += 1.0f;
        if (this.lifetime > this.maxLifetime + (float)(this.stacksToDisplay.size() * ITEMS_SPACE) - 1.0f) {
            this.isDone = true;
            this.build();
        }
        this.lifetimeDisplay = this.lifetime;
        this.previousUpdate = new Date().getTime();
        if (this.slotToBuild != null && this.lifetime > this.maxLifetime) {
            this.slotToBuild.writeCompleted(this.context, (this.lifetime - this.maxLifetime) / (float)(this.stacksToDisplay.size() * ITEMS_SPACE));
        }
    }

    public void displayUpdate() {
        this.initialize();
        float tickDuration = 50.0f;
        long currentUpdate = new Date().getTime();
        float timeSpan = currentUpdate - this.previousUpdate;
        this.previousUpdate = currentUpdate;
        float displayPortion = timeSpan / tickDuration;
        if ((double)(this.lifetimeDisplay - this.lifetime) <= 1.0) {
            this.lifetimeDisplay = (float)((double)this.lifetimeDisplay + 1.0 * (double)displayPortion);
        }
    }

    private void build() {
        if (this.slotToBuild != null) {
            int destX = (int)Math.floor(this.destination.x);
            int destY = (int)Math.floor(this.destination.y);
            int destZ = (int)Math.floor(this.destination.z);
            Block block = this.context.world().getBlock(destX, destY, destZ);
            int meta = this.context.world().getBlockMetadata(destX, destY, destZ);
            this.context.world().playAuxSFXAtEntity(null, 2001, destX, destY, destZ, Block.getIdFromBlock((Block)block) + (meta << 12));
            this.slotToBuild.writeToWorld(this.context);
        }
    }

    public LinkedList<StackAtPosition> getStacks() {
        int d = 0;
        for (StackAtPosition s : this.stacksToDisplay) {
            float stackLife = this.lifetimeDisplay - (float)d;
            if (stackLife <= this.maxLifetime && stackLife > 0.0f) {
                s.pos = this.getDisplayPosition(stackLife);
                s.display = true;
            } else {
                s.display = false;
            }
            d += ITEMS_SPACE;
        }
        return this.stacksToDisplay;
    }

    @Override
    public boolean isDone() {
        return this.isDone;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagCompound originNBT = new NBTTagCompound();
        this.origin.writeToNBT(originNBT);
        nbt.setTag("origin", (NBTBase)originNBT);
        NBTTagCompound destinationNBT = new NBTTagCompound();
        this.destination.writeToNBT(destinationNBT);
        nbt.setTag("destination", (NBTBase)destinationNBT);
        nbt.setFloat("lifetime", this.lifetime);
        NBTTagList items = new NBTTagList();
        for (StackAtPosition s : this.stacksToDisplay) {
            NBTTagCompound cpt = new NBTTagCompound();
            s.stack.writeToNBT(cpt);
            items.appendTag((NBTBase)cpt);
        }
        nbt.setTag("items", (NBTBase)items);
        MappingRegistry registry = new MappingRegistry();
        NBTTagCompound slotNBT = new NBTTagCompound();
        NBTTagCompound registryNBT = new NBTTagCompound();
        this.slotToBuild.writeToNBT(slotNBT, registry);
        registry.write(registryNBT);
        nbt.setTag("registry", (NBTBase)registryNBT);
        if (this.slotToBuild instanceof BuildingSlotBlock) {
            nbt.setByte("slotKind", (byte)0);
        } else {
            nbt.setByte("slotKind", (byte)1);
        }
        nbt.setTag("slotToBuild", (NBTBase)slotNBT);
    }

    public void readFromNBT(NBTTagCompound nbt) throws MappingNotFoundException {
        this.origin = new Position(nbt.getCompoundTag("origin"));
        this.destination = new Position(nbt.getCompoundTag("destination"));
        this.lifetime = nbt.getFloat("lifetime");
        NBTTagList items = nbt.getTagList("items", 10);
        for (int i = 0; i < items.tagCount(); ++i) {
            StackAtPosition sPos = new StackAtPosition();
            sPos.stack = ItemStack.loadItemStackFromNBT((NBTTagCompound)items.getCompoundTagAt(i));
            this.stacksToDisplay.add(sPos);
        }
        MappingRegistry registry = new MappingRegistry();
        registry.read(nbt.getCompoundTag("registry"));
        this.slotToBuild = nbt.getByte("slotKind") == 0 ? new BuildingSlotBlock() : new BuildingSlotEntity();
        this.slotToBuild.readFromNBT(nbt.getCompoundTag("slotToBuild"), registry);
    }

    public void setStacksToDisplay(LinkedList<ItemStack> stacks) {
        if (stacks != null) {
            for (ItemStack s : stacks) {
                for (int i = 0; i < s.stackSize; ++i) {
                    StackAtPosition sPos = new StackAtPosition();
                    sPos.stack = s.copy();
                    sPos.stack.stackSize = 1;
                    this.stacksToDisplay.add(sPos);
                }
            }
        }
    }

    @Override
    public void readData(ByteBuf stream) {
        this.origin = new Position();
        this.destination = new Position();
        this.origin.readData(stream);
        this.destination.readData(stream);
        this.lifetime = stream.readFloat();
        this.stacksToDisplay.clear();
        int size = stream.readUnsignedShort();
        for (int i = 0; i < size; ++i) {
            StackAtPosition e = new StackAtPosition();
            e.readData(stream);
            this.stacksToDisplay.add(e);
        }
    }

    @Override
    public void writeData(ByteBuf stream) {
        this.origin.writeData(stream);
        this.destination.writeData(stream);
        stream.writeFloat(this.lifetime);
        stream.writeShort(this.stacksToDisplay.size());
        for (StackAtPosition s : this.stacksToDisplay) {
            s.writeData(stream);
        }
    }

    public int hashCode() {
        return 131 * this.origin.hashCode() + this.destination.hashCode();
    }
}

