/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.builders;

import buildcraft.api.blueprints.BuildingPermission;
import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.MappingNotFoundException;
import buildcraft.api.blueprints.MappingRegistry;
import buildcraft.api.blueprints.SchematicBlock;
import buildcraft.api.blueprints.SchematicBlockBase;
import buildcraft.api.blueprints.SchematicFactory;
import buildcraft.api.blueprints.SchematicMask;
import buildcraft.api.core.BCLog;
import buildcraft.api.core.Position;
import buildcraft.core.builders.BuildingSlot;
import buildcraft.core.inventory.StackHelper;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public class BuildingSlotBlock
extends BuildingSlot {
    public int x;
    public int y;
    public int z;
    public SchematicBlockBase schematic;
    public Mode mode = Mode.Build;
    public int buildStage = 0;

    @Override
    public SchematicBlockBase getSchematic() {
        if (this.schematic == null) {
            return new SchematicMask(false);
        }
        return this.schematic;
    }

    @Override
    public void writeToWorld(IBuilderContext context) {
        if (this.mode == Mode.ClearIfInvalid) {
            if (!this.getSchematic().isAlreadyBuilt(context, this.x, this.y, this.z)) {
                context.world().setBlockToAir(this.x, this.y, this.z);
            }
        } else {
            try {
                TileEntity e;
                this.getSchematic().placeInWorld(context, this.x, this.y, this.z, this.stackConsumed);
                if (!context.world().isAirBlock(this.x, this.y, this.z) && this.getSchematic().getBuildingPermission() == BuildingPermission.ALL && this.getSchematic() instanceof SchematicBlock) {
                    SchematicBlock sb = (SchematicBlock)this.getSchematic();
                    ItemStack[] oldRequirementsArray = sb.storedRequirements;
                    List<ItemStack> oldRequirements = Arrays.asList(oldRequirementsArray);
                    sb.storedRequirements = new ItemStack[0];
                    sb.storeRequirements(context, this.x, this.y, this.z);
                    for (ItemStack s : sb.storedRequirements) {
                        boolean contains = false;
                        for (ItemStack ss : oldRequirements) {
                            if (!StackHelper.isMatchingItem(s, ss)) continue;
                            contains = true;
                            break;
                        }
                        if (contains) continue;
                        BCLog.logger.warn("Blueprint has MISMATCHING REQUIREMENTS! Potential corrupted/hacked blueprint! Removed mismatched block.");
                        BCLog.logger.warn("Location: " + this.x + ", " + this.y + ", " + this.z + " - ItemStack: " + s.toString());
                        context.world().removeTileEntity(this.x, this.y, this.z);
                        context.world().setBlockToAir(this.x, this.y, this.z);
                        return;
                    }
                    sb.storedRequirements = oldRequirementsArray;
                }
                if ((e = context.world().getTileEntity(this.x, this.y, this.z)) != null) {
                    e.updateEntity();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                context.world().setBlockToAir(this.x, this.y, this.z);
            }
        }
    }

    @Override
    public void postProcessing(IBuilderContext context) {
        this.getSchematic().postProcessing(context, this.x, this.y, this.z);
    }

    @Override
    public LinkedList<ItemStack> getRequirements(IBuilderContext context) {
        if (this.mode == Mode.ClearIfInvalid) {
            return new LinkedList<ItemStack>();
        }
        LinkedList<ItemStack> req = new LinkedList<ItemStack>();
        this.getSchematic().getRequirementsForPlacement(context, req);
        return req;
    }

    @Override
    public Position getDestination() {
        return new Position((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5);
    }

    @Override
    public void writeCompleted(IBuilderContext context, double complete) {
        if (this.mode == Mode.ClearIfInvalid) {
            context.world().destroyBlockInWorldPartially(0, this.x, this.y, this.z, (int)(complete * 10.0) - 1);
        }
    }

    @Override
    public boolean isAlreadyBuilt(IBuilderContext context) {
        return this.schematic.isAlreadyBuilt(context, this.x, this.y, this.z);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, MappingRegistry registry) {
        nbt.setByte("mode", (byte)this.mode.ordinal());
        nbt.setInteger("x", this.x);
        nbt.setInteger("y", this.y);
        nbt.setInteger("z", this.z);
        if (this.schematic != null) {
            NBTTagCompound schematicNBT = new NBTTagCompound();
            SchematicFactory.getFactory(this.schematic.getClass()).saveSchematicToWorldNBT(schematicNBT, this.schematic, registry);
            nbt.setTag("schematic", (NBTBase)schematicNBT);
        }
        NBTTagList nbtStacks = new NBTTagList();
        if (this.stackConsumed != null) {
            for (ItemStack stack : this.stackConsumed) {
                NBTTagCompound nbtStack = new NBTTagCompound();
                stack.writeToNBT(nbtStack);
                nbtStacks.appendTag((NBTBase)nbtStack);
            }
        }
        nbt.setTag("stackConsumed", (NBTBase)nbtStacks);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, MappingRegistry registry) throws MappingNotFoundException {
        this.mode = Mode.values()[nbt.getByte("mode")];
        this.x = nbt.getInteger("x");
        this.y = nbt.getInteger("y");
        this.z = nbt.getInteger("z");
        if (nbt.hasKey("schematic")) {
            this.schematic = (SchematicBlockBase)SchematicFactory.createSchematicFromWorldNBT(nbt.getCompoundTag("schematic"), registry);
        }
        this.stackConsumed = new LinkedList();
        NBTTagList nbtStacks = nbt.getTagList("stackConsumed", 10);
        for (int i = 0; i < nbtStacks.tagCount(); ++i) {
            this.stackConsumed.add(ItemStack.loadItemStackFromNBT((NBTTagCompound)nbtStacks.getCompoundTagAt(i)));
        }
    }

    @Override
    public LinkedList<ItemStack> getStacksToDisplay() {
        if (this.mode == Mode.ClearIfInvalid) {
            return this.stackConsumed;
        }
        return this.getSchematic().getStacksToDisplay(this.stackConsumed);
    }

    @Override
    public int getEnergyRequirement() {
        return this.schematic.getEnergyRequirement(this.stackConsumed);
    }

    @Override
    public int buildTime() {
        if (this.schematic == null) {
            return 1;
        }
        return this.schematic.buildTime();
    }

    public static enum Mode {
        ClearIfInvalid,
        Build;

    }
}

