/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.builders.patterns;

import buildcraft.api.statements.IStatementParameter;
import buildcraft.core.Box;
import buildcraft.core.blueprints.Template;
import buildcraft.core.builders.patterns.FillerPattern;
import net.minecraft.world.World;

public class PatternCylinder
extends FillerPattern {
    public PatternCylinder() {
        super("cylinder");
    }

    @Override
    public Template getTemplate(Box box, World world, IStatementParameter[] parameters) {
        int stoppingZ;
        Template result = new Template(box.sizeX(), box.sizeY(), box.sizeZ());
        int xMin = 0;
        int yMin = 0;
        int zMin = 0;
        int xMax = box.sizeX() - 1;
        int yMax = box.sizeY() - 1;
        int zMax = box.sizeZ() - 1;
        int xFix = (xMax - xMin) % 2;
        int zFix = (zMax - zMin) % 2;
        int xCenter = (xMax + xMin) / 2 + (xMax + xMin < 0 && xFix == 1 ? -1 : 0);
        int zCenter = (zMax + zMin) / 2 + (zMax + zMin < 0 && zFix == 1 ? -1 : 0);
        int xRadius = (xMax - xMin) / 2;
        int zRadius = (zMax - zMin) / 2;
        if (xRadius == 0 || zRadius == 0) {
            PatternCylinder.fill(xMin, yMin, zMin, xMax, yMax, zMax, result);
        }
        int dx = xRadius;
        int dz = 0;
        int xChange = zRadius * zRadius * (1 - 2 * xRadius);
        int zChange = xRadius * xRadius;
        int ellipseError = 0;
        int twoASquare = 2 * xRadius * xRadius;
        int twoBSquare = 2 * zRadius * zRadius;
        int stoppingX = twoBSquare * xRadius;
        if (twoASquare > 0) {
            for (stoppingZ = 0; stoppingX >= stoppingZ; stoppingZ += twoASquare) {
                this.fillFourColumns(xCenter, zCenter, dx, dz, xFix, zFix, yMin, yMax, result);
                ++dz;
                if (2 * (ellipseError += (zChange += twoASquare)) + xChange <= 0) continue;
                --dx;
                stoppingX -= twoBSquare;
                ellipseError += xChange;
                xChange += twoBSquare;
            }
        }
        dx = 0;
        dz = zRadius;
        xChange = zRadius * zRadius;
        zChange = xRadius * xRadius * (1 - 2 * zRadius);
        ellipseError = 0;
        stoppingZ = twoASquare * zRadius;
        if (twoBSquare > 0) {
            for (stoppingX = 0; stoppingX <= stoppingZ; stoppingX += twoBSquare) {
                this.fillFourColumns(xCenter, zCenter, dx, dz, xFix, zFix, yMin, yMax, result);
                ++dx;
                if (2 * (ellipseError += (xChange += twoBSquare)) + zChange <= 0) continue;
                --dz;
                stoppingZ -= twoASquare;
                ellipseError += zChange;
                zChange += twoASquare;
            }
        }
        return result;
    }

    private boolean fillFourColumns(int xCenter, int zCenter, int dx, int dz, int xFix, int zFix, int yMin, int yMax, Template template) {
        int x = xCenter + dx + xFix;
        int z = zCenter + dz + zFix;
        PatternCylinder.fill(x, yMin, z, x, yMax, z, template);
        x = xCenter - dx;
        z = zCenter + dz + zFix;
        PatternCylinder.fill(x, yMin, z, x, yMax, z, template);
        x = xCenter - dx;
        z = zCenter - dz;
        PatternCylinder.fill(x, yMin, z, x, yMax, z, template);
        x = xCenter + dx + xFix;
        z = zCenter - dz;
        PatternCylinder.fill(x, yMin, z, x, yMax, z, template);
        return true;
    }
}

