/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.builders.patterns;

import buildcraft.api.blueprints.SchematicMask;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.core.Box;
import buildcraft.core.blueprints.Template;
import buildcraft.core.builders.patterns.FillerPattern;
import buildcraft.core.builders.patterns.PatternParameterYDir;
import net.minecraft.world.World;

public class PatternPyramid
extends FillerPattern {
    public PatternPyramid() {
        super("pyramid");
    }

    @Override
    public int maxParameters() {
        return 1;
    }

    @Override
    public int minParameters() {
        return 1;
    }

    @Override
    public IStatementParameter createParameter(int index) {
        return new PatternParameterYDir(true);
    }

    @Override
    public Template getTemplate(Box box, World world, IStatementParameter[] parameters) {
        int xMin = (int)box.pMin().x;
        int yMin = (int)box.pMin().y;
        int zMin = (int)box.pMin().z;
        int xMax = (int)box.pMax().x;
        int yMax = (int)box.pMax().y;
        int zMax = (int)box.pMax().z;
        Template bpt = new Template(xMax - xMin + 1, yMax - yMin + 1, zMax - zMin + 1);
        int xSize = xMax - xMin + 1;
        int zSize = zMax - zMin + 1;
        int step = 0;
        int stepY = parameters[0] != null && !((PatternParameterYDir)parameters[0]).up ? -1 : 1;
        for (int height = stepY == 1 ? yMin : yMax; step <= xSize / 2 && step <= zSize / 2 && height >= yMin && height <= yMax; ++step, height += stepY) {
            for (int x = xMin + step; x <= xMax - step; ++x) {
                for (int z = zMin + step; z <= zMax - step; ++z) {
                    bpt.contents[x - xMin][height - yMin][z - zMin] = new SchematicMask(true);
                }
            }
        }
        return bpt;
    }
}

