/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.gui;

import buildcraft.core.DefaultProps;
import buildcraft.core.gui.GuiAdvancedInterface;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public abstract class AdvancedSlot {
    private static final ResourceLocation TEXTURE_SLOT = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_GUI + "/slot.png");
    public int x;
    public int y;
    public GuiAdvancedInterface gui;
    public boolean drawBackround = false;

    public AdvancedSlot(GuiAdvancedInterface gui, int x, int y) {
        this.x = x;
        this.y = y;
        this.gui = gui;
    }

    public String getDescription() {
        return null;
    }

    public final void drawTooltip(GuiAdvancedInterface gui, int x, int y) {
        String s = StatCollector.translateToLocal((String)this.getDescription());
        if (s != null) {
            gui.drawTooltip(s, x, y);
        } else {
            ItemStack stack = this.getItemStack();
            if (stack != null) {
                int cornerX = (gui.width - gui.getXSize()) / 2;
                int cornerY = (gui.height - gui.getYSize()) / 2;
                int xS = x - cornerX;
                int yS = y - cornerY;
                gui.renderToolTip(stack, xS, yS);
            }
        }
    }

    public IIcon getIcon() {
        return null;
    }

    public ResourceLocation getTexture() {
        return TextureMap.locationItemsTexture;
    }

    public ItemStack getItemStack() {
        return null;
    }

    public boolean isDefined() {
        return true;
    }

    public void drawSprite(int cornerX, int cornerY) {
        Minecraft mc = Minecraft.getMinecraft();
        if (this.drawBackround) {
            mc.renderEngine.bindTexture(TEXTURE_SLOT);
            this.gui.drawTexturedModalRect(cornerX + this.x - 1, cornerY + this.y - 1, 0, 0, 18, 18);
        }
        if (!this.isDefined()) {
            return;
        }
        if (this.getItemStack() != null) {
            this.drawStack(this.getItemStack());
        } else if (this.getIcon() != null) {
            mc.renderEngine.bindTexture(this.getTexture());
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3008);
            GL11.glEnable((int)3042);
            this.gui.drawTexturedModelRectFromIcon(cornerX + this.x, cornerY + this.y, this.getIcon(), 16, 16);
            GL11.glEnable((int)2896);
            GL11.glDisable((int)3008);
            GL11.glDisable((int)3042);
        }
    }

    public void drawStack(ItemStack item) {
        int cornerX = (this.gui.width - this.gui.getXSize()) / 2;
        int cornerY = (this.gui.height - this.gui.getYSize()) / 2;
        this.gui.drawStack(item, cornerX + this.x, cornerY + this.y);
    }

    public void selected() {
    }
}

