/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.gui;

import buildcraft.BuildCraftCore;
import buildcraft.core.ItemList;
import buildcraft.core.gui.BuildCraftContainer;
import buildcraft.core.network.CommandWriter;
import buildcraft.core.network.ICommandReceiver;
import buildcraft.core.network.PacketCommand;
import buildcraft.core.utils.Utils;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerList
extends BuildCraftContainer
implements ICommandReceiver {
    public ItemList.StackLine[] lines;
    private EntityPlayer player;

    public ContainerList(EntityPlayer iPlayer) {
        super(iPlayer.inventory.getSizeInventory());
        this.player = iPlayer;
        this.lines = ItemList.getLines(this.player.getCurrentEquippedItem());
        for (int sy = 0; sy < 3; ++sy) {
            for (int sx = 0; sx < 9; ++sx) {
                this.addSlotToContainer(new Slot((IInventory)this.player.inventory, sx + sy * 9 + 9, 8 + sx * 18, 153 + sy * 18));
            }
        }
        for (int sx = 0; sx < 9; ++sx) {
            this.addSlotToContainer(new Slot((IInventory)this.player.inventory, sx, 8 + sx * 18, 211));
        }
    }

    public boolean canInteractWith(EntityPlayer player) {
        return true;
    }

    public void setStack(final int lineIndex, final int slotIndex, final ItemStack stack) {
        this.lines[lineIndex].setStack(slotIndex, stack);
        ItemList.saveLine(this.player.getCurrentEquippedItem(), this.lines[lineIndex], lineIndex);
        if (this.player.worldObj.isRemote) {
            BuildCraftCore.instance.sendToServer(new PacketCommand(this, "setStack", new CommandWriter(){

                @Override
                public void write(ByteBuf data) {
                    data.writeByte(lineIndex);
                    data.writeByte(slotIndex);
                    Utils.writeStack(data, stack);
                }
            }));
        }
    }

    public void switchButton(final int lineIndex, final int button) {
        if (button == 0) {
            this.lines[lineIndex].oreWildcard = false;
            this.lines[lineIndex].subitemsWildcard = !this.lines[lineIndex].subitemsWildcard;
        } else if (button == 1 && this.lines[lineIndex].isOre) {
            this.lines[lineIndex].subitemsWildcard = false;
            this.lines[lineIndex].oreWildcard = !this.lines[lineIndex].oreWildcard;
        }
        ItemList.saveLine(this.player.getCurrentEquippedItem(), this.lines[lineIndex], lineIndex);
        if (this.player.worldObj.isRemote) {
            BuildCraftCore.instance.sendToServer(new PacketCommand(this, "switchButton", new CommandWriter(){

                @Override
                public void write(ByteBuf data) {
                    data.writeByte(lineIndex);
                    data.writeByte(button);
                }
            }));
        }
    }

    public void setLabel(final String text) {
        ItemList.saveLabel(this.player.getCurrentEquippedItem(), text);
        if (this.player.worldObj.isRemote) {
            BuildCraftCore.instance.sendToServer(new PacketCommand(this, "setLabel", new CommandWriter(){

                @Override
                public void write(ByteBuf data) {
                    Utils.writeUTF(data, text);
                }
            }));
        }
    }

    @Override
    public void receiveCommand(String command, Side side, Object sender, ByteBuf stream) {
        if (side.isServer()) {
            if ("setLabel".equals(command)) {
                this.setLabel(Utils.readUTF(stream));
            } else if ("switchButton".equals(command)) {
                this.switchButton(stream.readUnsignedByte(), stream.readUnsignedByte());
            } else if ("setStack".equals(command)) {
                this.setStack(stream.readUnsignedByte(), stream.readUnsignedByte(), Utils.readStack(stream));
            }
        }
    }
}

