/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.gui;

import buildcraft.core.gui.AdvancedSlot;
import buildcraft.core.gui.BuildCraftContainer;
import buildcraft.core.gui.GuiBuildCraft;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public abstract class GuiAdvancedInterface
extends GuiBuildCraft {
    public ArrayList<AdvancedSlot> slots = new ArrayList();

    public GuiAdvancedInterface(BuildCraftContainer container, IInventory inventory, ResourceLocation texture) {
        super(container, inventory, texture);
    }

    public int getSlotIndexAtLocation(int i, int j) {
        int x = i - this.guiLeft;
        int y = j - this.guiTop;
        for (int position = 0; position < this.slots.size(); ++position) {
            AdvancedSlot s = this.slots.get(position);
            if (s == null || x < s.x || x > s.x + 16 || y < s.y || y > s.y + 16) continue;
            return position;
        }
        return -1;
    }

    public AdvancedSlot getSlotAtLocation(int i, int j) {
        int id = this.getSlotIndexAtLocation(i, j);
        if (id != -1) {
            return this.slots.get(id);
        }
        return null;
    }

    protected void drawBackgroundSlots() {
        RenderHelper.enableGUIStandardItemLighting();
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)32826);
        int i1 = 240;
        int k1 = 240;
        OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)((float)i1 / 1.0f), (float)((float)k1 / 1.0f));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.slots != null) {
            for (AdvancedSlot slot : this.slots) {
                if (slot == null) continue;
                slot.drawSprite(this.guiLeft, this.guiTop);
            }
        }
        GL11.glPopMatrix();
    }

    public void drawTooltipForSlotAt(int mouseX, int mouseY) {
        AdvancedSlot slot = this.getSlotAtLocation(mouseX, mouseY);
        if (slot != null) {
            slot.drawTooltip(this, mouseX, mouseY);
        }
    }

    public void drawTooltip(String caption, int mouseX, int mouseY) {
        if (caption.length() > 0) {
            int i2 = mouseX - this.guiLeft;
            int k2 = mouseY - this.guiTop;
            this.drawCreativeTabHoveringText(caption, i2, k2);
            RenderHelper.enableGUIStandardItemLighting();
        }
    }

    public static RenderItem getItemRenderer() {
        return itemRender;
    }

    public int getXSize() {
        return this.xSize;
    }

    public int getYSize() {
        return this.ySize;
    }

    public void renderToolTip(ItemStack stack, int x, int y) {
        super.renderToolTip(stack, x, y);
    }

    public void drawStack(ItemStack item, int x, int y) {
        Minecraft mc = Minecraft.getMinecraft();
        if (item != null) {
            GL11.glEnable((int)2896);
            float prevZ = GuiAdvancedInterface.getItemRenderer().zLevel;
            GuiAdvancedInterface.getItemRenderer().zLevel = 200.0f;
            GuiAdvancedInterface.getItemRenderer().renderItemAndEffectIntoGUI(this.getFontRenderer(), mc.renderEngine, item, x, y);
            GuiAdvancedInterface.getItemRenderer().renderItemOverlayIntoGUI(this.getFontRenderer(), mc.renderEngine, item, x, y);
            GuiAdvancedInterface.getItemRenderer().zLevel = prevZ;
            GL11.glDisable((int)2896);
        }
    }

    @Override
    protected void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        AdvancedSlot slot = this.getSlotAtLocation(mouseX, mouseY);
        if (slot != null && slot.isDefined()) {
            this.slotClicked(slot, mouseButton);
        }
    }

    public void resetNullSlots(int size) {
        this.slots.clear();
        for (int i = 0; i < size; ++i) {
            this.slots.add(null);
        }
    }

    protected void slotClicked(AdvancedSlot slot, int mouseButton) {
    }
}

