/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.gui;

import buildcraft.BuildCraftCore;
import buildcraft.core.DefaultProps;
import buildcraft.core.ItemList;
import buildcraft.core.gui.AdvancedSlot;
import buildcraft.core.gui.ContainerList;
import buildcraft.core.gui.GuiAdvancedInterface;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class GuiList
extends GuiAdvancedInterface {
    private static final ResourceLocation TEXTURE_BASE = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_GUI + "/list.png");
    private GuiTextField textField;
    private EntityPlayer player;

    public GuiList(EntityPlayer iPlayer) {
        super(new ContainerList(iPlayer), (IInventory)iPlayer.inventory, TEXTURE_BASE);
        this.xSize = 176;
        this.ySize = 241;
        for (int sy = 0; sy < 6; ++sy) {
            this.slots.add(new MainSlot(this, 44, 31 + sy * 18, sy));
            for (int sx = 1; sx < 7; ++sx) {
                this.slots.add(new SecondarySlot(this, 44 + sx * 18, 31 + sy * 18, sy, sx));
            }
            this.slots.add(new Button(this, 8, 31 + sy * 18, sy, 0, "gui.list.metadata"));
            this.slots.add(new Button(this, 26, 31 + sy * 18, sy, 1, "gui.list.oredict"));
        }
        this.player = iPlayer;
    }

    public void initGui() {
        super.initGui();
        this.textField = new GuiTextField(this.fontRendererObj, 10, 10, 156, 12);
        this.textField.setMaxStringLength(32);
        this.textField.setText(BuildCraftCore.listItem.getLabel(this.player.getCurrentEquippedItem()));
        this.textField.setFocused(false);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f, int x, int y) {
        int i;
        super.drawGuiContainerBackgroundLayer(f, x, y);
        ContainerList container = (ContainerList)this.getContainer();
        this.bindTexture(TEXTURE_BASE);
        for (i = 0; i < 6; ++i) {
            if (container.lines[i].subitemsWildcard) {
                this.drawTexturedModalRect(this.guiLeft + 7, this.guiTop + 30 + 18 * i, 194, 18, 18, 18);
            } else {
                this.drawTexturedModalRect(this.guiLeft + 7, this.guiTop + 30 + 18 * i, 194, 0, 18, 18);
            }
            if (container.lines[i].isOre) {
                if (container.lines[i].oreWildcard) {
                    this.drawTexturedModalRect(this.guiLeft + 25, this.guiTop + 30 + 18 * i, 176, 18, 18, 18);
                } else {
                    this.drawTexturedModalRect(this.guiLeft + 25, this.guiTop + 30 + 18 * i, 176, 0, 18, 18);
                }
            }
            if (!container.lines[i].subitemsWildcard && !container.lines[i].oreWildcard) continue;
            for (int j = 0; j < 6; ++j) {
                this.drawTexturedModalRect(this.guiLeft + 62 + 18 * j, this.guiTop + 31 + 18 * i, 195, 37, 16, 16);
            }
        }
        this.drawBackgroundSlots();
        this.bindTexture(TEXTURE_BASE);
        for (i = 0; i < 6; ++i) {
            if (container.lines[i].getStack(7) == null) continue;
            this.drawTexturedModalRect(this.guiLeft + 152, this.guiTop + 31 + 18 * i, 177, 37, 16, 16);
        }
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int par1, int par2) {
        super.drawGuiContainerForegroundLayer(par1, par2);
        this.textField.drawTextBox();
        this.drawTooltipForSlotAt(par1, par2);
    }

    private boolean isCarryingList() {
        ItemStack stack = this.mc.thePlayer.inventory.getItemStack();
        return stack != null && stack.getItem() instanceof ItemList;
    }

    private boolean hasListEquipped() {
        return this.mc.thePlayer.getCurrentEquippedItem() != null && this.mc.thePlayer.getCurrentEquippedItem().getItem() instanceof ItemList;
    }

    @Override
    protected void mouseClicked(int x, int y, int b) {
        super.mouseClicked(x, y, b);
        if (this.isCarryingList() || !this.hasListEquipped()) {
            return;
        }
        AdvancedSlot slot = this.getSlotAtLocation(x, y);
        ContainerList container = (ContainerList)this.getContainer();
        if (slot instanceof MainSlot) {
            container.setStack(((MainSlot)slot).lineIndex, 0, this.mc.thePlayer.inventory.getItemStack());
        } else if (slot instanceof SecondarySlot) {
            container.setStack(((SecondarySlot)slot).lineIndex, ((SecondarySlot)slot).slotIndex, this.mc.thePlayer.inventory.getItemStack());
        } else if (slot instanceof Button) {
            Button button = (Button)slot;
            container.switchButton(button.line, button.kind);
        }
        this.textField.mouseClicked(x - this.guiLeft, y - this.guiTop, b);
    }

    protected void keyTyped(char c, int i) {
        if (this.textField.isFocused()) {
            if (c == '\r' || c == '\u001b') {
                this.textField.setFocused(false);
            } else {
                this.textField.textboxKeyTyped(c, i);
                ((ContainerList)this.container).setLabel(this.textField.getText());
            }
        } else {
            super.keyTyped(c, i);
        }
    }

    private static class Button
    extends AdvancedSlot {
        public int line;
        public int kind;
        private String desc;

        public Button(GuiAdvancedInterface gui, int x, int y, int iLine, int iKind, String iDesc) {
            super(gui, x, y);
            this.line = iLine;
            this.kind = iKind;
            this.desc = iDesc;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }
    }

    private static class SecondarySlot
    extends AdvancedSlot {
        public int lineIndex;
        public int slotIndex;

        public SecondarySlot(GuiAdvancedInterface gui, int x, int y, int iLineIndex, int iSlotIndex) {
            super(gui, x, y);
            this.lineIndex = iLineIndex;
            this.slotIndex = iSlotIndex;
        }

        @Override
        public ItemStack getItemStack() {
            ContainerList container = (ContainerList)this.gui.getContainer();
            if (this.slotIndex == 6 && container.lines[this.lineIndex].getStack(7) != null) {
                return null;
            }
            if (container.lines[this.lineIndex].getStack(this.slotIndex) != null) {
                return container.lines[this.lineIndex].getStack(this.slotIndex);
            }
            return null;
        }
    }

    private static class MainSlot
    extends AdvancedSlot {
        public int lineIndex;

        public MainSlot(GuiAdvancedInterface gui, int x, int y, int iLineIndex) {
            super(gui, x, y);
            this.lineIndex = iLineIndex;
        }

        @Override
        public ItemStack getItemStack() {
            ContainerList container = (ContainerList)this.gui.getContainer();
            if (container.lines[this.lineIndex].getStack(0) != null) {
                return container.lines[this.lineIndex].getStack(0);
            }
            return null;
        }
    }
}

