/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.gui;

import buildcraft.api.statements.IStatementParameter;
import buildcraft.core.gui.AdvancedSlot;
import buildcraft.core.gui.GuiAdvancedInterface;
import buildcraft.core.gui.StatementSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public abstract class StatementParameterSlot
extends AdvancedSlot {
    public int slot;
    public StatementSlot statementSlot;

    public StatementParameterSlot(GuiAdvancedInterface gui, int x, int y, int slot, StatementSlot iStatementSlot) {
        super(gui, x, y);
        this.slot = slot;
        this.statementSlot = iStatementSlot;
        this.statementSlot.parameters.add(this);
    }

    @Override
    public boolean isDefined() {
        return this.getParameter() != null;
    }

    @Override
    public String getDescription() {
        IStatementParameter parameter = this.getParameter();
        if (parameter != null) {
            return parameter.getDescription() != null ? parameter.getDescription() : "";
        }
        return null;
    }

    @Override
    public ItemStack getItemStack() {
        IStatementParameter parameter = this.getParameter();
        if (parameter != null) {
            return parameter.getItemStack();
        }
        return null;
    }

    @Override
    public IIcon getIcon() {
        IStatementParameter parameter = this.getParameter();
        if (parameter != null) {
            return parameter.getIcon();
        }
        return null;
    }

    public abstract IStatementParameter getParameter();

    public boolean isAllowed() {
        return this.statementSlot.getStatement() != null && this.slot < this.statementSlot.getStatement().maxParameters();
    }

    public boolean isRequired() {
        return this.statementSlot.getStatement() != null && this.slot < this.statementSlot.getStatement().minParameters();
    }

    public abstract void setParameter(IStatementParameter var1, boolean var2);
}

