/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.gui.buttons;

import buildcraft.core.DefaultProps;
import buildcraft.core.gui.buttons.IButtonClickEventListener;
import buildcraft.core.gui.buttons.IButtonClickEventTrigger;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiImageButton
extends GuiButton
implements IButtonClickEventTrigger {
    public static final ResourceLocation ICON_BUTTON_TEXTURES = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_GUI + "/icon_button.png");
    public static final int SIZE = 18;
    private ArrayList<IButtonClickEventListener> listeners = new ArrayList();
    private ButtonImage image = ButtonImage.BLANK;
    private boolean active = false;

    public GuiImageButton(int id, int x, int y, ButtonImage image) {
        super(id, x, y, 18, 18, "");
        this.image = image;
    }

    public boolean isActive() {
        return this.active;
    }

    public void activate() {
        this.active = true;
    }

    public void deActivate() {
        this.active = false;
    }

    public void drawButton(Minecraft minecraft, int x, int y) {
        if (!this.visible) {
            return;
        }
        minecraft.renderEngine.bindTexture(ICON_BUTTON_TEXTURES);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int buttonState = this.getButtonState(x, y);
        this.drawTexturedModalRect(this.xPosition, this.yPosition, buttonState * 18, 0, 18, 18);
        this.drawTexturedModalRect(this.xPosition + 1, this.yPosition + 1, this.image.getU(), this.image.getV(), 16, 16);
        this.mouseDragged(minecraft, x, y);
    }

    public boolean mousePressed(Minecraft par1Minecraft, int par2, int par3) {
        boolean pressed = super.mousePressed(par1Minecraft, par2, par3);
        if (pressed) {
            this.active = !this.active;
            this.notifyAllListeners();
        }
        return pressed;
    }

    @Override
    public void registerListener(IButtonClickEventListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(IButtonClickEventListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void notifyAllListeners() {
        for (IButtonClickEventListener listener : this.listeners) {
            listener.handleButtonClick(this, this.id);
        }
    }

    private int getButtonState(int mouseX, int mouseY) {
        if (!this.enabled) {
            return 0;
        }
        if (this.isMouseOverButton(mouseX, mouseY)) {
            if (!this.active) {
                return 2;
            }
            return 4;
        }
        if (!this.active) {
            return 1;
        }
        return 3;
    }

    private boolean isMouseOverButton(int mouseX, int mouseY) {
        return mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + 18 && mouseY < this.yPosition + 18;
    }

    public static enum ButtonImage {
        BLANK(1, 19),
        WHITE_LIST(19, 19),
        BLACK_LIST(37, 19),
        ROUND_ROBIN(55, 19);

        private final int u;
        private final int v;

        private ButtonImage(int u, int v) {
            this.u = u;
            this.v = v;
        }

        public int getU() {
            return this.u;
        }

        public int getV() {
            return this.v;
        }
    }
}

